/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.network.http;

import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Operations;
import com.apollographql.apollo3.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpRequestComposer;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.api.json.-JsonReaders;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.exception.ApolloParseException;
import com.apollographql.apollo3.internal.NonMainWorker;
import com.apollographql.apollo3.mpp.UtilsKt;
import com.apollographql.apollo3.network.NetworkTransport;
import com.apollographql.apollo3.network.http.DefaultHttpEngine;
import com.apollographql.apollo3.network.http.DefaultHttpInterceptorChain;
import com.apollographql.apollo3.network.http.HeadersInterceptor;
import com.apollographql.apollo3.network.http.HttpEngine;
import com.apollographql.apollo3.network.http.HttpInfo;
import com.apollographql.apollo3.network.http.HttpInterceptor;
import com.apollographql.apollo3.network.http.HttpInterceptorChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0003!\"#B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J,\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00160\u0015\"\b\b\u0000\u0010\u0017*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0016J:\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u00160\u0015\"\b\b\u0000\u0010\u0017*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/apollographql/apollo3/network/http/HttpNetworkTransport;", "Lcom/apollographql/apollo3/network/NetworkTransport;", "httpRequestComposer", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "engine", "Lcom/apollographql/apollo3/network/http/HttpEngine;", "interceptors", "", "Lcom/apollographql/apollo3/network/http/HttpInterceptor;", "(Lcom/apollographql/apollo3/api/http/HttpRequestComposer;Lcom/apollographql/apollo3/network/http/HttpEngine;Ljava/util/List;)V", "getEngine", "()Lcom/apollographql/apollo3/network/http/HttpEngine;", "engineInterceptor", "Lcom/apollographql/apollo3/network/http/HttpNetworkTransport$EngineInterceptor;", "getInterceptors", "()Ljava/util/List;", "worker", "Lcom/apollographql/apollo3/internal/NonMainWorker;", "dispose", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "request", "Lcom/apollographql/apollo3/api/ApolloRequest;", "httpRequest", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "customScalarAdapters", "Lcom/apollographql/apollo3/api/CustomScalarAdapters;", "newBuilder", "Lcom/apollographql/apollo3/network/http/HttpNetworkTransport$Builder;", "Builder", "Companion", "EngineInterceptor", "apollo-runtime"})
public final class HttpNetworkTransport
implements NetworkTransport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpRequestComposer httpRequestComposer;
    @NotNull
    private final HttpEngine engine;
    @NotNull
    private final List<HttpInterceptor> interceptors;
    @NotNull
    private final NonMainWorker worker;
    @NotNull
    private final EngineInterceptor engineInterceptor;

    private HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine engine, List<? extends HttpInterceptor> interceptors) {
        this.httpRequestComposer = httpRequestComposer;
        this.engine = engine;
        this.interceptors = interceptors;
        this.worker = new NonMainWorker();
        this.engineInterceptor = new EngineInterceptor();
    }

    /* synthetic */ HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine httpEngine, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpEngine = new DefaultHttpEngine(0L, 1, null);
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(httpRequestComposer, httpEngine, list);
    }

    @NotNull
    public final HttpEngine getEngine() {
        return this.engine;
    }

    @NotNull
    public final List<HttpInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> execute(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        ExecutionContext.Element element = request.getExecutionContext().get((ExecutionContext.Key)CustomScalarAdapters.Key);
        Intrinsics.checkNotNull((Object)element);
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)element;
        HttpRequest httpRequest2 = this.httpRequestComposer.compose(request);
        return this.execute(request, httpRequest2, customScalarAdapters);
    }

    @NotNull
    public final <D extends Operation.Data> Flow<ApolloResponse<D>> execute(@NotNull ApolloRequest<D> request, @NotNull HttpRequest httpRequest2, @NotNull CustomScalarAdapters customScalarAdapters) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)httpRequest2, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)customScalarAdapters, (String)"customScalarAdapters");
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super ApolloResponse<D>>, Continuation<? super Unit>, Object>(this, httpRequest2, request, customScalarAdapters, null){
            Object L$1;
            long J$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HttpNetworkTransport this$0;
            final /* synthetic */ HttpRequest $httpRequest;
            final /* synthetic */ ApolloRequest<D> $request;
            final /* synthetic */ CustomScalarAdapters $customScalarAdapters;
            {
                this.this$0 = $receiver;
                this.$httpRequest = $httpRequest;
                this.$request = $request;
                this.$customScalarAdapters = $customScalarAdapters;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        millisStart = UtilsKt.currentTimeMillis();
                        this.L$0 = $this$flow;
                        this.J$0 = millisStart;
                        this.label = 1;
                        v0 = new DefaultHttpInterceptorChain(CollectionsKt.plus((Collection)this.this$0.getInterceptors(), (Object)HttpNetworkTransport.access$getEngineInterceptor$p(this.this$0)), 0).proceed(this.$httpRequest, (Continuation<? super HttpResponse>)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        millisStart = this.J$0;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (!(200 <= (var6_6 = (httpResponse = (HttpResponse)v0).getStatusCode()) ? var6_6 < 300 : false)) {
                            v1 = httpResponse.getBody();
                            throw new ApolloHttpException(httpResponse.getStatusCode(), httpResponse.getHeaders(), "Http request failed with status code `" + httpResponse.getStatusCode() + " (" + (v1 == null ? null : v1.readUtf8()) + ")`", null, 8, null);
                        }
                        operation = this.$request.getOperation();
                        this.L$0 = $this$flow;
                        this.L$1 = httpResponse;
                        this.J$0 = millisStart;
                        this.label = 2;
                        v2 = HttpNetworkTransport.access$getWorker$p(this.this$0).doWork((Function0)new Function0<ApolloResponse<D>>(operation, httpResponse, this.$customScalarAdapters){
                            final /* synthetic */ Operation<D> $operation;
                            final /* synthetic */ HttpResponse $httpResponse;
                            final /* synthetic */ CustomScalarAdapters $customScalarAdapters;
                            {
                                this.$operation = $operation;
                                this.$httpResponse = $httpResponse;
                                this.$customScalarAdapters = $customScalarAdapters;
                                super(0);
                            }

                            @NotNull
                            public final ApolloResponse<D> invoke() {
                                ApolloResponse apolloResponse;
                                try {
                                    BufferedSource bufferedSource = this.$httpResponse.getBody();
                                    Intrinsics.checkNotNull((Object)bufferedSource);
                                    apolloResponse = Operations.parseJsonResponse(this.$operation, (JsonReader)-JsonReaders.jsonReader((BufferedSource)bufferedSource), (CustomScalarAdapters)this.$customScalarAdapters);
                                }
                                catch (Exception e) {
                                    throw com.apollographql.apollo3.network.http.HttpNetworkTransport$Companion.access$wrapThrowableIfNeeded(HttpNetworkTransport.Companion, e);
                                }
                                return apolloResponse;
                            }
                        }, (Continuation)this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl37
                    }
                    case 2: {
                        millisStart = this.J$0;
                        httpResponse = (HttpResponse)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl37:
                        // 2 sources

                        response = (ApolloResponse)v2;
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 3;
                        v3 = var2_3.emit((Object)response.newBuilder().requestUuid(this.$request.getRequestUuid()).addExecutionContext((ExecutionContext)new HttpInfo((long)var3_4, UtilsKt.currentTimeMillis(), httpResponse.getStatusCode(), httpResponse.getHeaders())).build(), (Continuation)this);
                        if (v3 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl48
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl48:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super ApolloResponse<D>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super ApolloResponse<D>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void dispose() {
        this.engine.dispose();
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder().httpEngine(this.engine).interceptors(this.interceptors).httpRequestComposer(this.httpRequestComposer);
    }

    public static final /* synthetic */ EngineInterceptor access$getEngineInterceptor$p(HttpNetworkTransport $this) {
        return $this.engineInterceptor;
    }

    public static final /* synthetic */ NonMainWorker access$getWorker$p(HttpNetworkTransport $this) {
        return $this.worker;
    }

    public /* synthetic */ HttpNetworkTransport(HttpRequestComposer httpRequestComposer, HttpEngine engine, List interceptors, DefaultConstructorMarker $constructor_marker) {
        this(httpRequestComposer, engine, interceptors);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo3/network/http/HttpNetworkTransport$EngineInterceptor;", "Lcom/apollographql/apollo3/network/http/HttpInterceptor;", "(Lcom/apollographql/apollo3/network/http/HttpNetworkTransport;)V", "intercept", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "request", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "chain", "Lcom/apollographql/apollo3/network/http/HttpInterceptorChain;", "(Lcom/apollographql/apollo3/api/http/HttpRequest;Lcom/apollographql/apollo3/network/http/HttpInterceptorChain;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "apollo-runtime"})
    public final class EngineInterceptor
    implements HttpInterceptor {
        public EngineInterceptor() {
            Intrinsics.checkNotNullParameter((Object)HttpNetworkTransport.this, (String)"this$0");
        }

        @Override
        @Nullable
        public Object intercept(@NotNull HttpRequest request, @NotNull HttpInterceptorChain chain, @NotNull Continuation<? super HttpResponse> $completion) {
            return HttpNetworkTransport.this.getEngine().execute(request, $completion);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004J\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/network/http/HttpNetworkTransport$Builder;", "", "()V", "engine", "Lcom/apollographql/apollo3/network/http/HttpEngine;", "httpRequestComposer", "Lcom/apollographql/apollo3/api/http/HttpRequestComposer;", "interceptors", "", "Lcom/apollographql/apollo3/network/http/HttpInterceptor;", "addInterceptor", "interceptor", "build", "Lcom/apollographql/apollo3/network/http/HttpNetworkTransport;", "httpEngine", "httpHeaders", "headers", "", "Lcom/apollographql/apollo3/api/http/HttpHeader;", "serverUrl", "", "apollo-runtime"})
    public static final class Builder {
        @Nullable
        private HttpRequestComposer httpRequestComposer;
        @Nullable
        private HttpEngine engine;
        @NotNull
        private final List<HttpInterceptor> interceptors = new ArrayList();

        @NotNull
        public final Builder httpRequestComposer(@NotNull HttpRequestComposer httpRequestComposer) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpRequestComposer, (String)"httpRequestComposer");
            Builder $this$httpRequestComposer_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$httpRequestComposer_u24lambda_u2d0.httpRequestComposer = httpRequestComposer;
            return builder;
        }

        @NotNull
        public final Builder serverUrl(@NotNull String serverUrl) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
            Builder $this$serverUrl_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$serverUrl_u24lambda_u2d1.httpRequestComposer = (HttpRequestComposer)new DefaultHttpRequestComposer(serverUrl);
            return builder;
        }

        @NotNull
        public final Builder httpHeaders(@NotNull List<HttpHeader> headers) {
            Builder builder;
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Builder $this$httpHeaders_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$httpHeaders_u24lambda_u2d2.interceptors.add(new HeadersInterceptor(headers));
            return builder;
        }

        @NotNull
        public final Builder httpEngine(@NotNull HttpEngine httpEngine) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)httpEngine, (String)"httpEngine");
            Builder $this$httpEngine_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$httpEngine_u24lambda_u2d3.engine = httpEngine;
            return builder;
        }

        @NotNull
        public final Builder interceptors(@NotNull List<? extends HttpInterceptor> interceptors) {
            Builder builder;
            Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
            Builder $this$interceptors_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$interceptors_u24lambda_u2d4.interceptors.clear();
            $this$interceptors_u24lambda_u2d4.interceptors.addAll((Collection<HttpInterceptor>)interceptors);
            return builder;
        }

        @NotNull
        public final Builder addInterceptor(@NotNull HttpInterceptor interceptor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            Builder $this$addInterceptor_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$addInterceptor_u24lambda_u2d5.interceptors.add(interceptor);
            return builder;
        }

        @NotNull
        public final HttpNetworkTransport build() {
            HttpRequestComposer httpRequestComposer = this.httpRequestComposer;
            if (httpRequestComposer == null) {
                throw new IllegalStateException("No HttpRequestComposer found. Use 'httpRequestComposer' or 'serverUrl'".toString());
            }
            HttpEngine httpEngine = this.engine;
            if (httpEngine == null) {
                httpEngine = new DefaultHttpEngine(0L, 1, null);
            }
            return new HttpNetworkTransport(httpRequestComposer, httpEngine, this.interceptors, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo3/network/http/HttpNetworkTransport$Companion;", "", "()V", "wrapThrowableIfNeeded", "Lcom/apollographql/apollo3/exception/ApolloException;", "throwable", "", "apollo-runtime"})
    public static final class Companion {
        private Companion() {
        }

        private final ApolloException wrapThrowableIfNeeded(Throwable throwable) {
            return throwable instanceof ApolloException ? (ApolloException)throwable : (ApolloException)new ApolloParseException("Failed to parse GraphQL http network response", throwable);
        }

        public static final /* synthetic */ ApolloException access$wrapThrowableIfNeeded(Companion $this, Throwable throwable) {
            return $this.wrapThrowableIfNeeded(throwable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

