/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.network.ws;

import com.apollographql.apollo3.api.Adapter;
import com.apollographql.apollo3.api.AdapterKt;
import com.apollographql.apollo3.api.AnyAdapter;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.DefaultAdaptersKt;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.http.DefaultHttpRequestComposer;
import com.apollographql.apollo3.api.internal.json.BufferedSourceJsonReader;
import com.apollographql.apollo3.api.json.JsonReader;
import com.apollographql.apollo3.network.ws.WebSocketConnection;
import com.apollographql.apollo3.network.ws.WsFrameType;
import com.apollographql.apollo3.network.ws.WsMessage;
import com.apollographql.apollo3.network.ws.WsProtocol;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0016J.\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016J.\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo3/network/ws/AppSyncWsProtocol;", "Lcom/apollographql/apollo3/network/ws/WsProtocol;", "authorization", "", "", "", "frameType", "Lcom/apollographql/apollo3/network/ws/WsFrameType;", "(Ljava/util/Map;Lcom/apollographql/apollo3/network/ws/WsFrameType;)V", "getFrameType", "()Lcom/apollographql/apollo3/network/ws/WsFrameType;", "name", "getName", "()Ljava/lang/String;", "connectionInit", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectionTerminate", "operationStart", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "request", "Lcom/apollographql/apollo3/api/ApolloRequest;", "operationStop", "parseMessage", "Lcom/apollographql/apollo3/network/ws/WsMessage;", "message", "webSocketConnection", "Lcom/apollographql/apollo3/network/ws/WebSocketConnection;", "apollo-runtime"})
public final class AppSyncWsProtocol
implements WsProtocol {
    @NotNull
    private final Map<String, Object> authorization;
    @NotNull
    private final WsFrameType frameType;

    public AppSyncWsProtocol(@NotNull Map<String, ? extends Object> authorization, @NotNull WsFrameType frameType) {
        Intrinsics.checkNotNullParameter(authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)((Object)frameType), (String)"frameType");
        this.authorization = authorization;
        this.frameType = frameType;
    }

    public /* synthetic */ AppSyncWsProtocol(Map map2, WsFrameType wsFrameType, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            wsFrameType = WsFrameType.Text;
        }
        this(map2, wsFrameType);
    }

    @Override
    @NotNull
    public WsFrameType getFrameType() {
        return this.frameType;
    }

    @Override
    @NotNull
    public String getName() {
        return "graphql-ws";
    }

    @Override
    @Nullable
    public Object connectionInit(@NotNull Continuation<? super Map<String, ? extends Object>> $completion) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"connection_init")};
        Map map2 = MapsKt.mutableMapOf((Pair[])pairArray);
        return map2;
    }

    @Override
    @NotNull
    public Map<String, Object> connectionTerminate() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)"connection_terminate"));
    }

    @Override
    @NotNull
    public <D extends Operation.Data> Map<String, Object> operationStart(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String data = AdapterKt.toJson$default((Adapter)((Adapter)DefaultAdaptersKt.getNullableAnyAdapter()), (Object)DefaultHttpRequestComposer.Companion.composePayload(request), null, null, (int)6, null);
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"type", (Object)"start");
        pairArray[1] = TuplesKt.to((Object)"id", (Object)request.getRequestUuid().toString());
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"data", (Object)data), TuplesKt.to((Object)"extensions", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"authorization", this.authorization)))};
        pairArray[2] = TuplesKt.to((Object)"payload", (Object)MapsKt.mapOf((Pair[])pairArray2));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public <D extends Operation.Data> Map<String, Object> operationStop(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"stop"), TuplesKt.to((Object)"id", (Object)request.getRequestUuid().toString())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @NotNull
    public WsMessage parseMessage(@NotNull String message, @NotNull WebSocketConnection webSocketConnection) {
        WsMessage wsMessage;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)webSocketConnection, (String)"webSocketConnection");
        Map map2 = (Map)AnyAdapter.INSTANCE.fromJson((JsonReader)new BufferedSourceJsonReader((BufferedSource)new Buffer().writeUtf8(message)));
        Object v = map2.get("type");
        if (Intrinsics.areEqual(v, (Object)"connection_ack")) {
            wsMessage = WsMessage.ConnectionAck.INSTANCE;
        } else if (Intrinsics.areEqual(v, (Object)"connection_error")) {
            wsMessage = new WsMessage.ConnectionError((Map)map2.get("payload"));
        } else if (Intrinsics.areEqual(v, (Object)"data")) {
            Object v2 = map2.get("id");
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)v2;
            v2 = map2.get("payload");
            if (v2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            wsMessage = new WsMessage.OperationData(string, (Map)v2);
        } else if (Intrinsics.areEqual(v, (Object)"error")) {
            Object v3 = map2.get("id");
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)v3;
            v3 = map2.get("payload");
            if (v3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            wsMessage = new WsMessage.OperationError(string, (Map)v3);
        } else if (Intrinsics.areEqual(v, (Object)"complete")) {
            Object v4 = map2.get("id");
            if (v4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            wsMessage = new WsMessage.OperationComplete((String)v4);
        } else {
            wsMessage = Intrinsics.areEqual(v, (Object)"ka") ? (WsMessage)WsMessage.KeepAlive.INSTANCE : (WsMessage)new WsMessage.Unknown(map2);
        }
        return wsMessage;
    }
}

