/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.network.http;

import com.apollographql.apollo3.api.http.HttpBody;
import com.apollographql.apollo3.api.http.HttpMethod;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.exception.ApolloNetworkException;
import com.apollographql.apollo3.network.http.HttpEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014*\u00020\u0016H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo3/network/http/DefaultHttpEngine;", "Lcom/apollographql/apollo3/network/http/HttpEngine;", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "connectTimeoutMillis", "", "readTimeoutMillis", "(JJ)V", "httpCallFactory", "Lokhttp3/Call$Factory;", "(Lokhttp3/Call$Factory;)V", "dispose", "", "execute", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "request", "Lcom/apollographql/apollo3/api/http/HttpRequest;", "(Lcom/apollographql/apollo3/api/http/HttpRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toMap", "", "", "Lokhttp3/Headers;", "apollo-runtime"})
public final class DefaultHttpEngine
implements HttpEngine {
    @NotNull
    private final Call.Factory httpCallFactory;

    public DefaultHttpEngine(@NotNull Call.Factory httpCallFactory) {
        Intrinsics.checkNotNullParameter((Object)httpCallFactory, (String)"httpCallFactory");
        this.httpCallFactory = httpCallFactory;
    }

    public DefaultHttpEngine(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        this((Call.Factory)okHttpClient);
    }

    public DefaultHttpEngine(long connectTimeoutMillis, long readTimeoutMillis) {
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(connectTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(readTimeoutMillis, TimeUnit.MILLISECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"Builder()\n          .connectTimeout(connectTimeoutMillis, TimeUnit.MILLISECONDS)\n          .readTimeout(readTimeoutMillis, TimeUnit.MILLISECONDS)\n          .build()");
        this((Call.Factory)okHttpClient);
    }

    public /* synthetic */ DefaultHttpEngine(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 60000L;
        }
        if ((n & 2) != 0) {
            l2 = 60000L;
        }
        this(l, l2);
    }

    @Override
    @Nullable
    public Object execute(@NotNull HttpRequest request, @NotNull Continuation<? super HttpResponse> $completion) {
        boolean bl;
        boolean bl2;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super HttpResponse> uCont$iv = $completion;
        boolean bl3 = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl4 = false;
        Request.Builder builder = new Request.Builder().url(request.getUrl()).headers(Headers.of((Map)request.getHeaders()));
        boolean bl5 = false;
        boolean bl6 = false;
        Object $this$execute_u24lambda_u2d3_u24lambda_u2d1 = builder;
        boolean bl7 = false;
        if (request.getMethod() == HttpMethod.Get) {
            $this$execute_u24lambda_u2d3_u24lambda_u2d1.get();
        } else {
            HttpBody body2 = request.getBody();
            bl2 = body2 != null;
            boolean bl8 = false;
            bl = false;
            if (!bl2) {
                boolean bl9 = false;
                String string = "HTTP POST requires a request body";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            $this$execute_u24lambda_u2d3_u24lambda_u2d1.post(new RequestBody(body2){
                final /* synthetic */ HttpBody $body;
                {
                    this.$body = $body;
                }

                @Nullable
                public MediaType contentType() {
                    return MediaType.parse((String)this.$body.getContentType());
                }

                public long contentLength() {
                    return this.$body.getContentLength();
                }

                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                    this.$body.writeTo(sink);
                }
            });
        }
        Request httpRequest2 = builder.build();
        Call call = this.httpCallFactory.newCall(httpRequest2);
        continuation.invokeOnCancellation((Function1)new Function1<Throwable, Unit>(call){
            final /* synthetic */ Call $call;
            {
                this.$call = $call;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                this.$call.cancel();
            }
        });
        bl6 = false;
        try {
            $this$execute_u24lambda_u2d3_u24lambda_u2d1 = Result.Companion;
            boolean bl10 = false;
            Response response2 = call.execute();
            boolean bl11 = false;
            $this$execute_u24lambda_u2d3_u24lambda_u2d1 = Result.constructor-impl((Object)response2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl2 = false;
            $this$execute_u24lambda_u2d3_u24lambda_u2d1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object networkResult = $this$execute_u24lambda_u2d3_u24lambda_u2d1;
        if (Result.isFailure-impl((Object)networkResult)) {
            Continuation continuation2 = (Continuation)continuation;
            Throwable throwable = Result.exceptionOrNull-impl((Object)networkResult);
            Intrinsics.checkNotNull((Object)throwable);
            $this$execute_u24lambda_u2d3_u24lambda_u2d1 = (Throwable)new ApolloNetworkException("Failed to execute GraphQL http network request", throwable);
            boolean bl12 = false;
            Result.Companion companion = Result.Companion;
            bl2 = false;
            continuation2.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$execute_u24lambda_u2d3_u24lambda_u2d1)));
        } else {
            $this$execute_u24lambda_u2d3_u24lambda_u2d1 = networkResult;
            boolean bl13 = false;
            ResultKt.throwOnFailure((Object)$this$execute_u24lambda_u2d3_u24lambda_u2d1);
            Response response3 = (Response)$this$execute_u24lambda_u2d3_u24lambda_u2d1;
            Result.Companion companion = Result.Companion;
            int n = response3.code();
            Object object = response3.headers();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.headers()");
            Map map2 = this.toMap(object);
            ResponseBody responseBody = response3.body();
            Intrinsics.checkNotNull((Object)responseBody);
            object = new HttpResponse(n, map2, responseBody.source(), null);
            bl2 = false;
            Object result = Result.constructor-impl((Object)object);
            companion = (Continuation)continuation;
            object = result;
            bl2 = false;
            ResultKt.throwOnFailure((Object)object);
            bl2 = false;
            Result.Companion companion2 = Result.Companion;
            bl = false;
            companion.resumeWith(Result.constructor-impl((Object)object));
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> toMap(Headers $this$toMap) {
        void $this$mapTo$iv$iv;
        Set set = $this$toMap.names();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"names()");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = $this$toMap.get((String)it);
            Intrinsics.checkNotNull((Object)string2);
            Pair pair = TuplesKt.to((Object)it, (Object)string2);
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }
}

