package com.apollographql.apollo3.cache.normalized.sql

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection

public interface CacheQueries : Transacter {
  public fun <T : Any> recordForKey(key: String, mapper: (key: String, record: String) -> T):
      Query<T>

  public fun recordForKey(key: String): Query<RecordForKey>

  public fun <T : Any> recordsForKeys(key: Collection<String>, mapper: (key: String,
      record: String) -> T): Query<T>

  public fun recordsForKeys(key: Collection<String>): Query<RecordsForKeys>

  public fun <T : Any> selectRecords(mapper: (
    _id: Long,
    key: String,
    record: String
  ) -> T): Query<T>

  public fun selectRecords(): Query<Records>

  public fun changes(): Query<Long>

  public fun insert(key: String, record: String): Unit

  public fun update(record: String, key: String): Unit

  public fun delete(key: String): Unit

  public fun deleteRecords(key: Collection<String>): Unit

  public fun deleteRecordsWithKeyMatching(value: String, value_: String): Unit

  public fun deleteAll(): Unit
}
