/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql;

import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.sql.internal.RecordDatabase;
import com.apollographql.apollo3.exception.ApolloExceptionHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J%\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\"\u001a\u00020%2\u0006\u0010&\u001a\u00020\nH\u0016J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010'J\u001b\u0010(\u001a\u00020\u000b*\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "recordDatabase", "Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;", "(Lcom/apollographql/apollo3/cache/normalized/sql/internal/RecordDatabase;)V", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "internalDeleteRecord", "", "key", "cascade", "internalGetRecords", "", "keys", "", "internalUpdateRecord", "", "record", "date", "", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Ljava/lang/Long;)Ljava/util/Set;", "internalUpdateRecords", "records", "(Ljava/util/Collection;Ljava/lang/Long;)Ljava/util/Set;", "loadRecord", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "merge", "remove", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "", "pattern", "(Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;)Ljava/lang/Long;", "withDate", "(Lcom/apollographql/apollo3/cache/normalized/api/Record;Ljava/lang/Long;)Lcom/apollographql/apollo3/cache/normalized/api/Record;", "apollo-normalized-cache-sqlite"})
public final class SqlNormalizedCache
extends NormalizedCache {
    @NotNull
    private final RecordDatabase recordDatabase;

    public SqlNormalizedCache(@NotNull RecordDatabase recordDatabase) {
        Intrinsics.checkNotNullParameter((Object)recordDatabase, (String)"recordDatabase");
        this.recordDatabase = recordDatabase;
    }

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            record = this.recordDatabase.select(key);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read a record from the database", e));
            record = null;
        }
        Record record2 = record;
        if (record2 != null) {
            if (cacheHeaders.hasHeader("evict-after-read")) {
                this.recordDatabase.delete(key);
            }
            return record2;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        return normalizedCache != null ? normalizedCache.loadRecord(key, cacheHeaders) : null;
    }

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        List list;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            list = this.internalGetRecords(keys);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read records from the database", e));
            list = CollectionsKt.emptyList();
        }
        List records = list;
        if (cacheHeaders.hasHeader("evict-after-read")) {
            Iterable $this$forEach$iv = records;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Record record = (Record)element$iv;
                boolean bl = false;
                this.recordDatabase.delete(record.getKey());
            }
        }
        return records;
    }

    public void clearAll() {
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
        this.recordDatabase.deleteAll();
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return (Boolean)RecordDatabase.DefaultImpls.transaction$default(this.recordDatabase, false, (Function0)new Function0<Boolean>(this, cacheKey, cascade){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ CacheKey $cacheKey;
            final /* synthetic */ boolean $cascade;
            {
                this.this$0 = $receiver;
                this.$cacheKey = $cacheKey;
                this.$cascade = $cascade;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return SqlNormalizedCache.access$internalDeleteRecord(this.this$0, this.$cacheKey.getKey(), this.$cascade);
            }
        }, 1, null);
    }

    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Ref.IntRef selfRemoved = new Ref.IntRef();
        RecordDatabase.DefaultImpls.transaction$default(this.recordDatabase, false, (Function0)new Function0<Unit>(this, pattern, selfRemoved){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ String $pattern;
            final /* synthetic */ Ref.IntRef $selfRemoved;
            {
                this.this$0 = $receiver;
                this.$pattern = $pattern;
                this.$selfRemoved = $selfRemoved;
                super(0);
            }

            public final void invoke() {
                SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).deleteMatching(this.$pattern);
                this.$selfRemoved.element = (int)SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).changes();
            }
        }, 1, null);
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache != null ? normalizedCache.remove(pattern) : 0;
        return selfRemoved.element + chainRemoved;
    }

    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = this.internalUpdateRecords(records, this.date(cacheHeaders));
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge records from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Long date(CacheHeaders $this$date) {
        String string = $this$date.headerValue("apollo-date");
        return string != null ? Long.valueOf(Long.parseLong(string)) : null;
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = this.internalUpdateRecord(record, this.date(cacheHeaders));
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge a record from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = this.recordDatabase.selectAll();
        KClass kClass = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass());
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record record = (Record)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey(), element$iv$iv);
        }
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map2 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map, (Map)map2);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean internalDeleteRecord(String key, boolean cascade) {
        boolean bl;
        block7: {
            if (cascade) {
                List list;
                Record record = this.recordDatabase.select(key);
                if (record != null && (list = record.referencedFields()) != null) {
                    void $this$all$iv;
                    Iterable iterable = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CacheKey it = (CacheKey)element$iv;
                            boolean bl2 = false;
                            if (this.internalDeleteRecord(it.getKey(), true)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            } else {
                this.recordDatabase.delete(key);
                bl = this.recordDatabase.changes() > 0L;
            }
        }
        return bl;
    }

    private final Set<String> internalUpdateRecords(Collection<Record> records, Long date) {
        Ref.ObjectRef updatedRecordKeys = new Ref.ObjectRef();
        updatedRecordKeys.element = SetsKt.emptySet();
        RecordDatabase.DefaultImpls.transaction$default(this.recordDatabase, false, (Function0)new Function0<Unit>(this, records, (Ref.ObjectRef<Set<String>>)updatedRecordKeys, date){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ Collection<Record> $records;
            final /* synthetic */ Ref.ObjectRef<Set<String>> $updatedRecordKeys;
            final /* synthetic */ Long $date;
            {
                this.this$0 = $receiver;
                this.$records = $records;
                this.$updatedRecordKeys = $updatedRecordKeys;
                this.$date = $date;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$associateByTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$records;
                Ref.ObjectRef<Set<String>> objectRef = SqlNormalizedCache.access$getRecordDatabase$p(this.this$0);
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Record record = (Record)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getKey());
                }
                Iterable $this$associateBy$iv = objectRef.select((Collection<String>)((List)destination$iv$iv));
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (E element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    Record bl = (Record)element$iv$iv;
                    objectRef = destination$iv$iv2;
                    boolean bl2 = false;
                    objectRef.put(it.getKey(), element$iv$iv);
                }
                Map oldRecords = destination$iv$iv2;
                $this$associateBy$iv = this.$records;
                SqlNormalizedCache sqlNormalizedCache = this.this$0;
                Long l = this.$date;
                objectRef = this.$updatedRecordKeys;
                boolean $i$f$flatMap = false;
                destination$iv$iv2 = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                    Set set;
                    Record record = (Record)element$iv$iv;
                    boolean bl = false;
                    Record oldRecord = (Record)oldRecords.get(record.getKey());
                    if (oldRecord == null) {
                        SqlNormalizedCache.access$getRecordDatabase$p(sqlNormalizedCache).insert(SqlNormalizedCache.access$withDate(sqlNormalizedCache, record, l));
                        set = record.fieldKeys();
                    } else {
                        Pair pair = oldRecord.mergeWith(record, l);
                        Record mergedRecord = (Record)pair.component1();
                        Set changedKeys = (Set)pair.component2();
                        if (!((Map)mergedRecord).isEmpty()) {
                            SqlNormalizedCache.access$getRecordDatabase$p(sqlNormalizedCache).update(mergedRecord);
                        }
                        set = changedKeys;
                    }
                    Iterable list$iv$iv = set;
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                objectRef.element = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            }
        }, 1, null);
        return (Set)updatedRecordKeys.element;
    }

    /*
     * WARNING - void declaration
     */
    private final Record withDate(Record $this$withDate, Long date) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        if (date == null) {
            return $this$withDate;
        }
        Map map2 = $this$withDate.getFields();
        UUID uUID = $this$withDate.getMutationId();
        Map map3 = $this$withDate.getFields();
        String string = $this$withDate.getKey();
        boolean $i$f$mapValues = false;
        void var5_8 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl2 = false;
            Long l = (long)date;
            map.put(k, l);
        }
        Map map5 = map = destination$iv$iv;
        UUID uUID2 = uUID;
        Map map6 = map3;
        String string2 = string;
        return new Record(string2, map6, uUID2, map5);
    }

    private final Set<String> internalUpdateRecord(Record record, Long date) {
        return (Set)RecordDatabase.DefaultImpls.transaction$default(this.recordDatabase, false, (Function0)new Function0<Set<? extends String>>(this, record, date){
            final /* synthetic */ SqlNormalizedCache this$0;
            final /* synthetic */ Record $record;
            final /* synthetic */ Long $date;
            {
                this.this$0 = $receiver;
                this.$record = $record;
                this.$date = $date;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                Set set;
                Record oldRecord = SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).select(this.$record.getKey());
                if (oldRecord == null) {
                    SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).insert(SqlNormalizedCache.access$withDate(this.this$0, this.$record, this.$date));
                    set = this.$record.fieldKeys();
                } else {
                    Pair pair = oldRecord.mergeWith(this.$record, this.$date);
                    Record mergedRecord = (Record)pair.component1();
                    Set changedKeys = (Set)pair.component2();
                    if (!((Map)mergedRecord).isEmpty()) {
                        SqlNormalizedCache.access$getRecordDatabase$p(this.this$0).update(mergedRecord);
                    }
                    set = changedKeys;
                }
                return set;
            }
        }, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Record> internalGetRecords(Collection<String> keys) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = CollectionsKt.chunked((Iterable)keys, (int)999);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List chunkedKeys = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.recordDatabase.select(chunkedKeys);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ boolean access$internalDeleteRecord(SqlNormalizedCache $this, String key, boolean cascade) {
        return $this.internalDeleteRecord(key, cascade);
    }

    public static final /* synthetic */ RecordDatabase access$getRecordDatabase$p(SqlNormalizedCache $this) {
        return $this.recordDatabase;
    }

    public static final /* synthetic */ Record access$withDate(SqlNormalizedCache $this, Record $receiver, Long date) {
        return $this.withDate($receiver, date);
    }
}

