/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.sql;

import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.sql.CacheQueries;
import com.apollographql.apollo3.cache.normalized.sql.internal.CacheQueriesHelpers;
import com.apollographql.apollo3.exception.ApolloExceptionHandlerKt;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b0\bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0010\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/apollographql/apollo3/cache/normalized/sql/SqlNormalizedCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "cacheQueries", "Lcom/apollographql/apollo3/cache/normalized/sql/CacheQueries;", "(Lcom/apollographql/apollo3/cache/normalized/sql/CacheQueries;)V", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "records", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "", "pattern", "apollo-normalized-cache-sqlite"})
public final class SqlNormalizedCache
extends NormalizedCache {
    @NotNull
    private final CacheQueries cacheQueries;

    public SqlNormalizedCache(@NotNull CacheQueries cacheQueries) {
        Intrinsics.checkNotNullParameter((Object)cacheQueries, (String)"cacheQueries");
        this.cacheQueries = cacheQueries;
    }

    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Record record;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            record = CacheQueriesHelpers.INSTANCE.selectRecord(this.cacheQueries, key);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read a record from the database", e));
            record = null;
        }
        Record record2 = record;
        if (record2 != null) {
            if (cacheHeaders.hasHeader("evict-after-read")) {
                CacheQueriesHelpers.INSTANCE.deleteRecord(this.cacheQueries, key, false);
            }
            return record2;
        }
        NormalizedCache normalizedCache = this.getNextCache();
        return normalizedCache != null ? normalizedCache.loadRecord(key, cacheHeaders) : null;
    }

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Collection collection;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        try {
            collection = CacheQueriesHelpers.INSTANCE.selectRecords(this.cacheQueries, keys);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to read records from the database", e));
            collection = CollectionsKt.emptyList();
        }
        Collection records = collection;
        if (cacheHeaders.hasHeader("evict-after-read")) {
            Iterable $this$forEach$iv = records;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Record record = (Record)element$iv;
                boolean bl = false;
                CacheQueriesHelpers.INSTANCE.deleteRecord(this.cacheQueries, record.getKey(), false);
            }
        }
        return records;
    }

    public void clearAll() {
        NormalizedCache normalizedCache = this.getNextCache();
        if (normalizedCache != null) {
            normalizedCache.clearAll();
        }
        CacheQueriesHelpers.INSTANCE.deleteAllRecords(this.cacheQueries);
    }

    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return CacheQueriesHelpers.INSTANCE.deleteRecord(this.cacheQueries, cacheKey.getKey(), cascade);
    }

    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int selfRemoved = CacheQueriesHelpers.INSTANCE.remove(this.cacheQueries, pattern);
        NormalizedCache normalizedCache = this.getNextCache();
        int chainRemoved = normalizedCache != null ? normalizedCache.remove(pattern) : 0;
        return selfRemoved + chainRemoved;
    }

    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = CacheQueriesHelpers.INSTANCE.updateRecords(this.cacheQueries, records);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge records from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        try {
            set = CacheQueriesHelpers.INSTANCE.updateRecord(this.cacheQueries, record);
        }
        catch (Exception e) {
            ApolloExceptionHandlerKt.getApolloExceptionHandler().invoke((Object)new Exception("Unable to merge a record from the database", e));
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()), CacheQueriesHelpers.INSTANCE.selectAllRecords(this.cacheQueries)));
        NormalizedCache normalizedCache = this.getNextCache();
        Map map2 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map, (Map)map2);
    }
}

