/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api.internal;

import com.apollographql.apollo3.cache.normalized.api.internal.store.Cache;
import com.apollographql.apollo3.cache.normalized.api.internal.store.CacheBuilder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012(\u0010\b\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0018\u001a\u00020\u0014J\u0006\u0010\u0019\u001a\u00020\u0005J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001bR2\u0010\b\u001a$\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache;", "Key", "", "Value", "maxSize", "", "expireAfterMillis", "", "weigher", "Lcom/apollographql/apollo3/cache/normalized/api/internal/Weigher;", "Lkotlin/Function2;", "<init>", "(IJLkotlin/jvm/functions/Function2;)V", "Lkotlin/jvm/functions/Function2;", "cache", "Lcom/apollographql/apollo3/cache/normalized/api/internal/store/Cache;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "clear", "weight", "asMap", "", "apollo-normalized-cache-api-incubating"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\ncom/apollographql/apollo3/cache/normalized/api/internal/LruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class LruCache<Key, Value> {
    @NotNull
    private final Function2<Key, Value, Integer> weigher;
    @NotNull
    private final Cache<Key, Value> cache;

    /*
     * WARNING - void declaration
     */
    public LruCache(int maxSize, long expireAfterMillis, @NotNull Function2<? super Key, ? super Value, Integer> weigher) {
        void $this$cache_u24lambda_u240;
        CacheBuilder cacheBuilder;
        Intrinsics.checkNotNullParameter(weigher, (String)"weigher");
        this.weigher = weigher;
        CacheBuilder cacheBuilder2 = cacheBuilder = new CacheBuilder();
        LruCache lruCache = this;
        boolean bl = false;
        if (maxSize != Integer.MAX_VALUE) {
            $this$cache_u24lambda_u240.weigher(maxSize, this.weigher);
        }
        if (expireAfterMillis >= 0L) {
            $this$cache_u24lambda_u240.expireAfterAccess-LRDsOJo(DurationKt.toDuration((long)expireAfterMillis, (DurationUnit)DurationUnit.MILLISECONDS));
        }
        lruCache.cache = cacheBuilder.build();
    }

    @Nullable
    public final Value get(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.cache.getIfPresent(key);
    }

    public final void set(@NotNull Key key, @NotNull Value value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.cache.put(key, value);
    }

    @Nullable
    public final Value remove(@NotNull Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Value value = this.cache.getIfPresent(key);
        this.cache.invalidate(key);
        return value;
    }

    public final void clear() {
        this.cache.invalidateAll();
    }

    /*
     * WARNING - void declaration
     */
    public final int weight() {
        Iterable iterable = this.cache.getAllPresent().entrySet();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Map.Entry entry = (Map.Entry)t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((Number)this.weigher.invoke(it.getKey(), it.getValue())).intValue();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final Map<Key, Value> asMap() {
        return this.cache.getAllPresent();
    }
}

