/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.cache.normalized.api.CacheHeaders;
import com.apollographql.apollo3.cache.normalized.api.CacheKey;
import com.apollographql.apollo3.cache.normalized.api.NormalizedCache;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.RecordMerger;
import com.apollographql.apollo3.cache.normalized.api.internal.Lock;
import com.apollographql.apollo3.cache.normalized.api.internal.LruCache;
import com.apollographql.apollo3.cache.normalized.api.internal.PatternToRegexKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J$\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020#H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0013H\u0016J&\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0016J,\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00130)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0016J&\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130)2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J$\u0010/\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u000301\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140000H\u0016J\r\u00102\u001a\u00020!H\u0000\u00a2\u0006\u0002\b3R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00064"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/MemoryCache;", "Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;", "nextCache", "maxSizeBytes", "", "expireAfterMillis", "", "<init>", "(Lcom/apollographql/apollo3/cache/normalized/api/NormalizedCache;IJ)V", "lock", "Lcom/apollographql/apollo3/cache/normalized/api/internal/Lock;", "lockWrite", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "lockRead", "lruCache", "Lcom/apollographql/apollo3/cache/normalized/api/internal/LruCache;", "", "Lcom/apollographql/apollo3/cache/normalized/api/Record;", "size", "getSize", "()I", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo3/cache/normalized/api/CacheHeaders;", "loadRecords", "", "keys", "internalLoadRecord", "clearAll", "", "remove", "", "cacheKey", "Lcom/apollographql/apollo3/cache/normalized/api/CacheKey;", "cascade", "pattern", "merge", "", "record", "recordMerger", "Lcom/apollographql/apollo3/cache/normalized/api/RecordMerger;", "records", "internalMerge", "dump", "", "Lkotlin/reflect/KClass;", "clearCurrentCache", "clearCurrentCache$apollo_normalized_cache_api_incubating", "apollo-normalized-cache-api-incubating"})
@SourceDebugExtension(value={"SMAP\nMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo3/cache/normalized/api/MemoryCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,170:1\n1#2:171\n1279#3,2:172\n1293#3,4:174\n1863#3,2:185\n1368#3:187\n1454#3,5:188\n1246#3,4:195\n503#4,7:178\n462#4:193\n412#4:194\n*S KotlinDebug\n*F\n+ 1 MemoryCache.kt\ncom/apollographql/apollo3/cache/normalized/api/MemoryCache\n*L\n49#1:172,2\n49#1:174,4\n93#1:185,2\n120#1:187\n120#1:188,5\n140#1:195,4\n50#1:178,7\n140#1:193\n140#1:194\n*E\n"})
public final class MemoryCache
implements NormalizedCache {
    @Nullable
    private final NormalizedCache nextCache;
    private final int maxSizeBytes;
    private final long expireAfterMillis;
    @Nullable
    private final Lock lock;
    @NotNull
    private final LruCache<String, Record> lruCache;

    public MemoryCache(@Nullable NormalizedCache nextCache, int maxSizeBytes, long expireAfterMillis) {
        Lock lock;
        this.nextCache = nextCache;
        this.maxSizeBytes = maxSizeBytes;
        this.expireAfterMillis = expireAfterMillis;
        MemoryCache memoryCache = this;
        NormalizedCache normalizedCache = this.nextCache;
        if (normalizedCache != null) {
            NormalizedCache normalizedCache2 = normalizedCache;
            MemoryCache memoryCache2 = memoryCache;
            boolean bl = false;
            lock = new Lock();
            memoryCache = memoryCache2;
        } else {
            lock = null;
        }
        memoryCache.lock = lock;
        this.lruCache = new LruCache(this.maxSizeBytes, this.expireAfterMillis, MemoryCache::lruCache$lambda$3);
    }

    public /* synthetic */ MemoryCache(NormalizedCache normalizedCache, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            normalizedCache = null;
        }
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 4) != 0) {
            l = -1L;
        }
        this(normalizedCache, n, l);
    }

    private final <T> T lockWrite(Function0<? extends T> block) {
        Object object = this.lock;
        if (object == null || (object = ((Lock)object).write(() -> MemoryCache.lockWrite$lambda$1(block))) == null) {
            object = block.invoke();
        }
        return (T)object;
    }

    private final <T> T lockRead(Function0<? extends T> block) {
        Object object = this.lock;
        if (object == null || (object = ((Lock)object).read(() -> MemoryCache.lockRead$lambda$2(block))) == null) {
            object = block.invoke();
        }
        return (T)object;
    }

    public final int getSize() {
        return ((Number)this.lockRead(() -> MemoryCache._get_size_$lambda$4(this))).intValue();
    }

    @Override
    @Nullable
    public Record loadRecord(@NotNull String key, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        return (Record)this.lockRead(() -> MemoryCache.loadRecord$lambda$6(this, key, cacheHeaders));
    }

    @Override
    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        return (Collection)this.lockRead(() -> MemoryCache.loadRecords$lambda$9(keys, this, cacheHeaders));
    }

    private final Record internalLoadRecord(String key, CacheHeaders cacheHeaders) {
        Record record;
        Record record2 = this.lruCache.get(key);
        if (record2 != null) {
            Record record3;
            Record it = record3 = record2;
            boolean bl = false;
            if (cacheHeaders.hasHeader("evict-after-read")) {
                this.lruCache.remove(key);
            }
            record = record3;
        } else {
            record = null;
        }
        return record;
    }

    @Override
    public void clearAll() {
        this.lockWrite(() -> MemoryCache.clearAll$lambda$11(this));
    }

    @Override
    public boolean remove(@NotNull CacheKey cacheKey, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return (Boolean)this.lockWrite(() -> MemoryCache.remove$lambda$12(this, cacheKey, cascade));
    }

    @Override
    public int remove(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Regex regex = PatternToRegexKt.patternToRegex(pattern);
        return ((Number)this.lockWrite(() -> MemoryCache.remove$lambda$14(this, pattern, regex))).intValue();
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        return (Set)this.lockWrite(() -> MemoryCache.merge$lambda$15(this, record, cacheHeaders, recordMerger));
    }

    @Override
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> records, @NotNull CacheHeaders cacheHeaders, @NotNull RecordMerger recordMerger) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)recordMerger, (String)"recordMerger");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        return (Set)this.lockWrite(() -> MemoryCache.merge$lambda$17(records, this, cacheHeaders, recordMerger));
    }

    private final Set<String> internalMerge(Record record, CacheHeaders cacheHeaders, RecordMerger recordMerger) {
        Set set;
        Record oldRecord = this.loadRecord(record.getKey(), cacheHeaders);
        if (oldRecord == null) {
            this.lruCache.set(record.getKey(), record);
            set = record.fieldKeys();
        } else {
            Pair<Record, Set<String>> pair = recordMerger.merge(oldRecord, record, null);
            Record mergedRecord = (Record)pair.component1();
            Set changedKeys = (Set)pair.component2();
            this.lruCache.set(record.getKey(), mergedRecord);
            set = changedKeys;
        }
        Set changedKeys = set;
        return changedKeys;
    }

    @Override
    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        return (Map)this.lockRead(() -> MemoryCache.dump$lambda$19(this));
    }

    public final void clearCurrentCache$apollo_normalized_cache_api_incubating() {
        this.lruCache.clear();
    }

    private static final Object lockWrite$lambda$1(Function0 $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        return $block.invoke();
    }

    private static final Object lockRead$lambda$2(Function0 $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        return $block.invoke();
    }

    private static final int lruCache$lambda$3(String key, Record record) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        return key.length() + record.getSizeInBytes();
    }

    private static final int _get_size_$lambda$4(MemoryCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.lruCache.weight();
    }

    private static final Record loadRecord$lambda$6(MemoryCache this$0, String $key, CacheHeaders $cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$cacheHeaders, (String)"$cacheHeaders");
        Record record = this$0.internalLoadRecord($key, $cacheHeaders);
        Object object = record;
        if (object == null) {
            Object object2 = this$0.nextCache;
            if (object2 != null && (object2 = object2.loadRecord($key, $cacheHeaders)) != null) {
                Object object3;
                Object nextCachedRecord = object3 = object2;
                boolean bl = false;
                this$0.lruCache.set($key, (Record)nextCachedRecord);
                object = object3;
            } else {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final List loadRecords$lambda$9(Collection $keys, MemoryCache this$0, CacheHeaders $cacheHeaders) {
        Map recordsByKey;
        Intrinsics.checkNotNullParameter((Object)$keys, (String)"$keys");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cacheHeaders, (String)"$cacheHeaders");
        Iterable $this$associateWith$iv = $keys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void key;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Record record = this$0.internalLoadRecord((String)key, $cacheHeaders);
            map.put(t, record);
        }
        Map $this$filterValues$iv = recordsByKey = (Map)result$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Record it = (Record)entry$iv.getValue();
            boolean bl = false;
            if (!(it == null)) continue;
            result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set missingKeys = ((Map)result$iv2).keySet();
        NormalizedCache normalizedCache = this$0.nextCache;
        Collection collection = normalizedCache != null ? normalizedCache.loadRecords(missingKeys, $cacheHeaders) : null;
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection nextCachedRecords = collection;
        for (Record record : nextCachedRecords) {
            this$0.lruCache.set(record.getKey(), record);
        }
        return CollectionsKt.plus((Collection)CollectionsKt.filterNotNull((Iterable)recordsByKey.values()), (Iterable)nextCachedRecords);
    }

    private static final Unit clearAll$lambda$11(MemoryCache this$0) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.lruCache.clear();
        NormalizedCache normalizedCache = this$0.nextCache;
        if (normalizedCache != null) {
            normalizedCache.clearAll();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final boolean remove$lambda$12(MemoryCache this$0, CacheKey $cacheKey, boolean $cascade) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cacheKey, (String)"$cacheKey");
        Record record = this$0.lruCache.remove($cacheKey.getKey());
        if ($cascade && record != null) {
            for (CacheKey cacheReference : record.referencedFields()) {
                this$0.remove(new CacheKey(cacheReference.getKey()), true);
            }
        }
        NormalizedCache normalizedCache = this$0.nextCache;
        boolean chainRemoved = normalizedCache != null ? normalizedCache.remove($cacheKey, $cascade) : false;
        return record != null || chainRemoved;
    }

    private static final int remove$lambda$14(MemoryCache this$0, String $pattern, Regex $regex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pattern, (String)"$pattern");
        Intrinsics.checkNotNullParameter((Object)$regex, (String)"$regex");
        int total = 0;
        HashSet keys = new HashSet(this$0.lruCache.asMap().keySet());
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!$regex.matches((CharSequence)it)) continue;
            this$0.lruCache.remove(it);
            ++total;
        }
        NormalizedCache normalizedCache = this$0.nextCache;
        int chainRemoved = normalizedCache != null ? normalizedCache.remove($pattern) : 0;
        return total + chainRemoved;
    }

    private static final Set merge$lambda$15(MemoryCache this$0, Record $record, CacheHeaders $cacheHeaders, RecordMerger $recordMerger) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$record, (String)"$record");
        Intrinsics.checkNotNullParameter((Object)$cacheHeaders, (String)"$cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)$recordMerger, (String)"$recordMerger");
        Set<String> changedKeys = this$0.internalMerge($record, $cacheHeaders, $recordMerger);
        NormalizedCache normalizedCache = this$0.nextCache;
        Set set = normalizedCache != null ? normalizedCache.merge($record, $cacheHeaders, $recordMerger) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return SetsKt.plus(changedKeys, (Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set merge$lambda$17(Collection $records, MemoryCache this$0, CacheHeaders $cacheHeaders, RecordMerger $recordMerger) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$records, (String)"$records");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cacheHeaders, (String)"$cacheHeaders");
        Intrinsics.checkNotNullParameter((Object)$recordMerger, (String)"$recordMerger");
        Iterable $this$flatMap$iv = $records;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Record record = (Record)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this$0.internalMerge(record, $cacheHeaders, $recordMerger);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set changedKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        NormalizedCache normalizedCache = this$0.nextCache;
        Set set = normalizedCache != null ? normalizedCache.merge($records, $cacheHeaders, $recordMerger) : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return SetsKt.plus((Set)changedKeys, (Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map dump$lambda$19(MemoryCache this$0) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map<String, Record> map = this$0.lruCache.asMap();
        KClass kClass = Reflection.getOrCreateKotlinClass(this$0.getClass());
        boolean $i$f$mapValues = false;
        void var3_4 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Record record;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Record record2 = record = (Record)entry2.getValue();
            map3.put(k, record2);
        }
        Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)kClass, (Object)destination$iv$iv));
        NormalizedCache normalizedCache = this$0.nextCache;
        Map map5 = normalizedCache != null ? normalizedCache.dump() : null;
        if (map5 == null) {
            map5 = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map4, map5);
    }

    public MemoryCache() {
        this(null, 0, 0L, 7, null);
    }
}

