/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.normalized.api;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.CompiledField;
import com.apollographql.apollo3.api.Executable;
import com.apollographql.apollo3.cache.normalized.api.ApolloResolver;
import com.apollographql.apollo3.cache.normalized.api.Record;
import com.apollographql.apollo3.cache.normalized.api.ResolverContext;
import com.apollographql.apollo3.exception.CacheMissException;
import com.apollographql.apollo3.mpp.UtilsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/apollographql/apollo3/cache/normalized/api/ReceiveDateApolloResolver;", "Lcom/apollographql/apollo3/cache/normalized/api/ApolloResolver;", "maxAge", "", "(I)V", "resolveField", "", "context", "Lcom/apollographql/apollo3/cache/normalized/api/ResolverContext;", "apollo-normalized-cache-api-incubating"})
@ApolloExperimental
public final class ReceiveDateApolloResolver
implements ApolloResolver {
    private final int maxAge;

    public ReceiveDateApolloResolver(int maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    @Nullable
    public Object resolveField(@NotNull ResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CompiledField field = context.getField();
        Map<String, Object> parent = context.getParent();
        Executable.Variables variables = context.getVariables();
        String parentId = context.getParentId();
        String name = field.nameWithArguments(variables);
        if (!parent.containsKey(name)) {
            throw new CacheMissException(parentId, name);
        }
        if (parent instanceof Record) {
            Long lastUpdated;
            Map<String, Long> map = ((Record)parent).getDate();
            Long l = lastUpdated = map != null ? map.get(name) : null;
            if (lastUpdated != null) {
                long age;
                long maxStale;
                Object object = context.getCacheHeaders().headerValue("apollo-max-stale");
                long l2 = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : (maxStale = 0L);
                if (maxStale < Long.MAX_VALUE && (long)this.maxAge + maxStale - (age = UtilsKt.currentTimeMillis() / (long)1000 - lastUpdated) < 0L) {
                    throw new CacheMissException(parentId, name, true);
                }
            }
        }
        return parent.get(name);
    }
}

