/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.mockserver;

import com.apollographql.apollo3.annotations.ApolloInternal;
import com.apollographql.apollo3.mockserver.MockRequest;
import com.apollographql.apollo3.mockserver.MockResponse;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.FlowCollector;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\"\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0087@\u00a2\u0006\u0002\u0010\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"parseHeader", "Lkotlin/Pair;", "", "line", "parseRequestLine", "Lkotlin/Triple;", "readRequest", "Lcom/apollographql/apollo3/mockserver/MockRequest;", "source", "Lokio/BufferedSource;", "writeResponse", "", "sink", "Lokio/BufferedSink;", "mockResponse", "Lcom/apollographql/apollo3/mockserver/MockResponse;", "version", "(Lokio/BufferedSink;Lcom/apollographql/apollo3/mockserver/MockResponse;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readChunked", "buffer", "Lokio/Buffer;", "apollo-mockserver"})
@SourceDebugExtension(value={"SMAP\nMockServerCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockServerCommon.kt\ncom/apollographql/apollo3/mockserver/MockServerCommonKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,220:1\n151#2,6:221\n215#3,2:227\n*S KotlinDebug\n*F\n+ 1 MockServerCommon.kt\ncom/apollographql/apollo3/mockserver/MockServerCommonKt\n*L\n20#1:221,6\n42#1:227,2\n*E\n"})
public final class MockServerCommonKt {
    @Deprecated(message="This shouldn't be part of the public API and will be removed in Apollo Kotlin 4. If you needed this, please open an issue.")
    @NotNull
    public static final Pair<String, String> parseHeader(@NotNull String line) {
        int index;
        block2: {
            int n;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence $this$indexOfFirst$iv = line;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(it == ':')) continue;
                n = index$iv;
                break block2;
            }
            n = index = -1;
        }
        if (!(index >= 0)) {
            boolean bl = false;
            String string = "Invalid header: " + line;
            throw new IllegalStateException(string.toString());
        }
        String string = line.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string3 = line.substring(index + 1, line.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return TuplesKt.to((Object)string2, (Object)((Object)StringsKt.trim((CharSequence)string3)).toString());
    }

    @Deprecated(message="This shouldn't be part of the public API and will be removed in Apollo Kotlin 4. If you needed this, please open an issue.")
    @Nullable
    public static final Object writeResponse(@NotNull BufferedSink sink, @NotNull MockResponse mockResponse, @NotNull String version, @NotNull Continuation<? super Unit> $completion) {
        Map headers;
        sink.writeUtf8(version + ' ' + mockResponse.getStatusCode() + "\r\n");
        Map $this$forEach$iv = headers = MapsKt.plus(mockResponse.getHeaders(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"Connection", (Object)"close")));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            sink.writeUtf8((String)it.getKey() + ": " + (String)it.getValue() + "\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
        Object object = mockResponse.getBody().collect(new FlowCollector(sink){
            final /* synthetic */ BufferedSink $sink;
            {
                this.$sink = $sink;
            }

            @Nullable
            public final Object emit(@NotNull ByteString it, @NotNull Continuation<? super Unit> $completion) {
                this.$sink.write(it);
                this.$sink.flush();
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final MockRequest readRequest(@NotNull BufferedSource source) {
        String transferEncoding;
        String string;
        Pair<String, String> pair;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String line = source.readUtf8Line();
        if (line == null) {
            return null;
        }
        Triple<String, String, String> triple = MockServerCommonKt.parseRequestLine(line);
        String method = (String)triple.component1();
        String path = (String)triple.component2();
        String version = (String)triple.component3();
        Map headers = new LinkedHashMap();
        while (!((pair = (Pair<String, String>)(line = source.readUtf8Line())) == null || StringsKt.isBlank((CharSequence)pair))) {
            pair = MockServerCommonKt.parseHeader(line);
            String key = (String)pair.component1();
            String value = (String)pair.component2();
            headers.put(key, value);
        }
        Object object = (String)headers.get("Content-Length");
        long contentLength = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
        String string2 = (String)headers.get("Transfer-Encoding");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = transferEncoding = null;
        }
        if (!(transferEncoding == null || Intrinsics.areEqual((Object)transferEncoding, (Object)"identity") || Intrinsics.areEqual((Object)transferEncoding, (Object)"chunked"))) {
            boolean bl = false;
            String string4 = "Transfer-Encoding " + transferEncoding + " is not supported";
            throw new IllegalStateException(string4.toString());
        }
        Buffer buffer = new Buffer();
        if (contentLength > 0L) {
            source.read(buffer, contentLength);
        } else if (Intrinsics.areEqual((Object)transferEncoding, (Object)"chunked")) {
            MockServerCommonKt.readChunked(source, buffer);
        }
        return new MockRequest(method, path, version, headers, buffer.readByteString());
    }

    @ApolloInternal
    public static final void readChunked(@NotNull BufferedSource $this$readChunked, @NotNull Buffer buffer) {
        long chunkSize;
        String line;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$readChunked, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (!((charSequence = (CharSequence)(line = $this$readChunked.readUtf8Line())) == null || StringsKt.isBlank((CharSequence)charSequence)) && (chunkSize = Long.parseLong(line, CharsKt.checkRadix((int)16))) != 0L) {
            $this$readChunked.read(buffer, chunkSize);
            $this$readChunked.readUtf8Line();
        }
    }

    @Deprecated(message="This shouldn't be part of the public API and will be removed in Apollo Kotlin 4. If you needed this, please open an issue.")
    @NotNull
    public static final Triple<String, String, String> parseRequestLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Regex regex = new Regex("([A-Z-a-z]*) ([^ ]*) (.*)");
        MatchResult match = regex.matchEntire((CharSequence)line);
        if (!(match != null)) {
            boolean bl = false;
            String string = "Cannot match request line: " + line;
            throw new IllegalStateException(string.toString());
        }
        String string = ((String)match.getGroupValues().get(1)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String method = string;
        Object[] objectArray = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH"};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(method)) {
            boolean bl = false;
            String string2 = "Unkown method " + method;
            throw new IllegalStateException(string2.toString());
        }
        return new Triple((Object)method, match.getGroupValues().get(2), match.getGroupValues().get(3));
    }
}

