/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.mockserver;

import com.apollographql.apollo3.mockserver.MockRecordedRequest;
import com.apollographql.apollo3.mockserver.MockResponse;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002\u00a8\u0006\u0011"}, d2={"parseHeader", "Lkotlin/Pair;", "", "line", "parseRequestLine", "Lkotlin/Triple;", "readRequest", "Lcom/apollographql/apollo3/mockserver/MockRecordedRequest;", "source", "Lokio/BufferedSource;", "writeResponse", "", "sink", "Lokio/BufferedSink;", "mockResponse", "Lcom/apollographql/apollo3/mockserver/MockResponse;", "version", "apollo-mockserver"})
public final class MockServerCommonKt {
    @NotNull
    public static final Triple<String, String, String> parseRequestLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Regex regex = new Regex("([A-Z-a-z]*) ([^ ]*) (.*)");
        MatchResult match = regex.matchEntire((CharSequence)line);
        boolean bl = match != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Cannot match request line: ", (Object)line);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object[] objectArray = (Object[])match.getGroupValues().get(1);
        bl3 = false;
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = objectArray.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase()");
        String method = string;
        objectArray = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH"};
        boolean bl5 = CollectionsKt.listOf((Object[])objectArray).contains(method);
        bl3 = false;
        boolean bl6 = false;
        if (!bl5) {
            boolean bl7 = false;
            String string2 = Intrinsics.stringPlus((String)"Unkown method ", (Object)method);
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return new Triple((Object)method, match.getGroupValues().get(2), match.getGroupValues().get(3));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, String> parseHeader(@NotNull String line) {
        int n;
        int n2;
        int n3;
        block5: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence $this$indexOfFirst$iv = line;
            boolean $i$f$indexOfFirst = false;
            n3 = 0;
            n2 = $this$indexOfFirst$iv.length();
            while (n3 < n2) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl = false;
                if (it == ':') {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        boolean bl = index >= 0;
        int n4 = 0;
        n3 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = Intrinsics.stringPlus((String)"Invalid header: ", (Object)line);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        String string = line;
        n4 = 0;
        n3 = 0;
        String string2 = string.substring(n4, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string2;
        n4 = 0;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        string = line;
        n4 = index + 1;
        n3 = line.length();
        n2 = 0;
        String string5 = string.substring(n4, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string5;
        n4 = 0;
        String string6 = string;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return TuplesKt.to((Object)string4, (Object)((Object)StringsKt.trim((CharSequence)string6)).toString());
    }

    @NotNull
    public static final MockRecordedRequest readRequest(@NotNull BufferedSource source) {
        boolean bl;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String line = source.readUtf8Line();
        boolean bl2 = line != null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string2 = "Cannot read request line";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Triple<String, String, String> triple = MockServerCommonKt.parseRequestLine(line);
        String method = (String)triple.component1();
        String path = (String)triple.component2();
        String version = (String)triple.component3();
        boolean bl6 = false;
        Map headers = new LinkedHashMap();
        while (true) {
            line = source.readUtf8Line();
            Pair<String, String> pair = (Pair<String, String>)line;
            boolean bl7 = false;
            boolean bl8 = false;
            if (pair == null || StringsKt.isBlank((CharSequence)pair)) break;
            pair = MockServerCommonKt.parseHeader(line);
            String key = (String)pair.component1();
            String value = (String)pair.component2();
            headers.put(key, value);
        }
        String value = (String)headers.get("Content-Length");
        long contentLength = value == null ? 0L : ((object = StringsKt.toLongOrNull((String)value)) == null ? 0L : (Long)object);
        object = (String)headers.get("Transfer-Encoding");
        if (object == null) {
            string = null;
        } else {
            Object object2 = object;
            bl = false;
            String string3 = ((String)object2).toLowerCase();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        }
        String transferEncoding = string;
        boolean bl9 = transferEncoding == null || Intrinsics.areEqual((Object)transferEncoding, (Object)"identity");
        boolean bl10 = false;
        bl = false;
        if (!bl9) {
            boolean bl11 = false;
            String string4 = "Transfer-Encoding " + transferEncoding + " is not supported";
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        Buffer buffer = new Buffer();
        if (contentLength > 0L) {
            source.read(buffer, contentLength);
        }
        return new MockRecordedRequest(method, path, version, headers, buffer.readByteString());
    }

    public static final void writeResponse(@NotNull BufferedSink sink, @NotNull MockResponse mockResponse, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)mockResponse, (String)"mockResponse");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        sink.writeUtf8(version + ' ' + mockResponse.getStatusCode() + "\r\n");
        Map contentLengthHeader = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Length", (Object)String.valueOf(mockResponse.getBody().size())));
        Map $this$forEach$iv = MapsKt.plus((Map)contentLengthHeader, mockResponse.getHeaders());
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            sink.writeUtf8((String)it.getKey() + ": " + (String)it.getValue() + "\r\n");
        }
        sink.writeUtf8("\r\n");
        sink.flush();
        if (mockResponse.getBody().size() > 0) {
            sink.write(mockResponse.getBody());
        }
        sink.flush();
    }
}

