(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'okio-parent-okio-js-legacy', 'kotlinx-coroutines-core', 'net'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('okio-parent-okio-js-legacy'), require('kotlinx-coroutines-core'), require('net'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }
    if (typeof this['okio-parent-okio-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'okio-parent-okio-js-legacy' was not found. Please, check whether 'okio-parent-okio-js-legacy' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }
    if (typeof net === 'undefined') {
      throw new Error("Error loading module 'apollo-kotlin-apollo-mockserver-js-legacy'. Its dependency 'net' was not found. Please, check whether 'net' is loaded prior to 'apollo-kotlin-apollo-mockserver-js-legacy'.");
    }
    root['apollo-kotlin-apollo-mockserver-js-legacy'] = factory(typeof this['apollo-kotlin-apollo-mockserver-js-legacy'] === 'undefined' ? {} : this['apollo-kotlin-apollo-mockserver-js-legacy'], kotlin, this['okio-parent-okio-js-legacy'], this['kotlinx-coroutines-core'], net);
  }
}(this, function (_, Kotlin, $module$okio_parent_okio_js_legacy, $module$kotlinx_coroutines_core, $module$net) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var unboxChar = Kotlin.unboxChar;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var ByteString = $module$okio_parent_okio_js_legacy.okio.ByteString;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var plus = Kotlin.kotlin.collections.plus_iwxh38$;
  var Unit = Kotlin.kotlin.Unit;
  var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
  var flowOf = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.flowOf_mh5how$;
  var toString = Kotlin.toString;
  var emptyFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.emptyFlow_287e2$;
  var L0 = Kotlin.Long.ZERO;
  var toLongOrNull = Kotlin.kotlin.text.toLongOrNull_pdl1vz$;
  var equals = Kotlin.equals;
  var Buffer_0 = $module$okio_parent_okio_js_legacy.okio.Buffer;
  var toLong = Kotlin.kotlin.text.toLong_6ic1pp$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var Triple = Kotlin.kotlin.Triple;
  var get_indices = Kotlin.kotlin.text.get_indices_gw00vp$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var withIndex = Kotlin.kotlin.collections.withIndex_7wnvza$;
  var get_lastIndex = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var onCompletion = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.onCompletion_sp7fh9$;
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_lsve6m$;
  var receiveAsFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.receiveAsFlow_6u4434$;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var mapOf_0 = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var Flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.Flow;
  var ArrayDeque_init = Kotlin.kotlin.collections.ArrayDeque_init_287e2$;
  var ensureNotNull = Kotlin.ensureNotNull;
  var removeFirst = Kotlin.kotlin.collections.removeFirst_vvxzk3$;
  var Timeout = $module$okio_parent_okio_js_legacy.okio.Timeout;
  var Sink = $module$okio_parent_okio_js_legacy.okio.Sink;
  var Exception = Kotlin.kotlin.Exception;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var buffer = $module$okio_parent_okio_js_legacy.okio.buffer_gyfaj4$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var createServer = $module$net.createServer;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Result = Kotlin.kotlin.Result;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var SafeContinuation_init = Kotlin.kotlin.coroutines.SafeContinuation_init_wj8d80$;
  function MockServerInterface() {
  }
  MockServerInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MockServerInterface',
    interfaces: []
  };
  function parseHeader(line) {
    var indexOfFirst$result;
    indexOfFirst$break: do {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      tmp$ = get_indices(line);
      tmp$_0 = tmp$.first;
      tmp$_1 = tmp$.last;
      tmp$_2 = tmp$.step;
      for (var index = tmp$_0; index <= tmp$_1; index += tmp$_2) {
        if (unboxChar(toBoxedChar(line.charCodeAt(index))) === 58) {
          indexOfFirst$result = index;
          break indexOfFirst$break;
        }
      }
      indexOfFirst$result = -1;
    }
     while (false);
    var index_0 = indexOfFirst$result;
    if (!(index_0 >= 0)) {
      var message = 'Invalid header: ' + line;
      throw IllegalStateException_init(message.toString());
    }
    var $receiver = line.substring(0, index_0);
    var tmp$_3;
    var tmp$_4 = trim(Kotlin.isCharSequence(tmp$_3 = $receiver) ? tmp$_3 : throwCCE()).toString();
    var startIndex = index_0 + 1 | 0;
    var endIndex = line.length;
    var $receiver_0 = line.substring(startIndex, endIndex);
    var tmp$_5;
    return to(tmp$_4, trim(Kotlin.isCharSequence(tmp$_5 = $receiver_0) ? tmp$_5 : throwCCE()).toString());
  }
  function MockRequest(method, path, version, headers, body) {
    if (headers === void 0)
      headers = emptyMap();
    if (body === void 0)
      body = ByteString.Companion.EMPTY;
    this.method = method;
    this.path = path;
    this.version = version;
    this.headers = headers;
    this.body = body;
  }
  MockRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockRequest',
    interfaces: []
  };
  function Coroutine$writeResponse$lambda(closure$sink_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$sink = closure$sink_0;
    this.local$it = it_0;
  }
  Coroutine$writeResponse$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$writeResponse$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$writeResponse$lambda.prototype.constructor = Coroutine$writeResponse$lambda;
  Coroutine$writeResponse$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$closure$sink.write_9ovubf$(this.local$it);
            return this.local$closure$sink.flush(), Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function writeResponse$lambda(closure$sink_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$writeResponse$lambda(closure$sink_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$writeResponse(sink_0, mockResponse_0, version_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$sink = sink_0;
    this.local$mockResponse = mockResponse_0;
    this.local$version = version_0;
  }
  Coroutine$writeResponse.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$writeResponse.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$writeResponse.prototype.constructor = Coroutine$writeResponse;
  Coroutine$writeResponse.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$sink.writeUtf8_61zpoe$(this.local$version + ' ' + this.local$mockResponse.statusCode + '\r' + '\n');
            var headers = plus(this.local$mockResponse.headers, mapOf(to('Connection', 'close')));
            var tmp$;
            tmp$ = headers.entries.iterator();
            while (tmp$.hasNext()) {
              var element = tmp$.next();
              this.local$sink.writeUtf8_61zpoe$(element.key + ': ' + element.value + '\r' + '\n');
            }

            this.local$sink.writeUtf8_61zpoe$('\r\n');
            this.local$sink.flush();
            this.state_0 = 2;
            this.result_0 = this.local$mockResponse.body.collect_42ocv1$(new FlowCollector(writeResponse$lambda(this.local$sink)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function writeResponse(sink_0, mockResponse_0, version_0, continuation_0, suspended) {
    var instance = new Coroutine$writeResponse(sink_0, mockResponse_0, version_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function MockResponse(statusCode, body, headers, delayMillis) {
    if (statusCode === void 0)
      statusCode = 200;
    if (body === void 0)
      body = emptyFlow();
    if (headers === void 0)
      headers = mapOf(to('Content-Length', '0'));
    if (delayMillis === void 0)
      delayMillis = L0;
    this.statusCode = statusCode;
    this.body = body;
    this.headers = headers;
    this.delayMillis = delayMillis;
  }
  function MockResponse$Builder() {
    this.statusCode_0 = 200;
    this.body_0 = emptyFlow();
    this.headers_0 = LinkedHashMap_init();
    this.delayMillis_0 = L0;
    this.contentLength_0 = null;
  }
  MockResponse$Builder.prototype.statusCode_za3lpa$ = function (statusCode) {
    this.statusCode_0 = statusCode;
    return this;
  };
  MockResponse$Builder.prototype.body_q7dri2$ = function (body) {
    this.body_0 = body;
    return this;
  };
  MockResponse$Builder.prototype.body_9ovubf$ = function (body) {
    this.body_0 = flowOf(body);
    this.contentLength_0 = body.size;
    return this;
  };
  MockResponse$Builder.prototype.body_61zpoe$ = function (body) {
    return this.body_9ovubf$(ByteString.Companion.encodeUtf8_pdl1vz$(body));
  };
  MockResponse$Builder.prototype.headers_y0zsll$ = function (headers) {
    this.headers_0.clear();
    this.headers_0.putAll_a2k3zr$(headers);
    return this;
  };
  MockResponse$Builder.prototype.addHeader_puj7f4$ = function (key, value) {
    this.headers_0.put_xwzc9p$(key, value);
    return this;
  };
  MockResponse$Builder.prototype.delayMillis_s8cxhz$ = function (delayMillis) {
    this.delayMillis_0 = delayMillis;
    return this;
  };
  MockResponse$Builder.prototype.build = function () {
    var headersWithContentLength = this.contentLength_0 == null ? this.headers_0 : plus(this.headers_0, mapOf(to('Content-Length', toString(this.contentLength_0))));
    return new MockResponse(this.statusCode_0, this.body_0, headersWithContentLength, this.delayMillis_0);
  };
  MockResponse$Builder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Builder',
    interfaces: []
  };
  MockResponse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockResponse',
    interfaces: []
  };
  function MockResponse_init(body, statusCode, headers, delayMillis, $this) {
    if (statusCode === void 0)
      statusCode = 200;
    if (headers === void 0)
      headers = emptyMap();
    if (delayMillis === void 0)
      delayMillis = L0;
    $this = $this || Object.create(MockResponse.prototype);
    MockResponse.call($this, statusCode, flowOf(ByteString.Companion.encodeUtf8_pdl1vz$(body)), plus(headers, mapOf(to('Content-Length', body.length.toString()))), delayMillis);
    return $this;
  }
  function MockResponse_init_0(body, statusCode, headers, delayMillis, $this) {
    if (statusCode === void 0)
      statusCode = 200;
    if (headers === void 0)
      headers = emptyMap();
    if (delayMillis === void 0)
      delayMillis = L0;
    $this = $this || Object.create(MockResponse.prototype);
    MockResponse.call($this, statusCode, flowOf(body), plus(headers, mapOf(to('Content-Length', body.size.toString()))), delayMillis);
    return $this;
  }
  function MockServerHandler() {
  }
  MockServerHandler.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MockServerHandler',
    interfaces: []
  };
  function readRequest(source) {
    var tmp$, tmp$_0, tmp$_1;
    var line = source.readUtf8Line();
    if (line == null) {
      return null;
    }
    var tmp$_2 = parseRequestLine(line);
    var method = tmp$_2.component1()
    , path = tmp$_2.component2()
    , version = tmp$_2.component3();
    var headers = LinkedHashMap_init();
    while (true) {
      line = source.readUtf8Line();
      var $receiver = line;
      if ($receiver == null || isBlank($receiver)) {
        break;
      }
      var tmp$_3 = parseHeader(line);
      var key = tmp$_3.component1()
      , value = tmp$_3.component2();
      headers.put_xwzc9p$(key, value);
    }
    var contentLength = (tmp$_0 = (tmp$ = headers.get_11rb$('Content-Length')) != null ? toLongOrNull(tmp$) : null) != null ? tmp$_0 : L0;
    var transferEncoding = (tmp$_1 = headers.get_11rb$('Transfer-Encoding')) != null ? tmp$_1.toLowerCase() : null;
    if (!(transferEncoding == null || equals(transferEncoding, 'identity') || equals(transferEncoding, 'chunked'))) {
      var message = 'Transfer-Encoding ' + toString(transferEncoding) + ' is not supported';
      throw IllegalStateException_init(message.toString());
    }
    var buffer = new Buffer_0();
    if (contentLength.toNumber() > 0) {
      source.read_u27jpl$(buffer, contentLength);
    } else if (equals(transferEncoding, 'chunked')) {
      readChunked(source, buffer);
    }
    return new MockRequest(method, path, version, headers, buffer.readByteString());
  }
  function readChunked($receiver, buffer) {
    while (true) {
      var line = $receiver.readUtf8Line();
      if (line == null || isBlank(line))
        break;
      var chunkSize = toLong(line, 16);
      if (equals(chunkSize, L0))
        break;
      $receiver.read_u27jpl$(buffer, chunkSize);
      $receiver.readUtf8Line();
    }
  }
  function parseRequestLine(line) {
    var regex = Regex_init('([A-Z-a-z]*) ([^ ]*) (.*)');
    var match = regex.matchEntire_6bul2c$(line);
    if (!(match != null)) {
      var message = 'Cannot match request line: ' + line;
      throw IllegalStateException_init(message.toString());
    }
    var method = match.groupValues.get_za3lpa$(1).toUpperCase();
    if (!listOf(['GET', 'POST', 'PUT', 'DELETE', 'HEAD', 'OPTIONS', 'PATCH']).contains_11rb$(method)) {
      var message_0 = 'Unkown method ' + method;
      throw IllegalStateException_init(message_0.toString());
    }
    return new Triple(method, match.groupValues.get_za3lpa$(2), match.groupValues.get_za3lpa$(3));
  }
  function unsafeFlow$ObjectLiteral(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$.prototype.constructor = Coroutine$collect_42ocv1$;
  Coroutine$collect_42ocv1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda;
  Coroutine$unsafeTransform$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
  Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda.prototype.constructor = Coroutine$map$lambda;
  Coroutine$map$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function enqueue($receiver, string, delayMs, statusCode) {
    if (string === void 0)
      string = '';
    if (delayMs === void 0)
      delayMs = L0;
    if (statusCode === void 0)
      statusCode = 200;
    $receiver.enqueue_wvyhoh$((new MockResponse$Builder()).statusCode_za3lpa$(statusCode).body_61zpoe$(string).delayMillis_s8cxhz$(delayMs).build());
  }
  function enqueueMultipart($receiver, parts, statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary) {
    if (statusCode === void 0)
      statusCode = 200;
    if (partsContentType === void 0)
      partsContentType = 'application/json; charset=utf-8';
    if (headers === void 0)
      headers = emptyMap();
    if (responseDelayMillis === void 0)
      responseDelayMillis = L0;
    if (chunksDelayMillis === void 0)
      chunksDelayMillis = L0;
    if (boundary === void 0)
      boundary = '-';
    $receiver.enqueue_wvyhoh$(createMultipartMixedChunkedResponse(parts, statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary));
  }
  function createMultipartMixedChunkedResponse(parts, statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary) {
    if (statusCode === void 0)
      statusCode = 200;
    if (partsContentType === void 0)
      partsContentType = 'application/json; charset=utf-8';
    if (headers === void 0)
      headers = emptyMap();
    if (responseDelayMillis === void 0)
      responseDelayMillis = L0;
    if (chunksDelayMillis === void 0)
      chunksDelayMillis = L0;
    if (boundary === void 0)
      boundary = '-';
    var $receiver = new ChunkedResponse(statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary);
    var tmp$;
    tmp$ = withIndex(parts).iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var index = element.component1()
      , part = element.component2();
      $receiver.send_o0ij6q$(part, index === 0, index === get_lastIndex(parts));
    }
    return $receiver.response;
  }
  function Coroutine$asChunked$lambda(payload_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$payload = payload_0;
  }
  Coroutine$asChunked$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$asChunked$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$asChunked$lambda.prototype.constructor = Coroutine$asChunked$lambda;
  Coroutine$asChunked$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var $receiver = new Buffer_0();
            $receiver.writeHexadecimalUnsignedLong_s8cxhz$(Kotlin.Long.fromInt(this.local$payload.size));
            $receiver.writeUtf8_61zpoe$('\r\n');
            $receiver.write_9ovubf$(this.local$payload);
            $receiver.writeUtf8_61zpoe$('\r\n');
            var buffer = $receiver;
            return buffer.readByteString();
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function asChunked$lambda(payload_0, continuation_0, suspended) {
    var instance = new Coroutine$asChunked$lambda(payload_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$asChunked$lambda_0($receiver_0, it_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$asChunked$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$asChunked$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$asChunked$lambda_0.prototype.constructor = Coroutine$asChunked$lambda_0;
  Coroutine$asChunked$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$$receiver.emit_11rb$(ByteString.Companion.encodeUtf8_pdl1vz$('0\r\n\r\n'), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function asChunked$lambda_0($receiver_0, it_0, continuation_0, suspended) {
    var instance = new Coroutine$asChunked$lambda_0($receiver_0, it_0, this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function asChunked($receiver) {
    return onCompletion(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(asChunked$lambda), $receiver)), asChunked$lambda_0);
  }
  function createMultipartMixedPart(content, contentType, boundary, isFirst, isLast) {
    if (contentType === void 0)
      contentType = 'application/json; charset=utf-8';
    if (boundary === void 0)
      boundary = '-';
    if (isFirst === void 0)
      isFirst = false;
    if (isLast === void 0)
      isLast = false;
    var startBoundary = isFirst ? '--' + boundary + '\r' + '\n' : '';
    var contentLengthHeader = 'Content-Length: ' + content.length;
    var contentTypeHeader = 'Content-Type: ' + contentType;
    var endBoundary = isLast ? '--' + boundary + '--' : '--' + boundary;
    return startBoundary + (contentLengthHeader + '\r' + '\n') + (contentTypeHeader + '\r' + '\n') + '\r\n' + (content + '\r' + '\n') + (endBoundary + '\r' + '\n');
  }
  function ChunkedResponse(statusCode, partsContentType, headers, responseDelayMillis, chunksDelayMillis, boundary) {
    if (statusCode === void 0)
      statusCode = 200;
    if (partsContentType === void 0)
      partsContentType = 'application/json; charset=utf-8';
    if (headers === void 0)
      headers = emptyMap();
    if (responseDelayMillis === void 0)
      responseDelayMillis = L0;
    if (chunksDelayMillis === void 0)
      chunksDelayMillis = L0;
    if (boundary === void 0)
      boundary = '-';
    this.partsContentType_0 = partsContentType;
    this.boundary_0 = boundary;
    this.chunkChannel_0 = Channel(2147483647);
    var tmp$ = (new MockResponse$Builder()).statusCode_za3lpa$(statusCode);
    var $receiver = receiveAsFlow(this.chunkChannel_0);
    this.response = tmp$.body_q7dri2$(asChunked(new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(map$lambda(ChunkedResponse$response$lambda(chunksDelayMillis)), $receiver)))).headers_y0zsll$(plus(headers, mapOf_0([to('Content-Type', 'multipart/mixed; boundary=' + '"' + this.boundary_0 + '"'), to('Transfer-Encoding', 'chunked')]))).delayMillis_s8cxhz$(responseDelayMillis).build();
  }
  ChunkedResponse.prototype.send_o0ij6q$ = function (content, isFirst, isLast) {
    if (isFirst === void 0)
      isFirst = false;
    if (isLast === void 0)
      isLast = false;
    var tmp$, tmp$_0, tmp$_1;
    tmp$_1 = this.chunkChannel_0;
    tmp$ = this.partsContentType_0;
    tmp$_0 = this.boundary_0;
    tmp$_1.trySend_11rb$(ByteString.Companion.encodeUtf8_pdl1vz$(createMultipartMixedPart(content, tmp$, tmp$_0, isFirst, isLast)));
    if (isLast)
      this.chunkChannel_0.close_dbl4no$();
  };
  function Coroutine$ChunkedResponse$response$lambda(closure$chunksDelayMillis_0, it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$chunksDelayMillis = closure$chunksDelayMillis_0;
    this.local$it = it_0;
  }
  Coroutine$ChunkedResponse$response$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$ChunkedResponse$response$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$ChunkedResponse$response$lambda.prototype.constructor = Coroutine$ChunkedResponse$response$lambda;
  Coroutine$ChunkedResponse$response$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = delay(this.local$closure$chunksDelayMillis, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.local$it;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function ChunkedResponse$response$lambda(closure$chunksDelayMillis_0) {
    return function (it_0, continuation_0, suspended) {
      var instance = new Coroutine$ChunkedResponse$response$lambda(closure$chunksDelayMillis_0, it_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  ChunkedResponse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChunkedResponse',
    interfaces: []
  };
  function CommonQueueMockServerHandler() {
    this.queue_0 = ArrayDeque_init();
  }
  CommonQueueMockServerHandler.prototype.enqueue_wvyhoh$ = function (response) {
    this.queue_0.add_11rb$(response);
  };
  CommonQueueMockServerHandler.prototype.handle_cpqzap$ = function (request) {
    var tmp$;
    var tmp$_0;
    if ((tmp$ = this.queue_0.removeFirstOrNull()) != null)
      tmp$_0 = tmp$;
    else {
      throw IllegalStateException_init('No more responses in queue'.toString());
    }
    return tmp$_0;
  };
  CommonQueueMockServerHandler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonQueueMockServerHandler',
    interfaces: [MockServerHandler]
  };
  function suspendCoroutine$lambda(closure$block) {
    return function (c) {
      var safe = SafeContinuation_init(intercepted(c));
      closure$block(safe);
      return safe.getOrThrow();
    };
  }
  function MockServer(mockServerHandler) {
    if (mockServerHandler === void 0)
      mockServerHandler = new CommonQueueMockServerHandler();
    this.mockServerHandler_v3r0js$_0 = mockServerHandler;
    this.requests_0 = ArrayList_init();
    this.url_0 = null;
    this.server_0 = createServer(MockServer$server$lambda(this)).listen();
  }
  Object.defineProperty(MockServer.prototype, 'mockServerHandler', {
    get: function () {
      return this.mockServerHandler_v3r0js$_0;
    }
  });
  function MockServer$url$lambda$lambda(closure$cont, this$MockServer) {
    return function (f) {
      var $receiver = closure$cont;
      var value = ensureNotNull(this$MockServer.url_0);
      $receiver.resumeWith_tl1gpc$(new Result(value));
      return Unit;
    };
  }
  function MockServer$url$lambda(this$MockServer) {
    return function (cont) {
      this$MockServer.url_0 = 'http://localhost:' + this$MockServer.server_0.address().port.toString() + '/';
      this$MockServer.server_0.on('listening', MockServer$url$lambda$lambda(cont, this$MockServer));
      return Unit;
    };
  }
  function Coroutine$url($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
  }
  Coroutine$url.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$url.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$url.prototype.constructor = Coroutine$url;
  Coroutine$url.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$tmp$ = this.$this.url_0;
            if (this.local$tmp$ == null) {
              this.state_0 = 2;
              this.result_0 = suspendCoroutine$lambda(MockServer$url$lambda(this.$this))(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 3;
              continue;
            }

          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            this.local$tmp$ = this.result_0;
            this.state_0 = 3;
            continue;
          case 3:
            return this.local$tmp$;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MockServer.prototype.url = function (continuation_0, suspended) {
    var instance = new Coroutine$url(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  MockServer.prototype.enqueue_wvyhoh$ = function (mockResponse) {
    var tmp$, tmp$_0;
    if (((tmp$_0 = Kotlin.isType(tmp$ = this.mockServerHandler, CommonQueueMockServerHandler) ? tmp$ : null) != null ? (tmp$_0.enqueue_wvyhoh$(mockResponse), Unit) : null) == null) {
      throw IllegalStateException_init('Apollo: cannot call MockServer.enqueue() with a custom handler'.toString());
    }
  };
  MockServer.prototype.takeRequest = function () {
    return removeFirst(this.requests_0);
  };
  function MockServer$stop$lambda$lambda(closure$cont) {
    return function (it) {
      closure$cont.resumeWith_tl1gpc$(new Result(Unit));
      return Unit;
    };
  }
  function MockServer$stop$lambda(this$MockServer) {
    return function (cont) {
      this$MockServer.server_0.close(MockServer$stop$lambda$lambda(cont));
      return Unit;
    };
  }
  function Coroutine$stop($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$stop.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$stop.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$stop.prototype.constructor = Coroutine$stop;
  Coroutine$stop.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCoroutine$lambda(MockServer$stop$lambda(this.$this))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MockServer.prototype.stop = function (continuation_0, suspended) {
    var instance = new Coroutine$stop(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  MockServer.prototype.asByteArray_0 = function ($receiver) {
    return new Int8Array($receiver.buffer, $receiver.byteOffset, $receiver.length);
  };
  function MockServer$SocketSink(socket) {
    this.socket_0 = socket;
  }
  MockServer$SocketSink.prototype.write_u27jpl$ = function (source, byteCount) {
    this.socket_0.write(this.toUint8Array_0(source, byteCount));
  };
  MockServer$SocketSink.prototype.toUint8Array_0 = function ($receiver, count) {
    var tmp$;
    var array = new Uint8Array(count.toInt());
    tmp$ = count.toInt();
    for (var i = 0; i < tmp$; i++) {
      array[i] = $receiver.get_s8cxhz$(Kotlin.Long.fromInt(i));
    }
    $receiver.skip_s8cxhz$(count);
    return array;
  };
  MockServer$SocketSink.prototype.close = function () {
  };
  MockServer$SocketSink.prototype.flush = function () {
  };
  MockServer$SocketSink.prototype.timeout = function () {
    return Timeout.Companion.NONE;
  };
  MockServer$SocketSink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SocketSink',
    interfaces: [Sink]
  };
  function Coroutine$MockServer$server$lambda$lambda$lambda(closure$mockResponse_0, closure$socket_0, closure$request_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$mockResponse = closure$mockResponse_0;
    this.local$closure$socket = closure$socket_0;
    this.local$closure$request = closure$request_0;
  }
  Coroutine$MockServer$server$lambda$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$MockServer$server$lambda$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$MockServer$server$lambda$lambda$lambda.prototype.constructor = Coroutine$MockServer$server$lambda$lambda$lambda;
  Coroutine$MockServer$server$lambda$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = delay(this.local$closure$mockResponse.delayMillis, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = writeResponse(buffer(new MockServer$SocketSink(this.local$closure$socket)), this.local$closure$mockResponse, this.local$closure$request.version, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return this.local$closure$socket.end(), Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function MockServer$server$lambda$lambda$lambda(closure$mockResponse_0, closure$socket_0, closure$request_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$MockServer$server$lambda$lambda$lambda(closure$mockResponse_0, closure$socket_0, closure$request_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function MockServer$server$lambda$lambda(closure$requestBody, this$MockServer, closure$socket) {
    return function (chunk) {
      var tmp$;
      if (typeof chunk === 'string')
        closure$requestBody.writeUtf8_61zpoe$(chunk);
      else if (Kotlin.isType(chunk, Buffer))
        closure$requestBody.write_fqrh44$(this$MockServer.asByteArray_0(chunk));
      else {
        throw IllegalStateException_init(('Unexpected chunk type: ' + Kotlin.getKClassFromExpression(chunk)).toString());
      }
      var request = ensureNotNull(readRequest(closure$requestBody));
      this$MockServer.requests_0.add_11rb$(request);
      try {
        tmp$ = this$MockServer.mockServerHandler.handle_cpqzap$(request);
      } catch (e) {
        if (Kotlin.isType(e, Exception)) {
          throw new Exception('MockServerHandler.handle() threw an exception: ' + toString(e.message), e);
        } else
          throw e;
      }
      var mockResponse = tmp$;
      launch(coroutines.GlobalScope, void 0, void 0, MockServer$server$lambda$lambda$lambda(mockResponse, closure$socket, request));
      return Unit;
    };
  }
  function MockServer$server$lambda(this$MockServer) {
    return function (socket) {
      var requestBody = new Buffer_0();
      socket.on('data', MockServer$server$lambda$lambda(requestBody, this$MockServer, socket));
      return Unit;
    };
  }
  MockServer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockServer',
    interfaces: [MockServerInterface]
  };
  var package$com = _.com || (_.com = {});
  var package$apollographql = package$com.apollographql || (package$com.apollographql = {});
  var package$apollo3 = package$apollographql.apollo3 || (package$apollographql.apollo3 = {});
  var package$mockserver = package$apollo3.mockserver || (package$apollo3.mockserver = {});
  package$mockserver.MockServerInterface = MockServerInterface;
  package$mockserver.parseHeader_61zpoe$ = parseHeader;
  package$mockserver.MockRequest = MockRequest;
  package$mockserver.writeResponse_t309ff$ = writeResponse;
  MockResponse.Builder = MockResponse$Builder;
  package$mockserver.MockResponse_init_88fjrk$ = MockResponse_init;
  package$mockserver.MockResponse_init_8ir4nr$ = MockResponse_init_0;
  package$mockserver.MockResponse = MockResponse;
  package$mockserver.MockServerHandler = MockServerHandler;
  package$mockserver.readRequest_7yjnbr$ = readRequest;
  package$mockserver.readChunked_v6zixv$ = readChunked;
  package$mockserver.parseRequestLine_61zpoe$ = parseRequestLine;
  package$mockserver.enqueue_3g6on5$ = enqueue;
  package$mockserver.enqueueMultipart_x3s6tm$ = enqueueMultipart;
  package$mockserver.createMultipartMixedChunkedResponse_w7f726$ = createMultipartMixedChunkedResponse;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$mockserver.asChunked_v0m2ut$ = asChunked;
  package$mockserver.createMultipartMixedPart_6a2sji$ = createMultipartMixedPart;
  package$mockserver.ChunkedResponse = ChunkedResponse;
  package$mockserver.CommonQueueMockServerHandler = CommonQueueMockServerHandler;
  package$mockserver.MockServer = MockServer;
  Kotlin.defineModule('apollo-kotlin-apollo-mockserver-js-legacy', _);
  return _;
}));

//# sourceMappingURL=apollo-kotlin-apollo-mockserver-js-legacy.js.map
