(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'okio-parent-okio-js-legacy', 'http'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('okio-parent-okio-js-legacy'), require('http'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-mockserver-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'apollo-android-apollo-mockserver-js-legacy'.");
    }if (typeof this['okio-parent-okio-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-mockserver-js-legacy'. Its dependency 'okio-parent-okio-js-legacy' was not found. Please, check whether 'okio-parent-okio-js-legacy' is loaded prior to 'apollo-android-apollo-mockserver-js-legacy'.");
    }if (typeof http === 'undefined') {
      throw new Error("Error loading module 'apollo-android-apollo-mockserver-js-legacy'. Its dependency 'http' was not found. Please, check whether 'http' is loaded prior to 'apollo-android-apollo-mockserver-js-legacy'.");
    }root['apollo-android-apollo-mockserver-js-legacy'] = factory(typeof this['apollo-android-apollo-mockserver-js-legacy'] === 'undefined' ? {} : this['apollo-android-apollo-mockserver-js-legacy'], kotlin, this['okio-parent-okio-js-legacy'], http);
  }
}(this, function (_, Kotlin, $module$okio_parent_okio_js_legacy, $module$http) {
  'use strict';
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var unboxChar = Kotlin.unboxChar;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var ByteString = $module$okio_parent_okio_js_legacy.okio.ByteString;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var plus = Kotlin.kotlin.collections.plus_iwxh38$;
  var L0 = Kotlin.Long.ZERO;
  var toLongOrNull = Kotlin.kotlin.text.toLongOrNull_pdl1vz$;
  var equals = Kotlin.equals;
  var toString = Kotlin.toString;
  var Buffer_0 = $module$okio_parent_okio_js_legacy.okio.Buffer;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var listOf = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var Triple = Kotlin.kotlin.Triple;
  var get_indices = Kotlin.kotlin.text.get_indices_gw00vp$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var throwCCE = Kotlin.throwCCE;
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var isBlank = Kotlin.kotlin.text.isBlank_gw00vp$;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var Unit = Kotlin.kotlin.Unit;
  var removeFirst = Kotlin.kotlin.collections.removeFirst_vvxzk3$;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var toList = Kotlin.kotlin.collections.toList_us0mfu$;
  var zipWithNext = Kotlin.kotlin.collections.zipWithNext_7wnvza$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var createServer = $module$http.createServer;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Result = Kotlin.kotlin.Result;
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var SafeContinuation_init = Kotlin.kotlin.coroutines.SafeContinuation_init_wj8d80$;
  function MockServerInterface() {
  }
  MockServerInterface.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MockServerInterface',
    interfaces: []
  };
  function parseHeader(line) {
    var indexOfFirst$result;
    indexOfFirst$break: do {
      var tmp$, tmp$_0, tmp$_1, tmp$_2;
      tmp$ = get_indices(line);
      tmp$_0 = tmp$.first;
      tmp$_1 = tmp$.last;
      tmp$_2 = tmp$.step;
      for (var index = tmp$_0; index <= tmp$_1; index += tmp$_2) {
        if (unboxChar(toBoxedChar(line.charCodeAt(index))) === 58) {
          indexOfFirst$result = index;
          break indexOfFirst$break;
        }}
      indexOfFirst$result = -1;
    }
     while (false);
    var index_0 = indexOfFirst$result;
    if (!(index_0 >= 0)) {
      var message = 'Invalid header: ' + line;
      throw IllegalStateException_init(message.toString());
    }var $receiver = line.substring(0, index_0);
    var tmp$_3;
    var tmp$_4 = trim(Kotlin.isCharSequence(tmp$_3 = $receiver) ? tmp$_3 : throwCCE()).toString();
    var startIndex = index_0 + 1 | 0;
    var endIndex = line.length;
    var $receiver_0 = line.substring(startIndex, endIndex);
    var tmp$_5;
    return to(tmp$_4, trim(Kotlin.isCharSequence(tmp$_5 = $receiver_0) ? tmp$_5 : throwCCE()).toString());
  }
  function MockRecordedRequest(method, path, version, headers, body) {
    if (headers === void 0)
      headers = emptyMap();
    if (body === void 0)
      body = ByteString.Companion.EMPTY;
    this.method = method;
    this.path = path;
    this.version = version;
    this.headers = headers;
    this.body = body;
  }
  MockRecordedRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockRecordedRequest',
    interfaces: []
  };
  function writeResponse(sink, mockResponse, version) {
    sink.writeUtf8_61zpoe$(version + ' ' + mockResponse.statusCode + '\r' + '\n');
    var contentLengthHeader = mapOf(to('Content-Length', mockResponse.body.size.toString()));
    var tmp$;
    tmp$ = plus(contentLengthHeader, mockResponse.headers).entries.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      sink.writeUtf8_61zpoe$(element.key + ': ' + element.value + '\r' + '\n');
    }
    sink.writeUtf8_61zpoe$('\r\n');
    sink.flush();
    if (mockResponse.body.size > 0) {
      sink.write_9ovubf$(mockResponse.body);
    }sink.flush();
  }
  function MockResponse(statusCode, body, headers, delayMillis) {
    if (statusCode === void 0)
      statusCode = 200;
    if (body === void 0)
      body = ByteString.Companion.EMPTY;
    if (headers === void 0)
      headers = emptyMap();
    if (delayMillis === void 0)
      delayMillis = L0;
    this.statusCode = statusCode;
    this.body = body;
    this.headers = headers;
    this.delayMillis = delayMillis;
  }
  MockResponse.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockResponse',
    interfaces: []
  };
  function MockResponse_init(body, statusCode, headers, $this) {
    if (statusCode === void 0)
      statusCode = 200;
    if (headers === void 0)
      headers = emptyMap();
    $this = $this || Object.create(MockResponse.prototype);
    MockResponse.call($this, statusCode, ByteString.Companion.encodeUtf8_pdl1vz$(body), headers);
    return $this;
  }
  function readRequest(source) {
    var tmp$, tmp$_0, tmp$_1;
    var line = source.readUtf8Line();
    if (line == null) {
      return null;
    }var tmp$_2 = parseRequestLine(line);
    var method = tmp$_2.component1()
    , path = tmp$_2.component2()
    , version = tmp$_2.component3();
    var headers = LinkedHashMap_init();
    while (true) {
      line = source.readUtf8Line();
      var $receiver = line;
      if ($receiver == null || isBlank($receiver)) {
        break;
      }var tmp$_3 = parseHeader(line);
      var key = tmp$_3.component1()
      , value = tmp$_3.component2();
      headers.put_xwzc9p$(key, value);
    }
    var contentLength = (tmp$_0 = (tmp$ = headers.get_11rb$('Content-Length')) != null ? toLongOrNull(tmp$) : null) != null ? tmp$_0 : L0;
    var transferEncoding = (tmp$_1 = headers.get_11rb$('Transfer-Encoding')) != null ? tmp$_1.toLowerCase() : null;
    if (!(transferEncoding == null || equals(transferEncoding, 'identity'))) {
      var message = 'Transfer-Encoding ' + toString(transferEncoding) + ' is not supported';
      throw IllegalStateException_init(message.toString());
    }var buffer = new Buffer_0();
    if (contentLength.toNumber() > 0) {
      source.read_u27jpl$(buffer, contentLength);
    }return new MockRecordedRequest(method, path, version, headers, buffer.readByteString());
  }
  function parseRequestLine(line) {
    var regex = Regex_init('([A-Z-a-z]*) ([^ ]*) (.*)');
    var match = regex.matchEntire_6bul2c$(line);
    if (!(match != null)) {
      var message = 'Cannot match request line: ' + line;
      throw IllegalStateException_init(message.toString());
    }var method = match.groupValues.get_za3lpa$(1).toUpperCase();
    if (!listOf(['GET', 'POST', 'PUT', 'DELETE', 'HEAD', 'OPTIONS', 'PATCH']).contains_11rb$(method)) {
      var message_0 = 'Unkown method ' + method;
      throw IllegalStateException_init(message_0.toString());
    }return new Triple(method, match.groupValues.get_za3lpa$(2), match.groupValues.get_za3lpa$(3));
  }
  function enqueue($receiver, string, delayMs) {
    if (delayMs === void 0)
      delayMs = L0;
    var byteString = ByteString.Companion.encodeUtf8_pdl1vz$(string);
    $receiver.enqueue_wvyhoh$(new MockResponse(200, byteString, mapOf(to('Content-Length', byteString.size.toString())), delayMs));
  }
  function suspendCoroutine$lambda(closure$block) {
    return function (c) {
      var safe = SafeContinuation_init(intercepted(c));
      closure$block(safe);
      return safe.getOrThrow();
    };
  }
  function MockServer() {
    this.responseQueue_0 = ArrayList_init();
    this.requests_0 = ArrayList_init();
    this.server_0 = createServer(MockServer$server$lambda(this)).listen();
  }
  function MockServer$url$lambda$lambda(closure$cont, this$MockServer) {
    return function (f) {
      var tmp$ = closure$cont;
      var value = 'http://localhost:' + this$MockServer.server_0.address().port.toString();
      tmp$.resumeWith_tl1gpc$(new Result(value));
      return Unit;
    };
  }
  function MockServer$url$lambda(this$MockServer) {
    return function (cont) {
      this$MockServer.server_0.on('listening', MockServer$url$lambda$lambda(cont, this$MockServer));
      return Unit;
    };
  }
  function Coroutine$url($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$url.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$url.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$url.prototype.constructor = Coroutine$url;
  Coroutine$url.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCoroutine$lambda(MockServer$url$lambda(this.$this))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MockServer.prototype.url = function (continuation_0, suspended) {
    var instance = new Coroutine$url(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  MockServer.prototype.enqueue_wvyhoh$ = function (mockResponse) {
    this.responseQueue_0.add_11rb$(mockResponse);
  };
  MockServer.prototype.takeRequest = function () {
    return removeFirst(this.requests_0);
  };
  function MockServer$stop$lambda$lambda(closure$cont) {
    return function (it) {
      closure$cont.resumeWith_tl1gpc$(new Result(Unit));
      return Unit;
    };
  }
  function MockServer$stop$lambda(this$MockServer) {
    return function (cont) {
      this$MockServer.server_0.close(MockServer$stop$lambda$lambda(cont));
      return Unit;
    };
  }
  function Coroutine$stop($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$stop.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$stop.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$stop.prototype.constructor = Coroutine$stop;
  Coroutine$stop.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = suspendCoroutine$lambda(MockServer$stop$lambda(this.$this))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.result_0;
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MockServer.prototype.stop = function (continuation_0, suspended) {
    var instance = new Coroutine$stop(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function MockServer$server$lambda$lambda(closure$requestBody) {
    return function (chunk) {
      if (typeof chunk === 'string')
        closure$requestBody.append_pdl1vj$(chunk);
      else if (Kotlin.isType(chunk, Buffer))
        closure$requestBody.append_pdl1vj$(chunk.toString('utf8'));
      else
        println('WTF');
      return Unit;
    };
  }
  function MockServer$server$lambda$lambda_0(this$MockServer, closure$req, closure$requestBody) {
    return function (f) {
      this$MockServer.requests_0.add_11rb$(new MockRecordedRequest(closure$req.method, closure$req.url, closure$req.httpVersion, toMap(zipWithNext(toList(closure$req.rawHeaders))), ByteString.Companion.toByteString_ietg8x$(encodeToByteArray(closure$requestBody.toString()))));
      return Unit;
    };
  }
  function MockServer$server$lambda(this$MockServer) {
    return function (req, res) {
      var requestBody = StringBuilder_init();
      req.on('data', MockServer$server$lambda$lambda(requestBody));
      req.on('end', MockServer$server$lambda$lambda_0(this$MockServer, req, requestBody));
      var mockResponse = removeFirst(this$MockServer.responseQueue_0);
      res.statusCode = mockResponse.statusCode;
      var tmp$;
      tmp$ = mockResponse.headers.entries.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        res.setHeader(element.key, element.value);
      }
      res.end(mockResponse.body.utf8());
      return Unit;
    };
  }
  MockServer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MockServer',
    interfaces: [MockServerInterface]
  };
  var package$com = _.com || (_.com = {});
  var package$apollographql = package$com.apollographql || (package$com.apollographql = {});
  var package$apollo3 = package$apollographql.apollo3 || (package$apollographql.apollo3 = {});
  var package$mockserver = package$apollo3.mockserver || (package$apollo3.mockserver = {});
  package$mockserver.MockServerInterface = MockServerInterface;
  package$mockserver.parseHeader_61zpoe$ = parseHeader;
  package$mockserver.MockRecordedRequest = MockRecordedRequest;
  package$mockserver.writeResponse_t309ff$ = writeResponse;
  package$mockserver.MockResponse_init_ff7b0z$ = MockResponse_init;
  package$mockserver.MockResponse = MockResponse;
  package$mockserver.readRequest_7yjnbr$ = readRequest;
  package$mockserver.parseRequestLine_61zpoe$ = parseRequestLine;
  package$mockserver.enqueue_sfupap$ = enqueue;
  package$mockserver.MockServer = MockServer;
  Kotlin.defineModule('apollo-android-apollo-mockserver-js-legacy', _);
  return _;
}));

//# sourceMappingURL=apollo-android-apollo-mockserver-js-legacy.js.map
