/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.ApolloHttpCache;
import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache;", "Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "fileSystem", "Lokio/FileSystem;", "directory", "Ljava/io/File;", "maxSize", "", "(Lokio/FileSystem;Ljava/io/File;J)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "", "kotlin.jvm.PlatformType", "cache", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "clearAll", "", "createDiskLruCache", "read", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "cacheKey", "", "remove", "write", "response", "Companion", "ProxySource", "apollo-http-cache"})
@SourceDebugExtension(value={"SMAP\nDiskLruHttpCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruHttpCache.kt\ncom/apollographql/apollo3/cache/http/DiskLruHttpCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1547#2:172\n1618#2,3:173\n1547#2:176\n1618#2,3:177\n1#3:180\n*S KotlinDebug\n*F\n+ 1 DiskLruHttpCache.kt\ncom/apollographql/apollo3/cache/http/DiskLruHttpCache\n*L\n39#1:172\n39#1:173,3\n64#1:176\n64#1:177,3\n*E\n"})
public final class DiskLruHttpCache
implements ApolloHttpCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final long maxSize;
    @NotNull
    private DiskLruCache cache;
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    private final JsonAdapter<Object> adapter;
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public DiskLruHttpCache(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cache = this.createDiskLruCache();
        this.cacheLock = new ReentrantReadWriteLock();
        this.adapter = new Moshi.Builder().build().adapter(Object.class);
    }

    private final DiskLruCache createDiskLruCache() {
        return DiskLruCache.Companion.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HttpResponse read(@NotNull String cacheKey) {
        List list;
        Object it2;
        DiskLruCache.Snapshot snapshot;
        DiskLruCache.Snapshot snapshot2;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            snapshot2 = this.cache.get(cacheKey);
            snapshot = snapshot2;
        }
        finally {
            readLock.unlock();
        }
        if (snapshot == null) {
            throw new IllegalStateException("HTTP cache: no snapshot".toString());
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        Source source = snapshot3.getSource(0);
        Closeable closeable = (Closeable)Okio.buffer((Source)source);
        Throwable throwable = null;
        try {
            it2 = (BufferedSource)closeable;
            boolean bl = false;
            it2 = this.adapter.fromJson(it2);
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        snapshot2 = it2;
        Map map = snapshot2 instanceof Map ? (Map)((Object)snapshot2) : null;
        if (map == null) {
            throw new IllegalStateException("HTTP cache: no map".toString());
        }
        Map map2 = map;
        closeable = map2.get("headers");
        List list2 = closeable instanceof List ? (List)((Object)closeable) : null;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            it2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Map map3 = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)CollectionsKt.single((Iterable)it3.entrySet());
                collection.add(new HttpHeader((String)entry.getKey(), (String)entry.getValue()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List headers = list;
        closeable = map2.get("statusCode");
        String string = closeable instanceof String ? (String)((Object)closeable) : null;
        if (string == null) {
            throw new IllegalStateException("HTTP cache: no statusCode".toString());
        }
        List list3 = headers;
        if (list3 == null) {
            throw new IllegalStateException("HTTP cache: no headers".toString());
        }
        return new HttpResponse.Builder(Integer.parseInt(string)).body(Okio.buffer((Source)snapshot3.getSource(1))).addHeaders(list3).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HttpResponse write(@NotNull HttpResponse response, @NotNull String cacheKey) {
        DiskLruCache.Editor editor;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-DiskLruHttpCache$write$editor$22 = false;
            DiskLruCache.Editor $i$a$-read-DiskLruHttpCache$write$editor$22 = this.cache.edit(cacheKey);
            editor = $i$a$-read-DiskLruHttpCache$write$editor$22;
        }
        finally {
            readLock.unlock();
        }
        if (editor == null) {
            return response;
        }
        DiskLruCache.Editor editor2 = editor;
        try {
            Closeable closeable = (Closeable)Okio.buffer((Sink)editor2.newSink(0));
            Throwable throwable = null;
            try {
                Collection<Map> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                BufferedSink it = (BufferedSink)closeable;
                boolean bl = false;
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"statusCode", (Object)String.valueOf(response.getStatusCode()));
                Iterable iterable = response.getHeaders();
                String string = "headers";
                int n = 1;
                Pair[] pairArray2 = pairArray;
                boolean $i$f$map = false;
                void var14_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void httpHeader;
                    HttpHeader httpHeader2 = (HttpHeader)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)httpHeader.getName(), (Object)httpHeader.getValue())));
                }
                collection = (List)destination$iv$iv;
                pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
                Map map = MapsKt.mapOf((Pair[])pairArray);
                this.adapter.toJson(it, (Object)map);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Sink bodySink = editor2.newSink(1);
            Throwable $this$write_u24lambda_u247 = throwable = new HttpResponse.Builder(response.getStatusCode());
            boolean bl = false;
            $this$write_u24lambda_u247.headers(response.getHeaders());
            BufferedSource bufferedSource = response.getBody();
            if (bufferedSource != null) {
                BufferedSource it = bufferedSource;
                boolean bl3 = false;
                $this$write_u24lambda_u247.body(Okio.buffer((Source)new ProxySource((Source)it, bodySink, editor2)));
            }
            return throwable.build();
        }
        catch (Exception e) {
            editor2.abort();
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() throws IOException {
        DiskLruCache diskLruCache;
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        DiskLruHttpCache diskLruHttpCache = this;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.cache.delete();
            diskLruCache = this.createDiskLruCache();
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        diskLruHttpCache.cache = diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.cache.remove(cacheKey);
        }
        finally {
            readLock.unlock();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_HEADERS", "VERSION", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache$ProxySource;", "Lokio/Source;", "originalSource", "sink", "Lokio/Sink;", "cacheEditor", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "(Lokio/Source;Lokio/Sink;Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache$Editor;)V", "buffer", "Lokio/Buffer;", "hasClosedAndCommitted", "", "hasReadError", "close", "", "read", "", "byteCount", "timeout", "Lokio/Timeout;", "apollo-http-cache"})
    private static final class ProxySource
    implements Source {
        @NotNull
        private final Source originalSource;
        @NotNull
        private final Sink sink;
        @NotNull
        private final DiskLruCache.Editor cacheEditor;
        @NotNull
        private final Buffer buffer;
        private boolean hasClosedAndCommitted;
        private boolean hasReadError;

        public ProxySource(@NotNull Source originalSource, @NotNull Sink sink, @NotNull DiskLruCache.Editor cacheEditor) {
            Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)cacheEditor, (String)"cacheEditor");
            this.originalSource = originalSource;
            this.sink = sink;
            this.cacheEditor = cacheEditor;
            this.buffer = new Buffer();
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                l = this.originalSource.read(this.buffer, byteCount);
            }
            catch (Exception e) {
                this.hasReadError = true;
                throw e;
            }
            long read = l;
            if (read == -1L) {
                return -1L;
            }
            try {
                this.buffer.peek().readAll(this.sink);
            }
            catch (Exception e) {
                this.hasReadError = true;
            }
            try {
                sink.writeAll((Source)this.buffer);
            }
            catch (Exception e) {
                this.hasReadError = true;
                throw e;
            }
            return read;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (!this.hasClosedAndCommitted) {
                try {
                    this.sink.close();
                    if (this.hasReadError) {
                        this.cacheEditor.abort();
                    } else {
                        this.cacheEditor.commit();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.hasClosedAndCommitted = true;
                }
                this.originalSource.close();
            }
        }

        @NotNull
        public Timeout timeout() {
            return this.originalSource.timeout();
        }
    }
}

