/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloRequest;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.MutableExecutionOptions;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.api.Subscription;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpRequest;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.ApolloHttpCache;
import com.apollographql.apollo3.cache.http.CachingHttpInterceptor;
import com.apollographql.apollo3.cache.http.HttpCache;
import com.apollographql.apollo3.cache.http.HttpFetchPolicy;
import com.apollographql.apollo3.cache.http.HttpFetchPolicyContext;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo3.network.NetworkTransport;
import com.apollographql.apollo3.network.http.HttpInfo;
import com.apollographql.apollo3.network.http.HttpInterceptor;
import com.apollographql.apollo3.network.http.HttpInterceptorChain;
import com.apollographql.apollo3.network.http.HttpNetworkTransport;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002\u001a!\u0010\u0000\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\b\u0014\u001a#\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0018\u001a#\u0010\u0019\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010\u0019\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0018\u001a#\u0010\u001a\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010\u001a\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001b\u001a#\u0010\u001c\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\u0006\u0010\u001c\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001d\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"%\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b*\b\u0012\u0004\u0012\u0002H\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\n\u00a8\u0006\u001e"}, d2={"httpCache", "Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "Lcom/apollographql/apollo3/ApolloClient;", "getHttpCache", "(Lcom/apollographql/apollo3/ApolloClient;)Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "isFromHttpCache", "", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "(Lcom/apollographql/apollo3/api/ApolloResponse;)Z", "defaultPolicy", "Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;", "operation", "Lcom/apollographql/apollo3/api/Operation;", "Lcom/apollographql/apollo3/ApolloClient$Builder;", "directory", "Ljava/io/File;", "maxSize", "", "configureApolloClientBuilder", "httpDoNotStore", "T", "Lcom/apollographql/apollo3/api/MutableExecutionOptions;", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;Z)Ljava/lang/Object;", "httpExpireAfterRead", "httpExpireTimeout", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;J)Ljava/lang/Object;", "httpFetchPolicy", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;)Ljava/lang/Object;", "apollo-http-cache"})
@JvmName(name="HttpCache")
public final class HttpCache {
    @JvmName(name="configureApolloClientBuilder")
    @NotNull
    public static final ApolloClient.Builder configureApolloClientBuilder(@NotNull ApolloClient.Builder $this$httpCache, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        CachingHttpInterceptor cachingHttpInterceptor = new CachingHttpInterceptor(directory, maxSize, null, 4, null);
        Ref.ObjectRef cacheKey = new Ref.ObjectRef();
        return $this$httpCache.addHttpInterceptor(new HttpInterceptor((Ref.ObjectRef<String>)cacheKey){
            final /* synthetic */ Ref.ObjectRef<String> $cacheKey;
            {
                this.$cacheKey = $cacheKey;
            }

            @Nullable
            public Object intercept(@NotNull HttpRequest request, @NotNull HttpInterceptorChain chain, @NotNull Continuation<? super HttpResponse> $completion) {
                this.$cacheKey.element = CachingHttpInterceptor.Companion.cacheKey(request);
                HttpRequest.Builder builder = HttpRequest.newBuilder$default((HttpRequest)request, null, null, (int)3, null);
                Object object = this.$cacheKey.element;
                Intrinsics.checkNotNull((Object)object);
                return chain.proceed(builder.addHeader("X-APOLLO-CACHE-KEY", (String)object).build(), $completion);
            }

            public void dispose() {
                HttpInterceptor.DefaultImpls.dispose((HttpInterceptor)this);
            }
        }).addHttpInterceptor((HttpInterceptor)cachingHttpInterceptor).addInterceptor(new ApolloInterceptor((Ref.ObjectRef<String>)cacheKey, cachingHttpInterceptor){
            final /* synthetic */ Ref.ObjectRef<String> $cacheKey;
            final /* synthetic */ CachingHttpInterceptor $cachingHttpInterceptor;
            {
                this.$cacheKey = $cacheKey;
                this.$cachingHttpInterceptor = $cachingHttpInterceptor;
            }

            @NotNull
            public <D extends Operation.Data> Flow<ApolloResponse<D>> intercept(@NotNull ApolloRequest<D> request, @NotNull ApolloInterceptorChain chain) {
                String string;
                String string2;
                Intrinsics.checkNotNullParameter(request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Object object = (HttpFetchPolicyContext)request.getExecutionContext().get((ExecutionContext.Key)HttpFetchPolicyContext.Key);
                if (object == null || (object = object.getHttpFetchPolicy()) == null) {
                    object = HttpCache.access$defaultPolicy(request.getOperation());
                }
                HttpFetchPolicyContext policy = object;
                switch (httpCache.WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)policy)).ordinal()]) {
                    case 1: {
                        string2 = "CACHE_FIRST";
                        break;
                    }
                    case 2: {
                        string2 = "CACHE_ONLY";
                        break;
                    }
                    case 3: {
                        string2 = "NETWORK_FIRST";
                        break;
                    }
                    case 4: {
                        string2 = "NETWORK_ONLY";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                String policyStr = string2;
                ApolloRequest.Builder builder = request.newBuilder();
                Operation operation = request.getOperation();
                if (operation instanceof Query) {
                    string = "query";
                } else if (operation instanceof Mutation) {
                    string = "mutation";
                } else if (operation instanceof Subscription) {
                    string = "subscription";
                } else {
                    throw new IllegalStateException("Unknown operation type".toString());
                }
                return FlowKt.onEach((Flow)FlowKt.catch((Flow)chain.proceed(builder.addHttpHeader("X-APOLLO-CACHE-OPERATION-TYPE", string).addHttpHeader("X-APOLLO-CACHE-FETCH-POLICY", policyStr).build()), (Function3)((Function3)new Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object>(this.$cacheKey, this.$cachingHttpInterceptor, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Ref.ObjectRef<String> $cacheKey;
                    final /* synthetic */ CachingHttpInterceptor $cachingHttpInterceptor;
                    {
                        this.$cacheKey = $cacheKey;
                        this.$cachingHttpInterceptor = $cachingHttpInterceptor;
                        super(3, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Throwable throwable = (Throwable)this.L$0;
                                String string = (String)this.$cacheKey.element;
                                if (string != null) {
                                    String string2 = string;
                                    CachingHttpInterceptor cachingHttpInterceptor = this.$cachingHttpInterceptor;
                                    String it = string2;
                                    boolean bl = false;
                                    cachingHttpInterceptor.getCache().remove(it);
                                }
                                throw throwable;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super ApolloResponse<D>> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                        Function3<FlowCollector<? super ApolloResponse<D>>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                        function3.L$0 = p2;
                        return function3.invokeSuspend((Object)Unit.INSTANCE);
                    }
                })), (Function2)((Function2)new Function2<ApolloResponse<D>, Continuation<? super Unit>, Object>(this.$cacheKey, this.$cachingHttpInterceptor, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ Ref.ObjectRef<String> $cacheKey;
                    final /* synthetic */ CachingHttpInterceptor $cachingHttpInterceptor;
                    {
                        this.$cacheKey = $cacheKey;
                        this.$cachingHttpInterceptor = $cachingHttpInterceptor;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ApolloResponse response = (ApolloResponse)this.L$0;
                                if (response.hasErrors()) {
                                    String string = (String)this.$cacheKey.element;
                                    if (string != null) {
                                        String string2 = string;
                                        CachingHttpInterceptor cachingHttpInterceptor = this.$cachingHttpInterceptor;
                                        String it = string2;
                                        boolean bl = false;
                                        cachingHttpInterceptor.getCache().remove(it);
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<ApolloResponse<D>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)function2;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ApolloResponse<D> p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
        });
    }

    private static final HttpFetchPolicy defaultPolicy(Operation<?> operation) {
        return operation instanceof Query ? HttpFetchPolicy.CacheFirst : HttpFetchPolicy.NetworkOnly;
    }

    public static final <D extends Operation.Data> boolean isFromHttpCache(@NotNull ApolloResponse<D> $this$isFromHttpCache) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter($this$isFromHttpCache, (String)"<this>");
            Object object = (HttpInfo)$this$isFromHttpCache.executionContext.get((ExecutionContext.Key)HttpInfo.Key);
            if (object != null && (object = object.getHeaders()) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        HttpHeader it = (HttpHeader)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"X-APOLLO-FROM-CACHE")) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public static final <T> T httpFetchPolicy(@NotNull MutableExecutionOptions<T> $this$httpFetchPolicy, @NotNull HttpFetchPolicy httpFetchPolicy) {
        Intrinsics.checkNotNullParameter($this$httpFetchPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)httpFetchPolicy), (String)"httpFetchPolicy");
        return (T)$this$httpFetchPolicy.addExecutionContext((ExecutionContext)new HttpFetchPolicyContext(httpFetchPolicy));
    }

    public static final <T> T httpExpireTimeout(@NotNull MutableExecutionOptions<T> $this$httpExpireTimeout, long httpExpireTimeout) {
        Intrinsics.checkNotNullParameter($this$httpExpireTimeout, (String)"<this>");
        return (T)$this$httpExpireTimeout.addHttpHeader("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(httpExpireTimeout));
    }

    public static final <T> T httpExpireAfterRead(@NotNull MutableExecutionOptions<T> $this$httpExpireAfterRead, boolean httpExpireAfterRead) {
        Intrinsics.checkNotNullParameter($this$httpExpireAfterRead, (String)"<this>");
        return (T)$this$httpExpireAfterRead.addHttpHeader("X-APOLLO-EXPIRE-AFTER-READ", String.valueOf(httpExpireAfterRead));
    }

    public static final <T> T httpDoNotStore(@NotNull MutableExecutionOptions<T> $this$httpDoNotStore, boolean httpDoNotStore) {
        Intrinsics.checkNotNullParameter($this$httpDoNotStore, (String)"<this>");
        return (T)$this$httpDoNotStore.addHttpHeader("X-APOLLO-CACHE-DO-NOT-STORE", String.valueOf(httpDoNotStore));
    }

    @NotNull
    public static final ApolloHttpCache getHttpCache(@NotNull ApolloClient $this$httpCache) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
            NetworkTransport networkTransport = $this$httpCache.getNetworkTransport();
            HttpNetworkTransport httpNetworkTransport = networkTransport instanceof HttpNetworkTransport ? (HttpNetworkTransport)networkTransport : null;
            if (httpNetworkTransport == null) {
                throw new IllegalStateException("cannot get the HttpCache, networkTransport is not a HttpNetworkTransport".toString());
            }
            HttpNetworkTransport httpNetworkTransport2 = httpNetworkTransport;
            Iterable $this$firstOrNull$iv = httpNetworkTransport2.getInterceptors();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpInterceptor it = (HttpInterceptor)element$iv;
                boolean bl = false;
                if (!(it instanceof CachingHttpInterceptor)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        HttpInterceptor httpInterceptor = v1;
        if (httpInterceptor == null) {
            throw new IllegalStateException("no http cache configured".toString());
        }
        HttpInterceptor cachingHttpInterceptor = httpInterceptor;
        return ((CachingHttpInterceptor)cachingHttpInterceptor).getCache();
    }

    public static final /* synthetic */ HttpFetchPolicy access$defaultPolicy(Operation operation) {
        return HttpCache.defaultPolicy(operation);
    }
}

