/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.ApolloHttpCache;
import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R2\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache;", "Lcom/apollographql/apollo3/cache/http/ApolloHttpCache;", "fileSystem", "Lokio/FileSystem;", "directory", "Ljava/io/File;", "maxSize", "", "(Lokio/FileSystem;Ljava/io/File;J)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "", "kotlin.jvm.PlatformType", "cache", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "clearAll", "", "createDiskLruCache", "delete", "read", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "cacheKey", "", "remove", "write", "response", "Companion", "apollo-http-cache"})
public final class DiskLruHttpCache
implements ApolloHttpCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final long maxSize;
    @NotNull
    private DiskLruCache cache;
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    private final JsonAdapter<Object> adapter;
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public DiskLruHttpCache(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cache = this.createDiskLruCache();
        this.cacheLock = new ReentrantReadWriteLock();
        this.adapter = new Moshi.Builder().build().adapter(Object.class);
    }

    private final DiskLruCache createDiskLruCache() {
        return DiskLruCache.Companion.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public HttpResponse read(@NotNull String cacheKey) {
        List list;
        Object it2;
        DiskLruCache.Snapshot snapshot;
        DiskLruCache.Snapshot snapshot2;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            snapshot2 = this.cache.get(cacheKey);
            snapshot = snapshot2;
        }
        finally {
            readLock.unlock();
        }
        if (snapshot == null) {
            throw new IllegalStateException("HTTP cache: no snapshot".toString());
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        Source source = snapshot3.getSource(0);
        Closeable closeable = (Closeable)Okio.buffer((Source)source);
        Throwable throwable = null;
        try {
            it2 = (BufferedSource)closeable;
            boolean bl = false;
            it2 = this.adapter.fromJson(it2);
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        snapshot2 = it2;
        Map map = snapshot2 instanceof Map ? (Map)((Object)snapshot2) : null;
        if (map == null) {
            throw new IllegalStateException("HTTP cache: no map".toString());
        }
        Map map2 = map;
        closeable = map2.get("headers");
        List list2 = closeable instanceof List ? (List)((Object)closeable) : null;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            it2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Map map3 = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)CollectionsKt.single((Iterable)it3.entrySet());
                collection.add(new HttpHeader((String)entry.getKey(), (String)entry.getValue()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List headers = list;
        closeable = map2.get("statusCode");
        String string = closeable instanceof String ? (String)((Object)closeable) : null;
        if (string == null) {
            throw new IllegalStateException("HTTP cache: no statusCode".toString());
        }
        List list3 = headers;
        if (list3 == null) {
            throw new IllegalStateException("HTTP cache: no headers".toString());
        }
        return new HttpResponse.Builder(Integer.parseInt(string)).body(Okio.buffer((Source)snapshot3.getSource(1))).addHeaders(list3).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull HttpResponse response, @NotNull String cacheKey) {
        DiskLruCache.Editor $i$a$-read-DiskLruHttpCache$write$editor$22;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Serializable serializable = this.cacheLock.readLock();
        serializable.lock();
        try {
            boolean $i$a$-read-DiskLruHttpCache$write$editor$22 = false;
            $i$a$-read-DiskLruHttpCache$write$editor$22 = this.cache.edit(cacheKey);
        }
        finally {
            serializable.unlock();
        }
        DiskLruCache.Editor editor = $i$a$-read-DiskLruHttpCache$write$editor$22;
        if (editor == null) {
            return;
        }
        try {
            BufferedSink it2;
            Closeable closeable = (Closeable)Okio.buffer((Sink)editor.newSink(0));
            serializable = null;
            try {
                Collection<Map> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                it2 = (BufferedSink)closeable;
                boolean bl = false;
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"statusCode", (Object)String.valueOf(response.getStatusCode()));
                Iterable iterable = response.getHeaders();
                String string = "headers";
                int n = 1;
                Pair[] pairArray2 = pairArray;
                boolean $i$f$map = false;
                void var14_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void httpHeader;
                    HttpHeader httpHeader2 = (HttpHeader)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)httpHeader.getName(), (Object)httpHeader.getValue())));
                }
                collection = (List)destination$iv$iv;
                pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
                Map map = MapsKt.mapOf((Pair[])pairArray);
                this.adapter.toJson(it2, (Object)map);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                serializable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
            closeable = (Closeable)Okio.buffer((Sink)editor.newSink(1));
            serializable = null;
            try {
                it2 = (BufferedSink)closeable;
                boolean bl = false;
                BufferedSource responseBody = response.getBody();
                if (responseBody != null) {
                    it2.writeAll((Source)responseBody.peek());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
            editor.commit();
        }
        catch (Exception e) {
            editor.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() throws IOException {
        DiskLruCache diskLruCache;
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        DiskLruHttpCache diskLruHttpCache = this;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.cache.delete();
            diskLruCache = this.createDiskLruCache();
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        diskLruHttpCache.cache = diskLruCache;
    }

    @Deprecated(message="Use clearAll() instead", replaceWith=@ReplaceWith(expression="clearAll", imports={}))
    public final void delete() throws IOException {
        this.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.cache.remove(cacheKey);
        }
        finally {
            readLock.unlock();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_HEADERS", "VERSION", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

