/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.ExecutionContext;
import com.apollographql.apollo3.api.MutableExecutionOptions;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.cache.http.CachingHttpInterceptor;
import com.apollographql.apollo3.cache.http.HttpFetchPolicy;
import com.apollographql.apollo3.network.http.HttpInfo;
import com.apollographql.apollo3.network.http.HttpInterceptor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a!\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\f\u001a#\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0010\u001a#\u0010\u0011\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0010\u001a#\u0010\u0012\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0013\u001a#\u0010\u0014\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\u000f2\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016\"%\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0005\u00a8\u0006\u0017"}, d2={"isFromHttpCache", "", "D", "Lcom/apollographql/apollo3/api/Operation$Data;", "Lcom/apollographql/apollo3/api/ApolloResponse;", "(Lcom/apollographql/apollo3/api/ApolloResponse;)Z", "httpCache", "Lcom/apollographql/apollo3/ApolloClient$Builder;", "directory", "Ljava/io/File;", "maxSize", "", "configureApolloClientBuilder", "httpDoNotStore", "T", "Lcom/apollographql/apollo3/api/MutableExecutionOptions;", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;Z)Ljava/lang/Object;", "httpExpireAfterRead", "httpExpireTimeout", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;J)Ljava/lang/Object;", "httpFetchPolicy", "Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;", "(Lcom/apollographql/apollo3/api/MutableExecutionOptions;Lcom/apollographql/apollo3/cache/http/HttpFetchPolicy;)Ljava/lang/Object;", "apollo-http-cache"})
@JvmName(name="HttpCache")
public final class HttpCache {
    @JvmName(name="configureApolloClientBuilder")
    @NotNull
    public static final ApolloClient.Builder configureApolloClientBuilder(@NotNull ApolloClient.Builder $this$httpCache, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)$this$httpCache, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return $this$httpCache.addHttpInterceptor((HttpInterceptor)new CachingHttpInterceptor(directory, maxSize, null, 4, null));
    }

    public static final <D extends Operation.Data> boolean isFromHttpCache(@NotNull ApolloResponse<D> $this$isFromHttpCache) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isFromHttpCache, (String)"<this>");
        HttpInfo httpInfo = (HttpInfo)$this$isFromHttpCache.executionContext.get((ExecutionContext.Key)HttpInfo.Key);
        if (httpInfo == null) {
            bl = false;
        } else {
            List list = httpInfo.getHeaders();
            if (list == null) {
                bl = false;
            } else {
                boolean bl2;
                boolean bl3;
                block7: {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            HttpHeader it = (HttpHeader)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"X-APOLLO-FROM-CACHE")) continue;
                            bl3 = true;
                            break block7;
                        }
                        bl3 = false;
                    }
                }
                bl = bl2 = bl3;
            }
        }
        return bl;
    }

    public static final <T> T httpFetchPolicy(@NotNull MutableExecutionOptions<T> $this$httpFetchPolicy, @NotNull HttpFetchPolicy httpFetchPolicy) {
        String string;
        Intrinsics.checkNotNullParameter($this$httpFetchPolicy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)httpFetchPolicy), (String)"httpFetchPolicy");
        switch (WhenMappings.$EnumSwitchMapping$0[httpFetchPolicy.ordinal()]) {
            case 1: {
                string = "CACHE_FIRST";
                break;
            }
            case 2: {
                string = "CACHE_ONLY";
                break;
            }
            case 3: {
                string = "NETWORK_FIRST";
                break;
            }
            case 4: {
                string = "NETWORK_ONLY";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String policyStr = string;
        return (T)$this$httpFetchPolicy.addHttpHeader("X-APOLLO-CACHE-FETCH-POLICY", policyStr);
    }

    public static final <T> T httpExpireTimeout(@NotNull MutableExecutionOptions<T> $this$httpExpireTimeout, long httpExpireTimeout) {
        Intrinsics.checkNotNullParameter($this$httpExpireTimeout, (String)"<this>");
        return (T)$this$httpExpireTimeout.addHttpHeader("X-APOLLO-EXPIRE-TIMEOUT", String.valueOf(httpExpireTimeout));
    }

    public static final <T> T httpExpireAfterRead(@NotNull MutableExecutionOptions<T> $this$httpExpireAfterRead, boolean httpExpireAfterRead) {
        Intrinsics.checkNotNullParameter($this$httpExpireAfterRead, (String)"<this>");
        return (T)$this$httpExpireAfterRead.addHttpHeader("X-APOLLO-EXPIRE-AFTER-READ", String.valueOf(httpExpireAfterRead));
    }

    public static final <T> T httpDoNotStore(@NotNull MutableExecutionOptions<T> $this$httpDoNotStore, boolean httpDoNotStore) {
        Intrinsics.checkNotNullParameter($this$httpDoNotStore, (String)"<this>");
        return (T)$this$httpDoNotStore.addHttpHeader("X-APOLLO-CACHE-DO-NOT-STORE", String.valueOf(httpDoNotStore));
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpFetchPolicy.values().length];
            nArray[HttpFetchPolicy.CacheFirst.ordinal()] = 1;
            nArray[HttpFetchPolicy.CacheOnly.ordinal()] = 2;
            nArray[HttpFetchPolicy.NetworkFirst.ordinal()] = 3;
            nArray[HttpFetchPolicy.NetworkOnly.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

