/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.http.HttpHeader;
import com.apollographql.apollo3.api.http.HttpResponse;
import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\rH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache;", "", "fileSystem", "Lokio/FileSystem;", "directory", "Ljava/io/File;", "maxSize", "", "(Lokio/FileSystem;Ljava/io/File;J)V", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "kotlin.jvm.PlatformType", "cache", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "createDiskLruCache", "delete", "", "read", "Lcom/apollographql/apollo3/api/http/HttpResponse;", "cacheKey", "", "remove", "write", "response", "Companion", "apollo-http-cache"})
public final class DiskLruHttpCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final File directory;
    private final long maxSize;
    @NotNull
    private DiskLruCache cache;
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    private final JsonAdapter<Object> adapter;
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    public DiskLruHttpCache(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cache = this.createDiskLruCache();
        this.cacheLock = new ReentrantReadWriteLock();
        this.adapter = new Moshi.Builder().build().adapter(Object.class);
    }

    private final DiskLruCache createDiskLruCache() {
        return DiskLruCache.Companion.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final HttpResponse read(@NotNull String cacheKey) {
        List list;
        Object it2;
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Object object = this.cacheLock.readLock();
        ((ReentrantReadWriteLock.ReadLock)object).lock();
        try {
            boolean bl = false;
            snapshot = this.cache.get(cacheKey);
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)object).unlock();
        }
        DiskLruCache.Snapshot snapshot2 = snapshot;
        if (snapshot2 == null) {
            throw new IllegalStateException("HTTP cache: no snapshot".toString());
        }
        DiskLruCache.Snapshot snapshot3 = snapshot2;
        Source source = snapshot3.getSource(0);
        Object object2 = (Closeable)Okio.buffer((Source)source);
        Throwable throwable = null;
        try {
            it2 = (BufferedSource)object2;
            boolean bl = false;
            it2 = this.adapter.fromJson(it2);
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        snapshot = it2;
        Object object3 = object = snapshot instanceof Map ? (Map)((Object)snapshot) : null;
        if (object == null) {
            throw new IllegalStateException("HTTP cache: no map".toString());
        }
        Object map = object;
        object2 = map.get("headers");
        List list2 = object2 instanceof List ? (List)object2 : null;
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            it2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                Map map2 = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)CollectionsKt.single((Iterable)it3.entrySet());
                collection.add(new HttpHeader((String)entry.getKey(), (String)entry.getValue()));
            }
            list = (List)destination$iv$iv;
        }
        List headers = list;
        Object v = map.get("statusCode");
        object2 = v instanceof String ? (String)v : null;
        Integer n = object2 == null ? null : Integer.valueOf(Integer.parseInt((String)object2));
        if (n == null) {
            throw new IllegalStateException("HTTP cache: no statusCode".toString());
        }
        List list3 = headers;
        if (list3 == null) {
            throw new IllegalStateException("HTTP cache: no headers".toString());
        }
        return new HttpResponse.Builder(n.intValue()).body(Okio.buffer((Source)snapshot3.getSource(1))).addHeaders(list3).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(@NotNull HttpResponse response, @NotNull String cacheKey) {
        DiskLruCache.Editor $i$a$-read-DiskLruHttpCache$write$editor$22;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        Serializable serializable = this.cacheLock.readLock();
        serializable.lock();
        try {
            boolean $i$a$-read-DiskLruHttpCache$write$editor$22 = false;
            $i$a$-read-DiskLruHttpCache$write$editor$22 = this.cache.edit(cacheKey);
        }
        finally {
            serializable.unlock();
        }
        DiskLruCache.Editor editor = $i$a$-read-DiskLruHttpCache$write$editor$22;
        if (editor == null) {
            return;
        }
        try {
            BufferedSink it2;
            Closeable closeable = (Closeable)Okio.buffer((Sink)editor.newSink(0));
            serializable = null;
            try {
                Collection<Map> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                it2 = (BufferedSink)closeable;
                boolean bl = false;
                Pair[] pairArray = new Pair[2];
                pairArray[0] = TuplesKt.to((Object)"statusCode", (Object)String.valueOf(response.getStatusCode()));
                Iterable iterable = response.getHeaders();
                String string = "headers";
                int n = 1;
                Pair[] pairArray2 = pairArray;
                boolean $i$f$map = false;
                void var14_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void httpHeader;
                    HttpHeader httpHeader2 = (HttpHeader)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)httpHeader.getName(), (Object)httpHeader.getValue())));
                }
                collection = (List)destination$iv$iv;
                pairArray2[n] = TuplesKt.to((Object)string, (Object)collection);
                Map map = MapsKt.mapOf((Pair[])pairArray);
                this.adapter.toJson(it2, (Object)map);
                it2 = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                serializable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
            closeable = (Closeable)Okio.buffer((Sink)editor.newSink(1));
            serializable = null;
            try {
                it2 = (BufferedSink)closeable;
                boolean bl = false;
                BufferedSource responseBody = response.getBody();
                if (responseBody != null) {
                    it2.writeAll((Source)responseBody.peek());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
            }
            editor.commit();
        }
        catch (Exception e) {
            editor.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws IOException {
        DiskLruCache diskLruCache;
        ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
        DiskLruHttpCache diskLruHttpCache = this;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.cache.delete();
            diskLruCache = this.createDiskLruCache();
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        diskLruHttpCache.cache = diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.cache.remove(cacheKey);
        }
        finally {
            readLock.unlock();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_HEADERS", "VERSION", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

