/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import com.apollographql.apollo3.api.cache.http.HttpCacheRecord;
import com.apollographql.apollo3.api.cache.http.HttpCacheRecordEditor;
import com.apollographql.apollo3.api.cache.http.HttpCacheStore;
import com.apollographql.apollo3.cache.http.internal.DiskLruCache;
import com.apollographql.apollo3.cache.http.internal.FileSystem;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCacheStore;", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheStore;", "directory", "Ljava/io/File;", "maxSize", "", "(Ljava/io/File;J)V", "fileSystem", "Lcom/apollographql/apollo3/cache/http/internal/FileSystem;", "(Lcom/apollographql/apollo3/cache/http/internal/FileSystem;Ljava/io/File;J)V", "cache", "Lcom/apollographql/apollo3/cache/http/internal/DiskLruCache;", "cacheLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "cacheRecord", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecord;", "cacheKey", "", "cacheRecordEditor", "Lcom/apollographql/apollo3/api/cache/http/HttpCacheRecordEditor;", "createDiskLruCache", "delete", "", "remove", "Companion", "apollo-http-cache"})
public final class DiskLruHttpCacheStore
implements HttpCacheStore {
    private DiskLruCache cache;
    private final ReadWriteLock cacheLock;
    private final FileSystem fileSystem;
    private final File directory;
    private final long maxSize;
    private static final int VERSION = 99991;
    private static final int ENTRY_HEADERS = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HttpCacheRecord cacheRecord(@NotNull String cacheKey) throws IOException {
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        DiskLruCache.Snapshot snapshot2 = null;
        this.cacheLock.readLock().lock();
        try {
            snapshot = this.cache.get(cacheKey);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        snapshot2 = snapshot;
        return snapshot2 == null ? null : (HttpCacheRecord)new HttpCacheRecord(snapshot2){
            final /* synthetic */ DiskLruCache.Snapshot $snapshot;

            @NotNull
            public Source headerSource() {
                return this.$snapshot.getSource(0);
            }

            @NotNull
            public Source bodySource() {
                return this.$snapshot.getSource(1);
            }

            public void close() {
                this.$snapshot.close();
            }
            {
                this.$snapshot = $captured_local_variable$0;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public HttpCacheRecordEditor cacheRecordEditor(@NotNull String cacheKey) throws IOException {
        DiskLruCache.Editor editor;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        DiskLruCache.Editor editor2 = null;
        this.cacheLock.readLock().lock();
        try {
            editor = this.cache.edit(cacheKey);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        editor2 = editor;
        return editor2 == null ? null : (HttpCacheRecordEditor)new HttpCacheRecordEditor(editor2){
            final /* synthetic */ DiskLruCache.Editor $editor;

            @NotNull
            public Sink headerSink() {
                return this.$editor.newSink(0);
            }

            @NotNull
            public Sink bodySink() {
                return this.$editor.newSink(1);
            }

            public void abort() throws IOException {
                this.$editor.abort();
            }

            public void commit() throws IOException {
                this.$editor.commit();
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        DiskLruCache diskLruCache;
        this.cacheLock.writeLock().lock();
        DiskLruHttpCacheStore diskLruHttpCacheStore = this;
        try {
            DiskLruHttpCacheStore diskLruHttpCacheStore2 = diskLruHttpCacheStore;
            this.cache.delete();
            diskLruCache = this.createDiskLruCache();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        diskLruHttpCacheStore2.cache = diskLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull String cacheKey) throws IOException {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        this.cacheLock.readLock().lock();
        try {
            this.cache.remove(cacheKey);
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    private final DiskLruCache createDiskLruCache() {
        return DiskLruCache.Companion.create(this.fileSystem, this.directory, 99991, 2, this.maxSize);
    }

    public DiskLruHttpCacheStore(@NotNull FileSystem fileSystem, @NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.fileSystem = fileSystem;
        this.directory = directory;
        this.maxSize = maxSize;
        this.cacheLock = new ReentrantReadWriteLock();
        this.cache = this.createDiskLruCache();
    }

    public DiskLruHttpCacheStore(@NotNull File directory, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(FileSystem.SYSTEM, directory, maxSize);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/cache/http/DiskLruHttpCacheStore$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_HEADERS", "VERSION", "apollo-http-cache"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

