/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.cache.http;

import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

final class CacheResponseBody
extends ResponseBody {
    private BufferedSource responseBodySource;
    private final String contentType;
    private final String contentLength;

    CacheResponseBody(Source responseBodySource, String contentType, String contentLength) {
        this.responseBodySource = Okio.buffer((Source)responseBodySource);
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    public MediaType contentType() {
        return this.contentType != null ? MediaType.parse((String)this.contentType) : null;
    }

    public long contentLength() {
        try {
            return this.contentLength != null ? Long.parseLong(this.contentLength) : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public BufferedSource source() {
        return this.responseBodySource;
    }
}

