/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.api.cache.http;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy;", "", "()V", "CACHE_FIRST", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$ExpirePolicy;", "CACHE_ONLY", "NETWORK_FIRST", "NETWORK_ONLY", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "ExpirePolicy", "FetchStrategy", "Policy", "apollo-http-cache-api"})
public final class HttpCachePolicy {
    @JvmField
    @NotNull
    public static final ExpirePolicy CACHE_ONLY;
    @JvmField
    @NotNull
    public static final Policy NETWORK_ONLY;
    @JvmField
    @NotNull
    public static final ExpirePolicy CACHE_FIRST;
    @JvmField
    @NotNull
    public static final ExpirePolicy NETWORK_FIRST;
    @NotNull
    public static final HttpCachePolicy INSTANCE;

    private HttpCachePolicy() {
    }

    static {
        HttpCachePolicy httpCachePolicy;
        INSTANCE = httpCachePolicy = new HttpCachePolicy();
        CACHE_ONLY = new ExpirePolicy(FetchStrategy.CACHE_ONLY);
        NETWORK_ONLY = new Policy(FetchStrategy.NETWORK_ONLY, 0L, null, false);
        CACHE_FIRST = new ExpirePolicy(FetchStrategy.CACHE_FIRST);
        NETWORK_FIRST = new ExpirePolicy(FetchStrategy.NETWORK_FIRST);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\u0005R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "", "fetchStrategy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;", "expireTimeout", "", "expireTimeUnit", "Ljava/util/concurrent/TimeUnit;", "expireAfterRead", "", "(Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;JLjava/util/concurrent/TimeUnit;Z)V", "expireTimeoutMs", "apollo-http-cache-api"})
    public static class Policy {
        @JvmField
        @NotNull
        public final FetchStrategy fetchStrategy;
        @JvmField
        public final long expireTimeout;
        @JvmField
        @Nullable
        public final TimeUnit expireTimeUnit;
        @JvmField
        public final boolean expireAfterRead;

        public final long expireTimeoutMs() {
            TimeUnit timeUnit = this.expireTimeUnit;
            return timeUnit != null ? timeUnit.toMillis(this.expireTimeout) : 0L;
        }

        public Policy(@NotNull FetchStrategy fetchStrategy, long expireTimeout, @Nullable TimeUnit expireTimeUnit, boolean expireAfterRead) {
            Intrinsics.checkNotNullParameter((Object)((Object)fetchStrategy), (String)"fetchStrategy");
            this.fetchStrategy = fetchStrategy;
            this.expireTimeout = expireTimeout;
            this.expireTimeUnit = expireTimeUnit;
            this.expireAfterRead = expireAfterRead;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0000\u00a8\u0006\r"}, d2={"Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$ExpirePolicy;", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$Policy;", "fetchStrategy", "Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;", "(Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;)V", "expireTimeout", "", "expireTimeUnit", "Ljava/util/concurrent/TimeUnit;", "expireAfterRead", "", "(Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;JLjava/util/concurrent/TimeUnit;Z)V", "expireAfter", "apollo-http-cache-api"})
    public static final class ExpirePolicy
    extends Policy {
        @NotNull
        public final ExpirePolicy expireAfter(long expireTimeout, @NotNull TimeUnit expireTimeUnit) {
            Intrinsics.checkNotNullParameter((Object)((Object)expireTimeUnit), (String)"expireTimeUnit");
            return new ExpirePolicy(this.fetchStrategy, expireTimeout, expireTimeUnit, this.expireAfterRead);
        }

        @NotNull
        public final ExpirePolicy expireAfterRead() {
            return new ExpirePolicy(this.fetchStrategy, this.expireTimeout, this.expireTimeUnit, true);
        }

        public ExpirePolicy(@NotNull FetchStrategy fetchStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)fetchStrategy), (String)"fetchStrategy");
            super(fetchStrategy, 0L, null, false);
        }

        private ExpirePolicy(FetchStrategy fetchStrategy, long expireTimeout, TimeUnit expireTimeUnit, boolean expireAfterRead) {
            super(fetchStrategy, expireTimeout, expireTimeUnit, expireAfterRead);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/apollographql/apollo3/api/cache/http/HttpCachePolicy$FetchStrategy;", "", "(Ljava/lang/String;I)V", "CACHE_ONLY", "NETWORK_ONLY", "CACHE_FIRST", "NETWORK_FIRST", "apollo-http-cache-api"})
    public static final class FetchStrategy
    extends Enum<FetchStrategy> {
        public static final /* enum */ FetchStrategy CACHE_ONLY;
        public static final /* enum */ FetchStrategy NETWORK_ONLY;
        public static final /* enum */ FetchStrategy CACHE_FIRST;
        public static final /* enum */ FetchStrategy NETWORK_FIRST;
        private static final /* synthetic */ FetchStrategy[] $VALUES;

        static {
            FetchStrategy[] fetchStrategyArray = new FetchStrategy[4];
            FetchStrategy[] fetchStrategyArray2 = fetchStrategyArray;
            fetchStrategyArray[0] = CACHE_ONLY = new FetchStrategy();
            fetchStrategyArray[1] = NETWORK_ONLY = new FetchStrategy();
            fetchStrategyArray[2] = CACHE_FIRST = new FetchStrategy();
            fetchStrategyArray[3] = NETWORK_FIRST = new FetchStrategy();
            $VALUES = fetchStrategyArray;
        }

        public static FetchStrategy[] values() {
            return (FetchStrategy[])$VALUES.clone();
        }

        public static FetchStrategy valueOf(String string) {
            return Enum.valueOf(FetchStrategy.class, string);
        }
    }
}

