/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.tls;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.apollo3.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    public final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        Intrinsics.checkNotNullParameter(trustRootIndex, "trustRootIndex");
        this.trustRootIndex = trustRootIndex;
    }

    @Override
    public final List clean(String object, List arrayList) {
        ArrayList arrayList2;
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter(arrayList, "chain");
        Intrinsics.checkNotNullParameter(object, "hostname");
        object = arrayDeque;
        arrayDeque = new ArrayDeque(arrayList);
        arrayList = arrayList2;
        arrayList();
        Object e = ((ArrayDeque)object).removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, "queue.removeFirst()");
        arrayList2.add(e);
        boolean bl = false;
        int n = 0;
        block4: while (n < 9) {
            ArrayList<Object> arrayList3 = arrayList;
            ++n;
            X509Certificate x509Certificate = (X509Certificate)arrayList3.get(arrayList3.size() - 1);
            Object object2 = this.trustRootIndex.findByIssuerAndSignature(x509Certificate);
            if (object2 != null) {
                if (arrayList.size() > 1 || !Intrinsics.areEqual(x509Certificate, object2)) {
                    arrayList.add(object2);
                }
                if (Intrinsics.areEqual(((X509Certificate)object2).getIssuerDN(), ((X509Certificate)object2).getSubjectDN())) {
                    try {
                        Object object3 = object2;
                        ((Certificate)object3).verify(((Certificate)object3).getPublicKey());
                        bl = true;
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                }
                bl = false;
                if (bl) {
                    return arrayList;
                }
                bl = true;
                continue;
            }
            object2 = ((ArrayDeque)object).iterator();
            Intrinsics.checkNotNullExpressionValue(object2, "queue.iterator()");
            while (object2.hasNext()) {
                Object object4 = object2.next();
                if (object4 != null) {
                    boolean bl2;
                    object4 = (X509Certificate)object4;
                    if (Intrinsics.areEqual(x509Certificate.getIssuerDN(), ((X509Certificate)object4).getSubjectDN())) {
                        try {
                            x509Certificate.verify(((Certificate)object4).getPublicKey());
                            bl2 = true;
                        }
                        catch (GeneralSecurityException generalSecurityException) {}
                    }
                    bl2 = false;
                    if (!bl2) continue;
                    object2.remove();
                    arrayList.add(object4);
                    continue block4;
                }
                throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
            }
            if (bl) {
                return arrayList;
            }
            throw new SSLPeerUnverifiedException(Intrinsics.stringPlus(x509Certificate, "Failed to find a trusted cert that signed "));
        }
        throw new SSLPeerUnverifiedException(Intrinsics.stringPlus(arrayList, "Certificate chain too long: "));
    }

    public final int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicCertificateChainCleaner)) return false;
        if (!Intrinsics.areEqual(((BasicCertificateChainCleaner)object).trustRootIndex, this.trustRootIndex)) return false;
        return true;
    }
}

