/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringsJVMKt;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okio.ByteString;
import com.apollographql.apollo3.relocated.okio._JvmPlatformKt;

public abstract class Http2 {
    public static final ByteString CONNECTION_PREFACE;
    public static final String[] FRAME_NAMES;
    public static final String[] FLAGS;
    public static final String[] BINARY;

    static {
        Object[] objectArray;
        new ByteString(_JvmPlatformKt.asUtf8ToByteArray("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n")).utf8 = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";
        CONNECTION_PREFACE = new ByteString(_JvmPlatformKt.asUtf8ToByteArray("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n"));
        FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FLAGS = new String[64];
        String[] stringArray = new String[256];
        for (int i = 0; i < 256; ++i) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            String string = Integer.toBinaryString(i);
            Intrinsics.checkNotNullExpressionValue(string, "toBinaryString(it)");
            objectArray2[0] = string;
            Intrinsics.checkNotNullExpressionValue(Util.format("%8s", objectArray).replace(' ', '0'), "replace(...)");
        }
        BINARY = stringArray;
        String[] stringArray2 = FLAGS;
        stringArray2[0] = "";
        stringArray2[1] = "END_STREAM";
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        stringArray2[8] = "PADDED";
        stringArray2[9] = Intrinsics.stringPlus("|PADDED", "END_STREAM");
        stringArray2[4] = "END_HEADERS";
        stringArray2[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        int n = 3;
        int[] nArray3 = new int[3];
        objectArray = nArray3;
        nArray3[0] = 4;
        nArray3[1] = 32;
        nArray3[2] = 36;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            Object object = objectArray[i];
            int n2 = nArray2[0];
            String[] stringArray3 = FLAGS;
            int n3 = n2 | object;
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3();
            stringArray3[n3] = stringBuilder2.append((Object)stringArray3[n2]).append('|').append((Object)stringArray3[object]).toString();
            stringBuilder3 = stringBuilder;
            stringBuilder3();
            FLAGS[n3 | 8] = stringBuilder.append((Object)stringArray3[n2]).append('|').append((Object)stringArray3[object]).append("|PADDED").toString();
        }
        int n4 = 0;
        n = FLAGS.length;
        while (n4 < n) {
            int n5 = n4 + 1;
            String[] stringArray4 = FLAGS;
            if (FLAGS[n4] == null) {
                stringArray4[n4] = BINARY[n4];
            }
            n4 = n5;
        }
    }

    public static String frameLog(int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        Object object2;
        block7: {
            Object object3;
            block8: {
                block6: {
                    object2 = FRAME_NAMES;
                    if (n3 < FRAME_NAMES.length) {
                        object2 = object2[n3];
                    } else {
                        Object[] objectArray = new Object[1];
                        object2 = objectArray;
                        objectArray[0] = n3;
                        object2 = Util.format("0x%02x", object2);
                    }
                    if (n4 != 0) break block6;
                    object = "";
                    break block7;
                }
                switch (n3) {
                    default: {
                        object3 = FLAGS;
                        if (n4 >= FLAGS.length) break;
                        object3 = object3[n4];
                        Intrinsics.checkNotNull(object3);
                        break block8;
                    }
                    case 4: 
                    case 6: {
                        object = n4 == 1 ? "ACK" : BINARY[n4];
                        break block7;
                    }
                    case 2: 
                    case 3: 
                    case 7: 
                    case 8: {
                        object = BINARY[n4];
                        break block7;
                    }
                }
                object3 = BINARY[n4];
            }
            object = n3 == 5 && (n4 & 4) != 0 ? StringsKt__StringsJVMKt.replace$default((String)object3, "HEADERS", "PUSH_PROMISE") : (n3 == 0 && (n4 & 0x20) != 0 ? StringsKt__StringsJVMKt.replace$default((String)object3, "PRIORITY", "COMPRESSED") : object3);
        }
        String string = bl ? "<<" : ">>";
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string;
        objectArray2[1] = n;
        objectArray[2] = n2;
        objectArray[3] = object2;
        objectArray[4] = object;
        return Util.format("%s 0x%08x %5d %-13s %s", objectArray2);
    }
}

