/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.gradle.internal;

import com.apollographql.apollo3.compiler.ApolloCompiler;
import com.apollographql.apollo3.compiler.CodegenSchema;
import com.apollographql.apollo3.compiler.FileUtils;
import com.apollographql.apollo3.gradle.internal.TaskExtensionsKt;
import com.apollographql.apollo3.gradle.internal.UtilsKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo3/gradle/internal/ApolloGenerateCodegenSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "codegenSchemaFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCodegenSchemaFile", "()Lorg/gradle/api/file/RegularFileProperty;", "codegenSchemaOptionsFile", "getCodegenSchemaOptionsFile", "fallbackSchemaFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getFallbackSchemaFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "schemaFiles", "getSchemaFiles", "upstreamSchemaFiles", "getUpstreamSchemaFiles", "taskAction", "", "apollo-gradle-plugin-external"})
public abstract class ApolloGenerateCodegenSchemaTask
extends DefaultTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getFallbackSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getUpstreamSchemaFiles();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getCodegenSchemaOptionsFile();

    @OutputFile
    @Optional
    public abstract RegularFileProperty getCodegenSchemaFile();

    @TaskAction
    public final void taskAction() {
        Set set = this.getUpstreamSchemaFiles().getFiles();
        Intrinsics.checkNotNullExpressionValue(set, "getFiles(...)");
        if (set.isEmpty() ^ true) {
            File file = ((RegularFile)this.getCodegenSchemaFile().get()).getAsFile();
            file.delete();
            file.createNewFile();
            return;
        }
        Object object = this.getSchemaFiles();
        Set set2 = object.getFiles();
        Intrinsics.checkNotNullExpressionValue(set2, "getFiles(...)");
        if (!(set2.isEmpty() ^ true)) {
            object = null;
        }
        if (object == null) {
            object = this.getFallbackSchemaFiles();
        }
        object = TaskExtensionsKt.logger();
        File file = ((RegularFile)this.getCodegenSchemaOptionsFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue(file, "getAsFile(...)");
        CodegenSchema codegenSchema = ApolloCompiler.INSTANCE.buildCodegenSchema(UtilsKt.toInputFiles((FileCollection)object), (ApolloCompiler.Logger)object, FileUtils.readCodegenSchemaOptions(file));
        File file2 = ((RegularFile)this.getCodegenSchemaFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue(file2, "getAsFile(...)");
        FileUtils.writeCodegenSchema(codegenSchema, file2);
    }
}

