/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okio;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okio.-SegmentedByteString;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.BufferedSink;
import com.apollographql.apollo3.relocated.okio.Okio;
import com.apollographql.apollo3.relocated.okio.RealBufferedSink;
import com.apollographql.apollo3.relocated.okio.Segment;
import com.apollographql.apollo3.relocated.okio.SegmentPool;
import com.apollographql.apollo3.relocated.okio.Sink;
import com.apollographql.apollo3.relocated.okio.Timeout;
import java.util.zip.Deflater;

public final class DeflaterSink
implements Sink {
    public final BufferedSink sink;
    public final Deflater deflater;
    public boolean closed;

    public DeflaterSink(RealBufferedSink realBufferedSink, Deflater deflater) {
        this.sink = realBufferedSink;
        this.deflater = deflater;
    }

    public DeflaterSink(Buffer buffer, Deflater deflater) {
        this(Okio.buffer(buffer), deflater);
    }

    @Override
    public final void write(Buffer buffer, long l) {
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullParameter(buffer2, "source");
        -SegmentedByteString.checkOffsetAndCount(buffer2.size, 0L, l);
        while (l > 0L) {
            DeflaterSink deflaterSink = this;
            Segment segment = buffer.head;
            Intrinsics.checkNotNull(segment);
            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
            Segment segment2 = segment;
            byte[] byArray = segment2.data;
            deflaterSink.deflater.setInput(byArray, segment2.pos, n);
            deflaterSink.deflate(false);
            long l2 = n;
            buffer.size -= l2;
            segment.pos = n = segment.pos + n;
            if (n == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            l -= l2;
        }
    }

    @Override
    public final void flush() {
        DeflaterSink deflaterSink = this;
        deflaterSink.deflate(true);
        deflaterSink.sink.flush();
    }

    @Override
    public final void close() {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                DeflaterSink deflaterSink = this;
                throwable = null;
                try {
                    deflaterSink.deflater.finish();
                    deflaterSink.deflate(false);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable == null) {
            return;
        }
        throw throwable;
    }

    @Override
    public final Timeout timeout() {
        return this.sink.timeout();
    }

    public final String toString() {
        return "DeflaterSink(" + this.sink + ')';
    }

    public final void deflate(boolean bl) {
        Segment segment;
        Buffer buffer = this.sink.getBuffer();
        while (true) {
            int n;
            int n2;
            segment = buffer.writableSegment$okio(1);
            if (bl) {
                Segment segment2 = segment;
                byte[] byArray = segment2.data;
                n2 = segment2.limit;
                n = this.deflater.deflate(byArray, n2, 8192 - n2, 2);
            } else {
                Segment segment3 = segment;
                byte[] byArray = segment3.data;
                n2 = segment3.limit;
                n = this.deflater.deflate(byArray, n2, 8192 - n2);
            }
            if (n > 0) {
                segment.limit += n;
                buffer.size += (long)n;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (segment.pos == segment.limit) {
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }
}

