/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.org.objectweb.asm;

public final class Type {
    public static final Type VOID_TYPE = new Type(0, 0, 1, "VZCBSIFJD");
    public static final Type BOOLEAN_TYPE = new Type(1, 1, 2, "VZCBSIFJD");
    public static final Type CHAR_TYPE = new Type(2, 2, 3, "VZCBSIFJD");
    public static final Type BYTE_TYPE = new Type(3, 3, 4, "VZCBSIFJD");
    public static final Type SHORT_TYPE = new Type(4, 4, 5, "VZCBSIFJD");
    public static final Type INT_TYPE = new Type(5, 5, 6, "VZCBSIFJD");
    public static final Type FLOAT_TYPE = new Type(6, 6, 7, "VZCBSIFJD");
    public static final Type LONG_TYPE = new Type(7, 7, 8, "VZCBSIFJD");
    public static final Type DOUBLE_TYPE = new Type(8, 8, 9, "VZCBSIFJD");
    public final int sort;
    public final String valueBuffer;
    public final int valueBegin;
    public final int valueEnd;

    public final String getDescriptor() {
        int n = this.sort;
        if (n == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (n == 12) {
            Type type = this;
            int n2 = type.valueBegin;
            return "L" + this.valueBuffer.substring(n2, type.valueEnd) + ';';
        }
        Type type = this;
        int n3 = type.valueBegin;
        return this.valueBuffer.substring(n3, type.valueEnd);
    }

    public final boolean equals(Object object) {
        int n;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Type)) {
            return false;
        }
        object = (Type)object;
        int n2 = this.sort;
        if (n2 == 12) {
            n2 = 10;
        }
        if ((n = ((Type)object).sort) == 12) {
            n = 10;
        }
        if (n2 != n) {
            return false;
        }
        Type type = this;
        n2 = type.valueBegin;
        n = type.valueEnd;
        Object object2 = object;
        int n3 = ((Type)object2).valueEnd;
        int n4 = ((Type)object2).valueBegin;
        if (n - n2 != n3 - n4) {
            return false;
        }
        while (n2 < n) {
            if (this.valueBuffer.charAt(n2) != ((Type)object).valueBuffer.charAt(n4)) {
                return false;
            }
            ++n2;
            ++n4;
        }
        return true;
    }

    public final int hashCode() {
        int n = 13;
        int n2 = this.sort;
        int n3 = n2 == 12 ? 10 : n2;
        n = n3 * n;
        if (n2 >= 9) {
            n3 = this.valueEnd;
            for (n2 = (v840796).valueBegin; n2 < n3; ++n2) {
                n = (this.valueBuffer.charAt(n2) + n) * 17;
            }
        }
        return n;
    }

    public final String toString() {
        return this.getDescriptor();
    }

    public static Type[] getArgumentTypes(String string) {
        int n = 0;
        int n2 = 1;
        while (string.charAt(n2) != ')') {
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            if (string.charAt(n2++) == 'L') {
                n2 = Math.max(n2, string.indexOf(59, n2) + 1);
            }
            ++n;
        }
        Type[] typeArray = new Type[n];
        n2 = 1;
        int n3 = 0;
        while (string.charAt(n2) != ')') {
            int n4 = n2;
            while (string.charAt(n4) == '[') {
                ++n4;
            }
            if (string.charAt(n4++) == 'L') {
                n4 = Math.max(n4, string.indexOf(59, n4) + 1);
            }
            int n5 = n2;
            n2 = n3 + 1;
            typeArray[n3] = Type.getTypeInternal(n5, n4, string);
            n3 = n2;
            n2 = n4;
        }
        return typeArray;
    }

    public static int getArgumentsAndReturnSizes(String string) {
        int n = 1;
        int n2 = 1;
        char c = string.charAt(1);
        while (c != ')') {
            if (c != 'J' && c != 'D') {
                while (string.charAt(n2) == '[') {
                    ++n2;
                }
                if (string.charAt(n2++) == 'L') {
                    n2 = Math.max(n2, string.indexOf(59, n2) + 1);
                }
                ++n;
            } else {
                ++n2;
                n += 2;
            }
            c = string.charAt(n2);
        }
        int n3 = string.charAt(n2 + 1);
        if (n3 == 86) {
            return n << 2;
        }
        n3 = n3 != 74 && n3 != 68 ? 1 : 2;
        return n << 2 | n3;
    }

    public Type(int n, int n2, int n3, String string) {
        this.sort = n;
        this.valueBuffer = string;
        this.valueBegin = n2;
        this.valueEnd = n3;
    }

    public static Type getTypeInternal(int n, int n2, String string) {
        switch (string.charAt(n)) {
            default: {
                throw new IllegalArgumentException("Invalid descriptor: ".concat(string));
            }
            case '[': {
                return new Type(9, n, n2, string);
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'V': {
                return VOID_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'L': {
                return new Type(10, ++n, --n2, string);
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case '(': 
        }
        return new Type(11, n, n2, string);
    }
}

