/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.concurrent;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.Task;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskQueue;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskRunner$Backend;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskRunner$RealBackend;
import com.apollographql.apollo3.relocated.okhttp3.internal.concurrent.TaskRunner$runnable$1;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public final class TaskRunner {
    public static final TaskRunner INSTANCE = new TaskRunner(new TaskRunner$RealBackend(Util.threadFactory(Intrinsics.stringPlus(" TaskRunner", Util.okHttpName), true)));
    public static final Logger logger;
    public final TaskRunner$Backend backend;
    public int nextQueueName;
    public boolean coordinatorWaiting;
    public long coordinatorWakeUpAt;
    public final ArrayList busyQueues;
    public final ArrayList readyQueues;
    public final TaskRunner$runnable$1 runnable;

    public TaskRunner(TaskRunner$RealBackend object) {
        TaskRunner$runnable$1 taskRunner$runnable$1;
        ArrayList arrayList;
        ArrayList arrayList2;
        this.backend = object;
        this.nextQueueName = 10000;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.busyQueues = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.readyQueues = object;
        object = taskRunner$runnable$1;
        taskRunner$runnable$1 = new TaskRunner$runnable$1(this);
        this.runnable = object;
    }

    public static final /* synthetic */ void access$runTask(TaskRunner taskRunner, Task task) {
        taskRunner.runTask(task);
    }

    static {
        Logger logger2 = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(TaskRunner::class.java.name)");
        logger = logger2;
    }

    public final TaskRunner$Backend getBackend() {
        return this.backend;
    }

    public final void kickCoordinator$okhttp(TaskQueue taskQueue) {
        Intrinsics.checkNotNullParameter(taskQueue, "taskQueue");
        if (Util.assertionsEnabled && !Thread.holdsLock(taskRunner$Backend)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + taskRunner$Backend));
        }
        if (taskQueue.activeTask == null) {
            if (taskQueue.futureTasks.isEmpty() ^ true) {
                ArrayList arrayList = ((TaskRunner)((Object)taskRunner$Backend)).readyQueues;
                Intrinsics.checkNotNullParameter(arrayList, "<this>");
                if (!arrayList.contains(taskQueue)) {
                    arrayList.add(taskQueue);
                }
            } else {
                ((TaskRunner)((Object)taskRunner$Backend)).readyQueues.remove(taskQueue);
            }
        }
        if (((TaskRunner)((Object)taskRunner$Backend)).coordinatorWaiting) {
            TaskRunner taskRunner = taskRunner$Backend;
            ((TaskRunner$RealBackend)taskRunner.backend).getClass();
            taskRunner.notify();
        } else {
            TaskRunner taskRunner = taskRunner$Backend;
            TaskRunner$Backend taskRunner$Backend = taskRunner.backend;
            ((TaskRunner$RealBackend)taskRunner$Backend).execute(taskRunner.runnable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Task awaitTaskToRun() {
        Throwable throwable2222222;
        if (Util.assertionsEnabled && !Thread.holdsLock(taskRunner$runnable$1)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + taskRunner$runnable$1));
        }
        while (true) {
            block17: {
                long l;
                if (((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.isEmpty()) {
                    return null;
                }
                ((TaskRunner$RealBackend)((TaskRunner)((Object)taskRunner$runnable$1)).backend).getClass();
                long l2 = System.nanoTime();
                long l3 = Long.MAX_VALUE;
                Task task = null;
                boolean bl = false;
                Iterator iterator2 = ((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.iterator();
                while (iterator2.hasNext()) {
                    Task task2 = (Task)((TaskQueue)iterator2.next()).futureTasks.get(0);
                    long l4 = task2.nextExecuteNanoTime - l2;
                    if ((l4 = Math.max(0L, l4)) > 0L) {
                        l3 = Math.min(l4, l3);
                        continue;
                    }
                    if (task != null) {
                        bl = true;
                        break;
                    }
                    task = task2;
                }
                if (task != null) {
                    TaskQueue taskQueue;
                    if (Util.assertionsEnabled && !Thread.holdsLock(taskRunner$runnable$1)) {
                        throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + taskRunner$runnable$1));
                    }
                    task.nextExecuteNanoTime = -1L;
                    TaskQueue taskQueue2 = taskQueue = task.queue;
                    Intrinsics.checkNotNull(taskQueue2);
                    taskQueue2.futureTasks.remove(task);
                    ((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.remove(taskQueue);
                    task.queue.activeTask = task;
                    ((TaskRunner)((Object)taskRunner$runnable$1)).busyQueues.add(taskQueue);
                    if (bl || !((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting && ((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.isEmpty() ^ true) {
                        TaskRunner$runnable$1 taskRunner$runnable$1 = ((TaskRunner)((Object)taskRunner$runnable$1)).runnable;
                        ((TaskRunner$RealBackend)((TaskRunner)((Object)taskRunner$runnable$1)).backend).execute(taskRunner$runnable$1);
                    }
                    return task;
                }
                if (((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting) {
                    if (l3 < ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWakeUpAt - l2) {
                        ((TaskRunner$RealBackend)((TaskRunner)((Object)taskRunner$runnable$1)).backend).getClass();
                        taskRunner$runnable$1.notify();
                    }
                    return null;
                }
                ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting = true;
                ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWakeUpAt = l2 += l3;
                ((TaskRunner$RealBackend)((TaskRunner)((Object)taskRunner$runnable$1)).backend).getClass();
                {
                    catch (Throwable throwable2222222) {
                        break;
                    }
                    catch (InterruptedException interruptedException) {}
                    {
                        ((TaskRunner)((Object)taskRunner$runnable$1)).cancelAll();
                        break block17;
                    }
                }
                {
                    l2 = l3 / 1000000L;
                    l = l3 - l2 * 1000000L;
                    if (l2 <= 0L && l3 <= 0L) break block17;
                }
                int n = (int)l;
                {
                    taskRunner$runnable$1.wait(l2, n);
                }
            }
            ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting = false;
        }
        ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting = false;
        throw throwable2222222;
    }

    public final TaskQueue newQueue() {
        TaskRunner taskRunner = this;
        synchronized (taskRunner) {
            int n = taskRunner.nextQueueName;
            taskRunner.nextQueueName = n + 1;
            return new TaskQueue(this, Intrinsics.stringPlus(n, "Q"));
        }
    }

    public final void cancelAll() {
        int n;
        int n2 = this.busyQueues.size() - 1;
        if (n2 >= 0) {
            while (true) {
                n = n2 + -1;
                ((TaskQueue)this.busyQueues.get(n2)).cancelAllAndDecide$okhttp();
                if (n < 0) break;
                n2 = n;
            }
        }
        if ((n2 = this.readyQueues.size() - 1) >= 0) {
            while (true) {
                n = n2 + -1;
                TaskQueue taskQueue = (TaskQueue)this.readyQueues.get(n2);
                taskQueue.cancelAllAndDecide$okhttp();
                if (taskQueue.futureTasks.isEmpty()) {
                    this.readyQueues.remove(n2);
                }
                if (n < 0) break;
                n2 = n;
            }
        }
    }

    public final void runTask(Task task) {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        Thread thread = Thread.currentThread();
        TaskRunner taskRunner = this;
        String string = thread.getName();
        thread.setName(task.getName());
        long l = -1L;
        try {
            l = task.runOnce();
        }
        catch (Throwable throwable) {
            TaskRunner taskRunner2 = this;
            synchronized (this) {
                taskRunner2.afterRun(task, l);
                thread.setName(string);
                throw throwable;
            }
        }
        synchronized (this) {
            taskRunner.afterRun(task, l);
            thread.setName(string);
            return;
        }
    }

    public final void afterRun(Task task, long l) {
        if (Util.assertionsEnabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        TaskQueue taskQueue = task.queue;
        Intrinsics.checkNotNull(taskQueue);
        if (taskQueue.activeTask == task) {
            boolean bl = taskQueue.cancelActiveTask;
            taskQueue.cancelActiveTask = false;
            taskQueue.activeTask = null;
            this.busyQueues.remove(taskQueue);
            if (l != -1L && !bl && !taskQueue.shutdown) {
                taskQueue.scheduleAndDecide$okhttp(task, l, true);
            }
            if (taskQueue.futureTasks.isEmpty() ^ true) {
                this.readyQueues.add(taskQueue);
            }
            return;
        }
        throw new IllegalStateException("Check failed.".toString());
    }
}

