/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.compiler;

import com.apollographql.apollo3.compiler.ValidationScope;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.DirectiveRedefinition$$ExternalSyntheticOutline0;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLDefinition;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLField;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLFragmentDefinition;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLFragmentSpread;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLInlineFragment;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLNode;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLOperationDefinition;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.GQLSelection;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.Issue;
import com.apollographql.apollo3.relocated.com.apollographql.apollo3.ast.UpperCaseField;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__IterablesKt;
import com.apollographql.apollo3.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.ranges.RangesKt___RangesKt;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__IndentKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0001H\u0002\u00a8\u0006\u000f"}, d2={"checkCapitalizedFields", "", "Lcom/apollographql/apollo3/ast/Issue;", "definitions", "Lcom/apollographql/apollo3/ast/GQLDefinition;", "checkFragmentsOnly", "", "decapitalizeFirstLetter", "", "name", "isFirstLetterUpperCase", "", "Lcom/apollographql/apollo3/compiler/ValidationScope;", "selections", "Lcom/apollographql/apollo3/ast/GQLSelection;", "apollo-compiler"})
public final class -checkCapitalizedFields {
    public static final List<Issue> checkCapitalizedFields(List<? extends GQLDefinition> object, boolean bl) {
        ValidationScope validationScope;
        Iterator iterator2 = object;
        Intrinsics.checkNotNullParameter(iterator2, "definitions");
        ValidationScope validationScope2 = validationScope;
        validationScope = new ValidationScope((List<? extends GQLDefinition>)((Object)object)){
            private final List<Issue> issues;
            private final Map<String, GQLFragmentDefinition> fragmentsByName;
            {
                LinkedHashMap<K, V> linkedHashMap;
                ArrayList<T> arrayList2;
                ArrayList<T> arrayList3;
                ArrayList<T> arrayList4 = arrayList;
                arrayList = arrayList3;
                arrayList3 = new ArrayList<T>();
                this.issues = arrayList;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<T>();
                for (Object object : arrayList4) {
                    if (!(object instanceof GQLFragmentDefinition)) continue;
                    arrayList.add(object);
                }
                ArrayList<T> arrayList5 = arrayList;
                int n = RangesKt___RangesKt.coerceAtLeast(MapsKt__MapsJVMKt.mapCapacity(CollectionsKt__IterablesKt.collectionSizeOrDefault(arrayList5)));
                LinkedHashMap<K, V> linkedHashMap2 = linkedHashMap;
                linkedHashMap = new LinkedHashMap<K, V>(n);
                for (Object object : arrayList5) {
                    linkedHashMap2.put(((GQLFragmentDefinition)object).getName(), object);
                }
                this.fragmentsByName = linkedHashMap2;
            }

            public List<Issue> getIssues() {
                return this.issues;
            }

            public Map<String, GQLFragmentDefinition> getFragmentsByName() {
                return this.fragmentsByName;
            }
        };
        object = iterator2.iterator();
        while (object.hasNext()) {
            GQLDefinition gQLDefinition = (GQLDefinition)object.next();
            if (gQLDefinition instanceof GQLOperationDefinition && !bl) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLOperationDefinition)gQLDefinition).selections);
                continue;
            }
            if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLFragmentDefinition)gQLDefinition).selections);
        }
        return validationScope2.getIssues();
    }

    private static final void checkCapitalizedFields(ValidationScope validationScope, List<? extends GQLSelection> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (GQLSelection)object.next();
            if (object2 instanceof GQLField) {
                GQLField gQLField = (GQLField)object2;
                String string = gQLField.alias;
                if (string != null) {
                    if (-checkCapitalizedFields.isFirstLetterUpperCase(string)) {
                        GQLNode gQLNode = object2;
                        object2 = StringsKt__IndentKt.trimIndent(DirectiveRedefinition$$ExternalSyntheticOutline0.m("\n                      Capitalized alias '", string, "' is not supported as it causes name clashes with the generated models. Use '").append(-checkCapitalizedFields.decapitalizeFirstLetter(string)).append("' instead.\n                    ").toString());
                        validationScope.getIssues().add(new UpperCaseField(gQLNode.getSourceLocation(), (String)object2));
                    }
                } else if (-checkCapitalizedFields.isFirstLetterUpperCase(gQLField.name)) {
                    GQLNode gQLNode = object2;
                    object2 = StringsKt__IndentKt.trimIndent("\n                      Capitalized field '" + gQLField.name + "' is not supported as it causes name clashes with the generated models. Use an alias instead or the 'flattenModels' or 'decapitalizeFields' compiler option.\n                    ");
                    validationScope.getIssues().add(new UpperCaseField(gQLNode.getSourceLocation(), (String)object2));
                }
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, gQLField.selections);
                continue;
            }
            if (object2 instanceof GQLInlineFragment) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLInlineFragment)object2).selections);
                continue;
            }
            if (!(object2 instanceof GQLFragmentSpread) || (object2 = validationScope.getFragmentsByName().get(((GQLFragmentSpread)object2).name)) == null) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLFragmentDefinition)object2).selections);
        }
    }

    private static final boolean isFirstLetterUpperCase(String object) {
        block1: {
            for (int i = 0; i < object.length(); ++i) {
                char c = object.charAt(i);
                if (!Character.isLetter(c)) continue;
                object = Character.valueOf(c);
                break block1;
            }
            object = null;
        }
        return object != null ? Character.isUpperCase(((Character)object).charValue()) : true;
    }

    private static final String decapitalizeFirstLetter(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!bl && Character.isLetter(c)) {
                bl = true;
                string2 = String.valueOf(c).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            } else {
                string2 = String.valueOf(c);
            }
            stringBuilder2.append(string2);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }
}

