/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.ws;

import com.apollographql.apollo3.relocated.kotlin.io.CloseableKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.ws.MessageDeflater;
import com.apollographql.apollo3.relocated.okhttp3.internal.ws.MessageDeflaterKt;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.Buffer$UnsafeCursor;
import com.apollographql.apollo3.relocated.okio.BufferedSink;
import com.apollographql.apollo3.relocated.okio.ByteString;
import com.apollographql.apollo3.relocated.okio.Segment;
import com.apollographql.apollo3.relocated.okio._UtilKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.Random;

public final class WebSocketWriter
implements Closeable {
    public final boolean isClient;
    public final BufferedSink sink;
    public final Random random;
    public final boolean perMessageDeflate;
    public final boolean noContextTakeover;
    public final long minimumDeflateSize;
    public final Buffer messageBuffer;
    public final Buffer sinkBuffer;
    public boolean writerClosed;
    public MessageDeflater messageDeflater;
    public final byte[] maskKey;
    public final Buffer$UnsafeCursor maskCursor;

    public WebSocketWriter(boolean bl, BufferedSink object, Random random, boolean bl2, boolean bl3, long l) {
        Buffer$UnsafeCursor buffer$UnsafeCursor;
        WebSocketWriter webSocketWriter = this;
        Intrinsics.checkNotNullParameter(object, "sink");
        Intrinsics.checkNotNullParameter(random, "random");
        this.isClient = bl;
        this.sink = object;
        this.random = random;
        this.perMessageDeflate = bl2;
        this.noContextTakeover = bl3;
        webSocketWriter.minimumDeflateSize = l;
        webSocketWriter.messageBuffer = new Buffer();
        this.sinkBuffer = object.getBuffer();
        object = bl ? (Object)new byte[4] : null;
        this.maskKey = (byte[])object;
        if (bl) {
            Buffer$UnsafeCursor buffer$UnsafeCursor2;
            buffer$UnsafeCursor = buffer$UnsafeCursor2;
            buffer$UnsafeCursor2 = new Buffer$UnsafeCursor();
        } else {
            buffer$UnsafeCursor = null;
        }
        this.maskCursor = buffer$UnsafeCursor;
    }

    public final void writePing(ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "payload");
        this.writeControlFrame(9, byteString);
    }

    public final void writePong(ByteString byteString) {
        this.writeControlFrame(10, byteString);
    }

    public final void writeClose(int n, ByteString byteString) {
        Object object = ByteString.EMPTY;
        if (n != 0 || byteString != null) {
            Buffer buffer;
            if (n != 0) {
                object = n >= 1000 && n < 5000 ? (!(1004 <= n && n < 1007) && !(1015 <= n && n < 3000) ? null : "Code " + n + " is reserved and may not be used.") : Intrinsics.stringPlus(n, "Code must be in range [1000,5000): ");
                if (!(object == null)) {
                    Intrinsics.checkNotNull(object);
                    throw new IllegalArgumentException(object.toString());
                }
            }
            object = buffer;
            new Buffer().writeShort(n);
            if (byteString != null) {
                ByteString byteString2 = byteString;
                byteString2.write$okio((Buffer)object, byteString2.getSize$okio());
            }
            Object object2 = object;
            object = ((Buffer)object2).readByteString(((Buffer)object2).size);
        }
        try {
            this.writeControlFrame(8, (ByteString)object);
            this.writerClosed = true;
            return;
        }
        catch (Throwable throwable) {
            this.writerClosed = true;
            throw throwable;
        }
    }

    public final void writeMessageFrame(int n, ByteString object) {
        block17: {
            long l;
            block22: {
                int n2;
                block18: {
                    block19: {
                        Buffer buffer;
                        block21: {
                            block20: {
                                Intrinsics.checkNotNullParameter(object, "data");
                                if (((WebSocketWriter)((Object)throwable2)).writerClosed) break block17;
                                ByteString byteString = object;
                                Buffer buffer2 = ((WebSocketWriter)((Object)throwable2)).messageBuffer;
                                buffer2.getClass();
                                byteString.write$okio(buffer2, byteString.getSize$okio());
                                n2 = n | 0x80;
                                if (!((WebSocketWriter)((Object)throwable2)).perMessageDeflate || (long)((ByteString)object).getSize$okio() < ((WebSocketWriter)((Object)throwable2)).minimumDeflateSize) break block18;
                                object = ((WebSocketWriter)((Object)throwable2)).messageDeflater;
                                if (object == null) {
                                    MessageDeflater messageDeflater;
                                    object = messageDeflater;
                                    messageDeflater = new MessageDeflater(((WebSocketWriter)((Object)throwable2)).noContextTakeover);
                                    ((WebSocketWriter)((Object)throwable2)).messageDeflater = object;
                                }
                                buffer = ((WebSocketWriter)((Object)throwable2)).messageBuffer;
                                Intrinsics.checkNotNullParameter(buffer, "buffer");
                                if (!(((MessageDeflater)object).deflatedBytes.size == 0L)) break block19;
                                if (((MessageDeflater)object).noContextTakeover) {
                                    ((MessageDeflater)object).deflater.reset();
                                }
                                Object object2 = object;
                                Buffer buffer3 = buffer;
                                ((MessageDeflater)object2).deflaterSink.write(buffer3, buffer3.size);
                                ((MessageDeflater)object2).deflaterSink.flush();
                                Buffer buffer4 = ((MessageDeflater)object2).deflatedBytes;
                                ByteString byteString2 = MessageDeflaterKt.EMPTY_DEFLATE_BLOCK;
                                if (!buffer4.rangeEquals(buffer4.size - (long)byteString2.data.length, byteString2)) break block20;
                                Buffer buffer5 = ((MessageDeflater)object).deflatedBytes;
                                long l2 = buffer5.size - (long)4;
                                Buffer$UnsafeCursor buffer$UnsafeCursor = buffer5.readAndWriteUnsafe(_UtilKt.DEFAULT__new_UnsafeCursor);
                                byteString2 = null;
                                try {
                                    buffer$UnsafeCursor.resizeBuffer(l2);
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    try {
                                        throw throwable;
                                    }
                                    catch (Throwable throwable3) {
                                        CloseableKt.closeFinally(buffer$UnsafeCursor, throwable2);
                                        throw throwable3;
                                    }
                                }
                                CloseableKt.closeFinally(buffer$UnsafeCursor, (Throwable)((Object)byteString2));
                                break block21;
                            }
                            ((MessageDeflater)object).deflatedBytes.writeByte(0);
                        }
                        Buffer buffer6 = ((MessageDeflater)object).deflatedBytes;
                        l = buffer6.size;
                        buffer.write(buffer6, l);
                        n2 |= 0x40;
                        break block18;
                    }
                    throw new IllegalArgumentException("Failed requirement.".toString());
                }
                l = ((WebSocketWriter)((Object)throwable2)).messageBuffer.size;
                ((WebSocketWriter)((Object)throwable2)).sinkBuffer.writeByte(n2);
                n2 = 0;
                if (((WebSocketWriter)((Object)throwable2)).isClient) {
                    n2 = 128;
                }
                if (l <= 125L) {
                    ((WebSocketWriter)((Object)throwable2)).sinkBuffer.writeByte(n2 | (int)l);
                } else if (l <= 65535L) {
                    ((WebSocketWriter)((Object)throwable2)).sinkBuffer.writeByte(n2 | 0x7E);
                    ((WebSocketWriter)((Object)throwable2)).sinkBuffer.writeShort((int)l);
                } else {
                    ((WebSocketWriter)((Object)throwable2)).sinkBuffer.writeByte(n2 | 0x7F);
                    Buffer buffer = ((WebSocketWriter)((Object)throwable2)).sinkBuffer;
                    Segment segment = buffer.writableSegment$okio(8);
                    object = segment.data;
                    n2 = segment.limit;
                    int n3 = n2 + 1;
                    object[n2] = (byte)(l >>> 56 & 0xFFL);
                    n2 = n3 + 1;
                    object[n3] = (byte)(l >>> 48 & 0xFFL);
                    n3 = n2 + 1;
                    object[n2] = (byte)(l >>> 40 & 0xFFL);
                    n2 = n3 + 1;
                    object[n3] = (byte)(l >>> 32 & 0xFFL);
                    n3 = n2 + 1;
                    object[n2] = (byte)(l >>> 24 & 0xFFL);
                    n2 = n3 + 1;
                    object[n3] = (byte)(l >>> 16 & 0xFFL);
                    n3 = n2 + 1;
                    object[n2] = (byte)(l >>> 8 & 0xFFL);
                    n2 = n3 + 1;
                    segment.data[n3] = (byte)(l & 0xFFL);
                    segment.limit = n2;
                    buffer.size += 8L;
                }
                if (((WebSocketWriter)((Object)throwable2)).isClient) {
                    Intrinsics.checkNotNull(((WebSocketWriter)((Object)throwable2)).maskKey);
                    ((WebSocketWriter)((Object)throwable2)).random.nextBytes(((WebSocketWriter)((Object)throwable2)).maskKey);
                    Closeable closeable = ((WebSocketWriter)((Object)throwable2)).sinkBuffer;
                    byte[] byArray = ((WebSocketWriter)((Object)throwable2)).maskKey;
                    closeable.getClass();
                    Intrinsics.checkNotNullParameter(byArray, "source");
                    ((Buffer)closeable).write(((WebSocketWriter)((Object)throwable2)).maskKey, 0, byArray.length);
                    if (l > 0L) {
                        block16: {
                            long l3;
                            Buffer$UnsafeCursor buffer$UnsafeCursor = ((WebSocketWriter)((Object)throwable2)).maskCursor;
                            Intrinsics.checkNotNull(buffer$UnsafeCursor);
                            ((WebSocketWriter)((Object)throwable2)).messageBuffer.readAndWriteUnsafe(buffer$UnsafeCursor);
                            ((WebSocketWriter)((Object)throwable2)).maskCursor.seek(0L);
                            closeable = ((WebSocketWriter)((Object)throwable2)).maskCursor;
                            byte[] byArray2 = ((WebSocketWriter)((Object)throwable2)).maskKey;
                            Intrinsics.checkNotNullParameter(closeable, "cursor");
                            Intrinsics.checkNotNullParameter(byArray2, "key");
                            int n4 = 0;
                            int n5 = ((WebSocketWriter)((Object)throwable2)).maskKey.length;
                            do {
                                byte[] byArray3 = ((Buffer$UnsafeCursor)closeable).data;
                                Closeable closeable2 = closeable;
                                int n6 = ((Buffer$UnsafeCursor)closeable2).start;
                                int n7 = ((Buffer$UnsafeCursor)closeable2).end;
                                if (((Buffer$UnsafeCursor)closeable).data != null) {
                                    while (n6 < n7) {
                                        byArray3[n6] = (byte)(byArray3[n6] ^ byArray2[n4 %= n5]);
                                        ++n6;
                                        ++n4;
                                    }
                                }
                                long l4 = ((Buffer$UnsafeCursor)closeable).offset;
                                Buffer buffer = ((Buffer$UnsafeCursor)closeable).buffer;
                                Intrinsics.checkNotNull(buffer);
                                if (!(l4 != buffer.size)) break block16;
                            } while (((l3 = ((Buffer$UnsafeCursor)closeable).offset) == -1L ? ((Buffer$UnsafeCursor)closeable).seek(0L) : ((Buffer$UnsafeCursor)closeable).seek(l3 + (long)(((Buffer$UnsafeCursor)closeable).end - ((Buffer$UnsafeCursor)closeable).start))) != -1);
                            ((WebSocketWriter)((Object)throwable2)).maskCursor.close();
                            break block22;
                        }
                        throw new IllegalStateException("no more bytes".toString());
                    }
                }
            }
            ((WebSocketWriter)((Object)throwable2)).sinkBuffer.write(((WebSocketWriter)((Object)throwable2)).messageBuffer, l);
            ((WebSocketWriter)((Object)throwable2)).sink.emit();
            return;
        }
        throw new IOException("closed");
    }

    @Override
    public final void close() {
        Closeable closeable = closeable.messageDeflater;
        if (closeable != null) {
            ((MessageDeflater)closeable).deflaterSink.close();
        }
    }

    public final void writeControlFrame(int n, ByteString object) {
        block4: {
            block5: {
                block7: {
                    int n2;
                    block6: {
                        block3: {
                            long l;
                            if (this.writerClosed) break block4;
                            n2 = ((ByteString)object).getSize$okio();
                            if (!((long)n2 <= 125L)) break block5;
                            WebSocketWriter webSocketWriter = this;
                            webSocketWriter.sinkBuffer.writeByte(n |= 0x80);
                            if (!webSocketWriter.isClient) break block6;
                            WebSocketWriter webSocketWriter2 = this;
                            n = n2 | 0x80;
                            webSocketWriter2.sinkBuffer.writeByte(n);
                            Random random = webSocketWriter2.random;
                            Intrinsics.checkNotNull(this.maskKey);
                            random.nextBytes(this.maskKey);
                            Closeable closeable = webSocketWriter2.sinkBuffer;
                            byte[] byArray = this.maskKey;
                            closeable.getClass();
                            Intrinsics.checkNotNullParameter(byArray, "source");
                            ((Buffer)closeable).write(this.maskKey, 0, byArray.length);
                            if (n2 <= 0) break block7;
                            WebSocketWriter webSocketWriter3 = this;
                            ByteString byteString = object;
                            closeable = this.sinkBuffer;
                            long l2 = ((Buffer)closeable).size;
                            byteString.write$okio((Buffer)closeable, byteString.getSize$okio());
                            Buffer buffer = webSocketWriter3.sinkBuffer;
                            Buffer$UnsafeCursor buffer$UnsafeCursor = this.maskCursor;
                            Intrinsics.checkNotNull(buffer$UnsafeCursor);
                            buffer.readAndWriteUnsafe(buffer$UnsafeCursor);
                            webSocketWriter3.maskCursor.seek(l2);
                            closeable = webSocketWriter3.maskCursor;
                            object = webSocketWriter3.maskKey;
                            Intrinsics.checkNotNullParameter(closeable, "cursor");
                            Intrinsics.checkNotNullParameter(webSocketWriter3.maskKey, "key");
                            int n3 = 0;
                            int n4 = webSocketWriter3.maskKey.length;
                            do {
                                byte[] byArray2 = ((Buffer$UnsafeCursor)closeable).data;
                                Closeable closeable2 = closeable;
                                int n5 = ((Buffer$UnsafeCursor)closeable2).start;
                                int n6 = ((Buffer$UnsafeCursor)closeable2).end;
                                if (((Buffer$UnsafeCursor)closeable).data != null) {
                                    while (n5 < n6) {
                                        byArray2[n5] = (byte)(byArray2[n5] ^ object[n3 %= n4]);
                                        ++n5;
                                        ++n3;
                                    }
                                }
                                long l3 = ((Buffer$UnsafeCursor)closeable).offset;
                                Buffer buffer2 = ((Buffer$UnsafeCursor)closeable).buffer;
                                Intrinsics.checkNotNull(buffer2);
                                if (!(l3 != buffer2.size)) break block3;
                            } while (((l = ((Buffer$UnsafeCursor)closeable).offset) == -1L ? ((Buffer$UnsafeCursor)closeable).seek(0L) : ((Buffer$UnsafeCursor)closeable).seek(l + (long)(((Buffer$UnsafeCursor)closeable).end - ((Buffer$UnsafeCursor)closeable).start))) != -1);
                            this.maskCursor.close();
                            break block7;
                        }
                        throw new IllegalStateException("no more bytes".toString());
                    }
                    ByteString byteString = object;
                    WebSocketWriter webSocketWriter = this;
                    webSocketWriter.sinkBuffer.writeByte(n2);
                    Buffer buffer = webSocketWriter.sinkBuffer;
                    buffer.getClass();
                    byteString.write$okio(buffer, byteString.getSize$okio());
                }
                this.sink.flush();
                return;
            }
            throw new IllegalArgumentException("Payload size must be less than or equal to 125".toString());
        }
        throw new IOException("closed");
    }
}

