/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Hpack$Writer;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Settings;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Http2Writer
implements Closeable {
    public static final Logger logger = Logger.getLogger(Http2.class.getName());
    public final BufferedSink sink;
    public final boolean client;
    public final Buffer hpackBuffer;
    public int maxFrameSize;
    public boolean closed;
    public final Hpack$Writer hpackWriter;

    public Http2Writer(BufferedSink object, boolean bl) {
        Hpack$Writer hpack$Writer;
        Buffer buffer;
        closeable.sink = object;
        closeable.client = bl;
        Closeable closeable = buffer;
        buffer = new Buffer();
        v1.hpackBuffer = closeable;
        v1.maxFrameSize = 16384;
        object = hpack$Writer;
        hpack$Writer = new Hpack$Writer((Buffer)closeable);
        v1.hpackWriter = object;
    }

    public final synchronized void applyAndAckSettings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "peerSettings");
        if (!this.closed) {
            int n = this.maxFrameSize;
            int n2 = settings.set;
            if ((n2 & 0x20) != 0) {
                n = settings.values[5];
            }
            this.maxFrameSize = n;
            n = (n2 & 2) != 0 ? settings.values[1] : -1;
            if (n != -1) {
                Hpack$Writer hpack$Writer = this.hpackWriter;
                int n3 = (n2 & 2) != 0 ? settings.values[1] : -1;
                hpack$Writer.getClass();
                n3 = Math.min(n3, 16384);
                n2 = hpack$Writer.maxDynamicTableByteCount;
                if (n2 != n3) {
                    if (n3 < n2) {
                        hpack$Writer.smallestHeaderTableSizeSetting = Math.min(hpack$Writer.smallestHeaderTableSizeSetting, n3);
                    }
                    hpack$Writer.emitDynamicTableSizeUpdate = true;
                    hpack$Writer.maxDynamicTableByteCount = n3;
                    n2 = hpack$Writer.dynamicTableByteCount;
                    if (n3 < n2) {
                        if (n3 == 0) {
                            Hpack$Writer hpack$Writer2 = hpack$Writer;
                            ArraysKt___ArraysJvmKt.fill$default(hpack$Writer2.dynamicTable, null);
                            hpack$Writer2.nextHeaderIndex = hpack$Writer2.dynamicTable.length - 1;
                            hpack$Writer2.headerCount = 0;
                            hpack$Writer2.dynamicTableByteCount = 0;
                        } else {
                            hpack$Writer.evictToRecoverBytes(n2 - n3);
                        }
                    }
                }
            }
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 0, 4, 1);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void flush() {
        if (!this.closed) {
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void rstStream(int n, ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        if (!this.closed) {
            if (errorCode.httpCode != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(n, 4, 3, 0);
                http2Writer.sink.writeInt(errorCode.httpCode);
                http2Writer.sink.flush();
                return;
            }
            throw new IllegalArgumentException("Failed requirement.".toString());
        }
        throw new IOException("closed");
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    public final synchronized void data(boolean bl, int n, Buffer buffer, int n2) {
        if (!this.closed) {
            this.frameHeader(n, n2, 0, bl ? 1 : 0);
            if (n2 > 0) {
                Intrinsics.checkNotNull(buffer);
                this.sink.write(buffer, n2);
            }
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void settings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        if (!this.closed) {
            this.frameHeader(0, Integer.bitCount(settings.set) * 6, 4, 0);
            int n = 0;
            while (n < 10) {
                int n2 = n + 1;
                int n3 = 1 << n;
                n3 = (settings.set & n3) != 0 ? 1 : 0;
                if (n3 != 0) {
                    n3 = n != 4 ? (n != 7 ? n : 4) : 3;
                    Http2Writer http2Writer = this;
                    http2Writer.sink.writeShort(n3);
                    http2Writer.sink.writeInt(settings.values[n]);
                }
                n = n2;
            }
            this.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void ping(int n, int n2, boolean bl) {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.frameHeader(0, 8, 6, bl ? 1 : 0);
            http2Writer.sink.writeInt(n);
            http2Writer.sink.writeInt(n2);
            http2Writer.sink.flush();
            return;
        }
        throw new IOException("closed");
    }

    public final synchronized void goAway(int n, ErrorCode errorCode, byte[] byArray) {
        if (!this.closed) {
            if (errorCode.httpCode != -1) {
                Http2Writer http2Writer = this;
                http2Writer.frameHeader(0, byArray.length + 8, 7, 0);
                http2Writer.sink.writeInt(n);
                http2Writer.sink.writeInt(errorCode.httpCode);
                if (byArray.length == 0 ^ true) {
                    this.sink.write(byArray);
                }
                this.sink.flush();
                return;
            }
            throw new IllegalArgumentException("errorCode.httpCode == -1".toString());
        }
        throw new IOException("closed");
    }

    public final synchronized void windowUpdate(int n, long l) {
        if (!((Http2Writer)((Object)string)).closed) {
            if (l != 0L && l <= Integer.MAX_VALUE) {
                Http2Writer http2Writer = string;
                http2Writer.frameHeader(n, 4, 8, 0);
                http2Writer.sink.writeInt((int)l);
                http2Writer.sink.flush();
                return;
            }
            String string = Intrinsics.stringPlus(l, "windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: ");
            throw new IllegalArgumentException(string.toString());
        }
        throw new IOException("closed");
    }

    public final void frameHeader(int n, int n2, int n3, int n4) {
        Object object;
        Logger logger2 = logger;
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine(Http2.frameLog(n, n2, n3, n4, false));
        }
        if (n2 <= ((Http2Writer)object).maxFrameSize) {
            if ((n & Integer.MIN_VALUE) == 0) {
                Http2Writer http2Writer = object;
                object = http2Writer.sink;
                Intrinsics.checkNotNullParameter(object, "<this>");
                object.writeByte(n2 >>> 16 & 0xFF);
                object.writeByte(n2 >>> 8 & 0xFF);
                object.writeByte(n2 & 0xFF);
                http2Writer.sink.writeByte(n3 & 0xFF);
                http2Writer.sink.writeByte(n4 & 0xFF);
                http2Writer.sink.writeInt(n & Integer.MAX_VALUE);
                return;
            }
            object = Intrinsics.stringPlus(n, "reserved bit set: ");
            throw new IllegalArgumentException(object.toString());
        }
        object = "FRAME_SIZE_ERROR length > " + ((Http2Writer)object).maxFrameSize + ": " + n2;
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public final synchronized void close() {
        this.closed = true;
        this.sink.close();
    }

    public final synchronized void headers(int n, ArrayList arrayList, boolean bl) {
        if (!this.closed) {
            Http2Writer http2Writer = this;
            http2Writer.hpackWriter.writeHeaders(arrayList);
            long l = http2Writer.hpackBuffer.size;
            long l2 = Math.min((long)this.maxFrameSize, l);
            int n2 = l == l2 ? 4 : 0;
            if (bl) {
                n2 |= 1;
            }
            Http2Writer http2Writer2 = this;
            http2Writer2.frameHeader(n, (int)l2, 1, n2);
            http2Writer2.sink.write(this.hpackBuffer, l2);
            if (l > l2) {
                long l3 = l - l2;
                while (l3 > 0L) {
                    long l4 = l3;
                    l3 = Math.min((long)this.maxFrameSize, l3);
                    l = l4 - l3;
                    int n3 = (int)l3;
                    int n4 = 9;
                    int n5 = l == 0L ? 4 : 0;
                    Http2Writer http2Writer3 = this;
                    http2Writer3.frameHeader(n, n3, n4, n5);
                    http2Writer3.sink.write(this.hpackBuffer, l3);
                    l3 = l;
                }
            }
            return;
        }
        throw new IOException("closed");
    }
}

