/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.connection;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt___ArraysKt;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__CollectionsJVMKt;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo3.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.Regex;
import com.apollographql.apollo3.relocated.okhttp3.Address;
import com.apollographql.apollo3.relocated.okhttp3.Call;
import com.apollographql.apollo3.relocated.okhttp3.Dns$Companion$DnsSystem;
import com.apollographql.apollo3.relocated.okhttp3.EventListener;
import com.apollographql.apollo3.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo3.relocated.okhttp3.Route;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteDatabase;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteSelector$Selection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public final class RouteSelector {
    public final Address address;
    public final RouteDatabase routeDatabase;
    public final Call call;
    public final EventListener eventListener;
    public List proxies;
    public int nextProxyIndex;
    public List inetSocketAddresses;
    public final ArrayList postponedRoutes;

    public RouteSelector(Address address, RouteDatabase routeDatabase, RealCall realCall, EventListener eventListener) {
        ArrayList arrayList;
        RouteSelector routeSelector = object;
        Address address2 = address;
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(routeDatabase, "routeDatabase");
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        ((RouteSelector)object).address = address;
        ((RouteSelector)object).routeDatabase = routeDatabase;
        ((RouteSelector)object).call = realCall;
        ((RouteSelector)object).eventListener = eventListener;
        Object object = EmptyList.INSTANCE;
        v2.proxies = object;
        v2.inetSocketAddresses = object;
        object = arrayList;
        arrayList = new ArrayList();
        v2.postponedRoutes = object;
        object = address2.url();
        routeSelector.resetNextProxy((HttpUrl)object, address2.proxy());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RouteSelector$Selection next() {
        boolean bl;
        ArrayList arrayList;
        boolean bl2 = ((RouteSelector)((Object)string)).nextProxyIndex < ((RouteSelector)((Object)string)).proxies.size() || ((RouteSelector)((Object)string)).postponedRoutes.isEmpty() ^ true;
        if (!bl2) {
            throw new NoSuchElementException();
        }
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        while (bl = ((RouteSelector)((Object)string)).nextProxyIndex < ((RouteSelector)((Object)string)).proxies.size()) {
            int n;
            Object object;
            ArrayList<InetSocketAddress> arrayList3;
            bl = ((RouteSelector)((Object)string)).nextProxyIndex < ((RouteSelector)((Object)string)).proxies.size();
            if (!bl) {
                throw new SocketException("No route to " + ((RouteSelector)((Object)string)).address.url.host + "; exhausted proxy configurations: " + ((RouteSelector)((Object)string)).proxies);
            }
            Proxy proxy = (Proxy)((RouteSelector)((Object)string)).proxies.get(((RouteSelector)((Object)string)).nextProxyIndex++);
            ArrayList<InetSocketAddress> arrayList4 = arrayList3;
            arrayList3 = new ArrayList<InetSocketAddress>();
            ((RouteSelector)((Object)string)).inetSocketAddresses = arrayList4;
            if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
                SocketAddress socketAddress = proxy.address();
                if (!(socketAddress instanceof InetSocketAddress)) {
                    String string = Intrinsics.stringPlus(socketAddress.getClass(), "Proxy.address() is not an InetSocketAddress: ");
                    throw new IllegalArgumentException(string.toString());
                }
                SocketAddress socketAddress2 = socketAddress;
                Intrinsics.checkNotNullExpressionValue(socketAddress2, "proxyAddress");
                socketAddress = (InetSocketAddress)socketAddress2;
                object = ((InetSocketAddress)socketAddress).getAddress();
                if (object == null) {
                    object = ((InetSocketAddress)socketAddress).getHostName();
                    Intrinsics.checkNotNullExpressionValue(object, "hostName");
                } else {
                    object = ((InetAddress)object).getHostAddress();
                    Intrinsics.checkNotNullExpressionValue(object, "address.hostAddress");
                }
                n = ((InetSocketAddress)socketAddress).getPort();
            } else {
                HttpUrl httpUrl = ((RouteSelector)((Object)string)).address.url;
                object = httpUrl.host;
                n = httpUrl.port;
            }
            if (!(1 <= n && n < 65536)) {
                throw new SocketException("No route to " + (String)object + ':' + n + "; port is out of range");
            }
            if (proxy.type() == Proxy.Type.SOCKS) {
                arrayList4.add(InetSocketAddress.createUnresolved((String)object, n));
            } else {
                Object object2;
                Intrinsics.checkNotNullParameter(object, "<this>");
                Regex regex = Util.VERIFY_AS_IP_ADDRESS;
                regex.getClass();
                if (regex.nativePattern.matcher((CharSequence)object).matches()) {
                    object = CollectionsKt__CollectionsJVMKt.listOf(InetAddress.getByName((String)object));
                } else {
                    ((RouteSelector)((Object)string)).eventListener.getClass();
                    Intrinsics.checkNotNullParameter(((RouteSelector)((Object)string)).call, "call");
                    ((Dns$Companion$DnsSystem)((RouteSelector)((Object)string)).address.dns).getClass();
                    try {
                        Object[] objectArray = InetAddress.getAllByName(object);
                        Intrinsics.checkNotNullExpressionValue(objectArray, "getAllByName(hostname)");
                        object2 = ArraysKt___ArraysKt.toList(objectArray);
                    }
                    catch (NullPointerException nullPointerException) {
                        UnknownHostException unknownHostException = new UnknownHostException(Intrinsics.stringPlus(object, "Broken system behaviour for dns lookup of "));
                        unknownHostException.initCause(nullPointerException);
                        throw unknownHostException;
                    }
                    if (object2.isEmpty()) {
                        throw new UnknownHostException(((RouteSelector)((Object)string)).address.dns + " returned no addresses for " + (String)object);
                    }
                    ((RouteSelector)((Object)string)).eventListener.getClass();
                    Intrinsics.checkNotNullParameter(((RouteSelector)((Object)string)).call, "call");
                    object = object2;
                }
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (InetAddress)object.next();
                    arrayList4.add(new InetSocketAddress((InetAddress)object2, n));
                }
            }
            for (Object object3 : ((RouteSelector)((Object)string)).inetSocketAddresses) {
                Route route;
                object = route;
                route = new Route(((RouteSelector)((Object)string)).address, proxy, (InetSocketAddress)object3);
                object3 = ((RouteSelector)((Object)string)).routeDatabase;
                synchronized (object3) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2, 5, 7] lbl82 : MonitorExitStatement: MONITOREXIT : var4_9
                    if (((RouteDatabase)object3).failedRoutes.contains(object)) {
                        ((RouteSelector)((Object)string)).postponedRoutes.add(object);
                        continue;
                    }
                }
                arrayList2.add(object);
            }
            if (!(arrayList2.isEmpty() ^ true)) continue;
        }
        if (arrayList2.isEmpty()) {
            CollectionsKt__MutableCollectionsKt.addAll((Iterable)((RouteSelector)((Object)string)).postponedRoutes, arrayList2);
            ((RouteSelector)((Object)string)).postponedRoutes.clear();
        }
        return new RouteSelector$Selection(arrayList2);
    }

    public final void resetNextProxy(HttpUrl list, Proxy proxy) {
        RouteSelector routeSelector = eventListener2;
        EventListener eventListener = routeSelector.eventListener;
        Call call = routeSelector.call;
        eventListener.getClass();
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(list, "url");
        if (proxy != null) {
            list = CollectionsKt__CollectionsJVMKt.listOf(proxy);
        } else if (((URI)((Object)(list = ((HttpUrl)((Object)list)).uri()))).getHost() == null) {
            list = Util.immutableListOf(Proxy.NO_PROXY);
        } else {
            boolean bl = (list = ((RouteSelector)((Object)eventListener2)).address.proxySelector.select((URI)((Object)list))) == null || list.isEmpty();
            if (bl) {
                list = Util.immutableListOf(Proxy.NO_PROXY);
            } else {
                List list2 = list;
                Intrinsics.checkNotNullExpressionValue(list2, "proxiesOrNull");
                list = Util.toImmutableList(list2);
            }
        }
        RouteSelector routeSelector2 = eventListener2;
        routeSelector2.proxies = list;
        routeSelector2.nextProxyIndex = 0;
        EventListener eventListener2 = routeSelector2.eventListener;
        Call call2 = routeSelector2.call;
        eventListener2.getClass();
        Intrinsics.checkNotNullParameter(call2, "call");
    }
}

