/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.connection;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.Address;
import com.apollographql.apollo3.relocated.okhttp3.EventListener;
import com.apollographql.apollo3.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo3.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo3.relocated.okhttp3.Route;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnectionPool;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteException;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteSelector;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteSelector$Selection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.RealInterceptorChain;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ConnectionShutdownException;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.StreamResetException;
import com.apollographql.apollo3.relocated.okio.RealBufferedSource;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.List;

public final class ExchangeFinder {
    public final RealConnectionPool connectionPool;
    public final Address address;
    public final RealCall call;
    public final EventListener eventListener;
    public RouteSelector$Selection routeSelection;
    public RouteSelector routeSelector;
    public int refusedStreamCount;
    public int connectionShutdownCount;
    public int otherFailureCount;
    public Route nextRouteToTry;

    public ExchangeFinder(RealConnectionPool realConnectionPool, Address address, RealCall realCall, EventListener eventListener) {
        Intrinsics.checkNotNullParameter(realConnectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = realCall;
        this.eventListener = eventListener;
    }

    public final ExchangeCodec find(OkHttpClient okHttpClient, RealInterceptorChain realInterceptorChain) {
        OkHttpClient okHttpClient2 = okHttpClient;
        RealInterceptorChain realInterceptorChain2 = realInterceptorChain;
        Intrinsics.checkNotNullParameter(okHttpClient, "client");
        int bl = realInterceptorChain2.connectTimeoutMillis;
        int n = realInterceptorChain2.readTimeoutMillis;
        int n2 = realInterceptorChain2.writeTimeoutMillis;
        int n3 = okHttpClient2.pingIntervalMillis;
        boolean bl2 = okHttpClient2.retryOnConnectionFailure;
        int n4 = bl;
        boolean bl3 = Intrinsics.areEqual(realInterceptorChain.request.method, "GET") ^ true;
        try {
            return this.findHealthyConnection(n4, n, n2, n3, bl2, bl3).newCodec$okhttp(okHttpClient, realInterceptorChain);
        }
        catch (IOException iOException) {
            this.trackFailure(iOException);
            throw new RouteException(iOException);
        }
        catch (RouteException routeException) {
            this.trackFailure(routeException.lastConnectException);
            throw routeException;
        }
    }

    public final void trackFailure(IOException iOException) {
        Intrinsics.checkNotNullParameter(iOException, "e");
        this.nextRouteToTry = null;
        if (iOException instanceof StreamResetException && ((StreamResetException)iOException).errorCode == ErrorCode.REFUSED_STREAM) {
            ++this.refusedStreamCount;
        } else if (iOException instanceof ConnectionShutdownException) {
            ++this.connectionShutdownCount;
        } else {
            ++this.otherFailureCount;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final RealConnection findHealthyConnection(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        while (true) {
            boolean bl3;
            Object object;
            block8: {
                block9: {
                    object = this.findConnection(n, n2, n3, n4, bl);
                    if (Util.assertionsEnabled) {
                        if (Thread.holdsLock(object)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + object));
                    }
                    RealConnection realConnection = object;
                    long l = System.nanoTime();
                    Closeable closeable = realConnection.rawSocket;
                    Intrinsics.checkNotNull(closeable);
                    Socket socket = realConnection.socket;
                    Intrinsics.checkNotNull(socket);
                    RealBufferedSource realBufferedSource = realConnection.source;
                    Intrinsics.checkNotNull(realBufferedSource);
                    if (((Socket)closeable).isClosed() || socket.isClosed() || socket.isInputShutdown() || socket.isOutputShutdown()) break block9;
                    closeable = ((RealConnection)object).http2Connection;
                    if (closeable != null) {
                        bl3 = ((Http2Connection)closeable).isHealthy(l);
                        break block8;
                    } else {
                        Object object2 = object;
                        // MONITORENTER : object2
                        long l2 = l - ((RealConnection)object2).idleAtNs;
                        bl3 = l2 >= 10000000000L && bl2 ? Util.isHealthy(socket, realBufferedSource) : true;
                    }
                    break block8;
                    catch (Throwable throwable) {
                        // MONITOREXIT : object
                        throw throwable;
                    }
                }
                bl3 = false;
            }
            if (bl3) {
                return object;
            }
            ((RealConnection)object).noNewExchanges$okhttp();
            if (this.nextRouteToTry != null || ((object = this.routeSelection) == null ? true : ((RouteSelector$Selection)object).hasNext())) continue;
            object = this.routeSelector;
            boolean bl4 = object == null || ((RouteSelector)object).nextProxyIndex < ((RouteSelector)object).proxies.size() || ((RouteSelector)object).postponedRoutes.isEmpty() ^ true;
            if (!bl4) throw new IOException("exhausted all routes");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final RealConnection findConnection(int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        RealConnection realConnection;
        block22: {
            RealConnection realConnection2;
            Object object2;
            Object object3;
            block23: {
                block25: {
                    block24: {
                        if (this.call.isCanceled()) throw new IOException("Canceled");
                        object3 = this.call.getConnection();
                        if (object3 == null) break block23;
                        RealConnection realConnection3 = object3;
                        object2 = null;
                        // MONITORENTER : realConnection3
                        if (realConnection3.getNoNewExchanges()) break block24;
                        HttpUrl httpUrl = ((RealConnection)object3).route().address().url();
                        Intrinsics.checkNotNullParameter(httpUrl, "url");
                        HttpUrl httpUrl2 = this.address.url;
                        boolean bl2 = httpUrl.port == httpUrl2.port && Intrinsics.areEqual(httpUrl.host, httpUrl2.host);
                        if (bl2) break block25;
                    }
                    object2 = this.call.releaseConnectionNoEvents$okhttp();
                }
                RealConnection realConnection4 = object3;
                if (this.call.getConnection() != null) {
                    if (!(object2 == null)) throw new IllegalStateException("Check failed.".toString());
                    return object3;
                }
                if (object2 != null) {
                    Util.closeQuietly((Socket)object2);
                }
                object2 = this.eventListener;
                object2.getClass();
                EventListener.connectionReleased(this.call, (RealConnection)object3);
            }
            this.refusedStreamCount = 0;
            this.connectionShutdownCount = 0;
            this.otherFailureCount = 0;
            if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, null, false)) {
                RealConnection realConnection5 = this.call.getConnection();
                Intrinsics.checkNotNull(realConnection5);
                EventListener eventListener = this.eventListener;
                eventListener.getClass();
                EventListener.connectionAcquired(this.call, realConnection5);
                return realConnection5;
            }
            object3 = this.nextRouteToTry;
            if (object3 != null) {
                object2 = null;
                this.nextRouteToTry = null;
            } else {
                object3 = this.routeSelection;
                if (object3 != null && ((RouteSelector$Selection)object3).hasNext()) {
                    object2 = null;
                    RouteSelector$Selection routeSelector$Selection = this.routeSelection;
                    Intrinsics.checkNotNull(routeSelector$Selection);
                    object3 = routeSelector$Selection.next();
                } else {
                    object3 = this.routeSelector;
                    if (object3 == null) {
                        RouteSelector routeSelector;
                        object3 = routeSelector;
                        routeSelector = new RouteSelector(this.address, this.call.getClient().getRouteDatabase(), this.call, this.eventListener);
                        this.routeSelector = object3;
                    }
                    this.routeSelection = object3 = ((RouteSelector)object3).next();
                    object2 = ((RouteSelector$Selection)object3).getRoutes();
                    if (this.call.isCanceled()) throw new IOException("Canceled");
                    if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, (List)object2, false)) {
                        RealConnection realConnection6 = this.call.getConnection();
                        Intrinsics.checkNotNull(realConnection6);
                        EventListener eventListener = this.eventListener;
                        eventListener.getClass();
                        EventListener.connectionAcquired(this.call, realConnection6);
                        return realConnection6;
                    }
                    object3 = ((RouteSelector$Selection)object3).next();
                }
            }
            realConnection = realConnection2;
            realConnection(this.connectionPool, (Route)object3);
            this.call.setConnectionToCancel(realConnection);
            object = this.call;
            EventListener eventListener = this.eventListener;
            realConnection2.connect(n, n2, n3, n4, bl, (RealCall)object, eventListener);
            this.call.getClient().getRouteDatabase().connected(realConnection.route());
            if (!this.connectionPool.callAcquirePooledConnection(this.address, this.call, (List)object2, true)) break block22;
            object = this.call.getConnection();
            Intrinsics.checkNotNull(object);
            this.nextRouteToTry = object3;
            Util.closeQuietly(realConnection.socket());
            eventListener = this.eventListener;
            eventListener.getClass();
            EventListener.connectionAcquired(this.call, (RealConnection)object);
            return object;
        }
        RealConnection realConnection7 = realConnection;
        // MONITORENTER : realConnection7
        this.connectionPool.put(realConnection);
        this.call.acquireConnectionNoEvents(realConnection);
        object = this.eventListener;
        object.getClass();
        EventListener.connectionAcquired(this.call, realConnection);
        return realConnection7;
        finally {
            this.call.setConnectionToCancel(null);
        }
    }
}

