/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal.AbstractJsonLexer;
import com.apollographql.apollo3.relocated.kotlinx.serialization.json.internal.AbstractJsonLexerKt;

public final class StringJsonLexer
extends AbstractJsonLexer {
    public final String source;

    public StringJsonLexer(String string) {
        Intrinsics.checkNotNullParameter(string, "source");
        this.source = string;
    }

    @Override
    public final int prefetchOrEof(int n) {
        if (n >= this.source.length()) {
            n = -1;
        }
        return n;
    }

    @Override
    public final byte consumeNextToken() {
        byte by;
        String string = this.source;
        while ((by = this.currentPosition) != -1 && by < string.length()) {
            by = this.currentPosition;
            this.currentPosition = by + 1;
            byte by2 = AbstractJsonLexerKt.charToTokenClass(string.charAt(by));
            by = by2;
            if (by2 == 3) continue;
            return by;
        }
        return 10;
    }

    @Override
    public final boolean tryConsumeComma() {
        int n = this.skipWhitespaces();
        if (n != this.source.length() && n != -1) {
            if (this.source.charAt(n) == ',') {
                ++this.currentPosition;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public final boolean canConsumeValue() {
        int n = this.currentPosition;
        if (n == -1) {
            return false;
        }
        while (n < this.source.length()) {
            char c = this.source.charAt(n);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                this.currentPosition = n;
                return AbstractJsonLexer.isValidValueStart(c);
            }
            ++n;
        }
        this.currentPosition = n;
        return false;
    }

    @Override
    public final int skipWhitespaces() {
        char c;
        int n = this.currentPosition;
        if (n == -1) {
            return n;
        }
        while (n < this.source.length() && ((c = this.source.charAt(n)) == ' ' || c == '\n' || c == '\r' || c == '\t')) {
            ++n;
        }
        this.currentPosition = n;
        return n;
    }

    @Override
    public final void consumeNextToken(char c) {
        if (this.currentPosition != -1) {
            String string = this.source;
            while (this.currentPosition < string.length()) {
                int n = this.currentPosition;
                this.currentPosition = n + 1;
                char c2 = string.charAt(n);
                n = c2;
                if (c2 == ' ' || n == 10 || n == 13 || n == 9) continue;
                if (n == c) {
                    return;
                }
                this.unexpectedToken(c);
                throw null;
            }
            this.unexpectedToken(c);
            throw null;
        }
        this.unexpectedToken(c);
        throw null;
    }

    @Override
    public final String consumeKeyString() {
        StringJsonLexer stringJsonLexer = string;
        stringJsonLexer.consumeNextToken('\"');
        int n = stringJsonLexer.currentPosition;
        int n2 = StringsKt__StringsKt.indexOf$default((CharSequence)stringJsonLexer.source, '\"', n, false, 4);
        if (n2 != -1) {
            for (int i = n; i < n2; ++i) {
                if (((StringJsonLexer)((Object)string)).source.charAt(i) != '\\') continue;
                StringJsonLexer stringJsonLexer2 = string;
                String string = stringJsonLexer2.source;
                return stringJsonLexer2.consumeString(string, stringJsonLexer2.currentPosition, i);
            }
            ((AbstractJsonLexer)((Object)string)).currentPosition = n2 + 1;
            String string = ((StringJsonLexer)((Object)string)).source.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        ((AbstractJsonLexer)((Object)string)).fail$kotlinx_serialization_json((byte)1);
        throw null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final String consumeLeadingMatchingValue(String string, boolean bl) {
        int n;
        block6: {
            StringJsonLexer stringJsonLexer = this;
            Intrinsics.checkNotNullParameter(string, "keyToMatch");
            n = stringJsonLexer.currentPosition;
            try {
                String string2;
                if (stringJsonLexer.consumeNextToken() != 6) {
                    this.currentPosition = n;
                    return null;
                }
                String string3 = string2 = bl ? this.consumeKeyString() : this.consumeStringLenientNotNull();
                if (!Intrinsics.areEqual(string2, string)) break block6;
                if (this.consumeNextToken() != 5) {
                    this.currentPosition = n;
                    return null;
                }
                string = bl ? this.consumeString() : this.consumeStringLenientNotNull();
                this.currentPosition = n;
                return string;
            }
            catch (Throwable throwable) {
                this.currentPosition = n;
                throw throwable;
            }
        }
        this.currentPosition = n;
        return null;
    }

    @Override
    public final CharSequence getSource() {
        return this.source;
    }
}

