/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okio;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.kotlin.text.Charsets;
import com.apollographql.apollo3.relocated.kotlin.text.StringsKt__StringsJVMKt;
import com.apollographql.apollo3.relocated.okio.Buffer$UnsafeCursor;
import com.apollographql.apollo3.relocated.okio.Buffer$inputStream$1;
import com.apollographql.apollo3.relocated.okio.BufferedSink;
import com.apollographql.apollo3.relocated.okio.BufferedSource;
import com.apollographql.apollo3.relocated.okio.ByteString;
import com.apollographql.apollo3.relocated.okio.Options;
import com.apollographql.apollo3.relocated.okio.PeekSource;
import com.apollographql.apollo3.relocated.okio.RealBufferedSource;
import com.apollographql.apollo3.relocated.okio.Segment;
import com.apollographql.apollo3.relocated.okio.SegmentPool;
import com.apollographql.apollo3.relocated.okio.SegmentedByteString;
import com.apollographql.apollo3.relocated.okio.Source;
import com.apollographql.apollo3.relocated.okio.Timeout;
import com.apollographql.apollo3.relocated.okio._UtilKt;
import com.apollographql.apollo3.relocated.okio.internal._BufferKt;
import com.apollographql.apollo3.relocated.okio.internal._ByteStringKt;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class Buffer
implements BufferedSource,
BufferedSink,
Cloneable,
ByteChannel {
    public Segment head;
    public long size;

    public final long size() {
        return this.size;
    }

    @Override
    public final Buffer getBuffer() {
        return this;
    }

    @Override
    public final boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public final void require(long l) {
        if (this.size >= l) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public final boolean request(long l) {
        return this.size >= l;
    }

    @Override
    public final InputStream inputStream() {
        return new Buffer$inputStream$1(this);
    }

    @Override
    public final byte readByte() {
        if (this.size != 0L) {
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int by = segment.pos;
            int n = segment.limit;
            byte[] byArray = segment.data;
            int n2 = by + 1;
            byte by2 = byArray[by];
            --this.size;
            if (n2 == n) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n2;
            }
            return by2;
        }
        throw new EOFException();
    }

    public final byte getByte(long l) {
        Buffer buffer = this;
        _UtilKt.checkOffsetAndCount(buffer.size, l, 1L);
        Segment segment = buffer.head;
        if (segment != null) {
            byte by;
            long l2 = this.size;
            if (l2 - l < l) {
                while (l2 > l) {
                    segment = segment.prev;
                    Intrinsics.checkNotNull(segment);
                    l2 -= (long)(segment.limit - segment.pos);
                }
                by = segment.data[(int)((long)segment.pos + l - l2)];
            } else {
                int n;
                long l3;
                l2 = 0L;
                while ((l3 = l2 + (long)(segment.limit - (n = segment.pos))) <= l) {
                    segment = segment.next;
                    Intrinsics.checkNotNull(segment);
                    l2 = l3;
                }
                by = segment.data[(int)((long)n + l - l2)];
            }
            return by;
        }
        Intrinsics.checkNotNull(null);
        throw null;
    }

    @Override
    public final short readShort() {
        if (this.size >= 2L) {
            short s;
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int n = segment.pos;
            int n2 = segment.limit;
            if (n2 - n < 2) {
                s = (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            } else {
                byte[] byArray = segment.data;
                int n3 = (segment.data[n++] & 0xFF) << 8;
                int n4 = n + 1;
                n = n3 | byArray[n] & 0xFF;
                this.size -= 2L;
                if (n4 == n2) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                } else {
                    segment.pos = n4;
                }
                s = (short)n;
            }
            return s;
        }
        throw new EOFException();
    }

    @Override
    public final int readInt() {
        if (this.size >= 4L) {
            int n;
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int n2 = segment.pos;
            int n3 = segment.limit;
            if ((long)(n3 - n2) < 4L) {
                n = (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            } else {
                byte[] byArray = segment.data;
                int n4 = (segment.data[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8;
                int n5 = n2 + 1;
                n2 = n4 | byArray[n2] & 0xFF;
                this.size -= 4L;
                if (n5 == n3) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                } else {
                    segment.pos = n5;
                }
                n = n2;
            }
            return n;
        }
        throw new EOFException();
    }

    @Override
    public final long readLong() {
        if (this.size >= 8L) {
            long l;
            Segment segment = this.head;
            Intrinsics.checkNotNull(segment);
            int n = segment.pos;
            int n2 = segment.limit;
            if ((long)(n2 - n) < 8L) {
                l = ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
            } else {
                byte[] byArray = segment.data;
                long l2 = ((long)segment.data[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8;
                int n3 = n + 1;
                long l3 = l2 | (long)byArray[n] & 0xFFL;
                this.size -= 8L;
                if (n3 == n2) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                } else {
                    segment.pos = n3;
                }
                l = l3;
            }
            return l;
        }
        throw new EOFException();
    }

    public final short readShortLe() {
        int n = this.readShort() & 0xFFFF;
        return (short)((n & 0xFF00) >>> 8 | (n & 0xFF) << 8);
    }

    @Override
    public final int readIntLe() {
        int n = this.readInt();
        return (n & 0xFF000000) >>> 24 | (n & 0xFF0000) >>> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
    }

    @Override
    public final long readLongLe() {
        long l = this.readLong();
        return (l & 0xFF00000000000000L) >>> 56 | (l & 0xFF000000000000L) >>> 40 | (l & 0xFF0000000000L) >>> 24 | (l & 0xFF00000000L) >>> 8 | (l & 0xFF000000L) << 8 | (l & 0xFF0000L) << 24 | (l & 0xFF00L) << 40 | (l & 0xFFL) << 56;
    }

    @Override
    public final long readHexadecimalUnsignedLong() {
        block8: {
            if (((Buffer)object).size == 0L) break block8;
            long l = 0L;
            int n = 0;
            boolean bl = false;
            do {
                Segment segment = ((Buffer)object).head;
                Intrinsics.checkNotNull(segment);
                byte[] byArray = segment.data;
                int n2 = segment.pos;
                int n3 = segment.limit;
                while (n2 < n3) {
                    String string;
                    Object object;
                    byte by;
                    block12: {
                        Buffer buffer;
                        int n4;
                        block10: {
                            block11: {
                                block9: {
                                    by = byArray[n2];
                                    n4 = 48;
                                    if (by < n4 || by > (byte)57) break block9;
                                    n4 = by - n4;
                                    break block10;
                                }
                                n4 = 97;
                                if (by >= n4 && by <= (byte)102) break block11;
                                byte by2 = (byte)65;
                                n4 = by2;
                                if (by < by2 || by > (byte)70) break block12;
                            }
                            n4 = by - n4 + 10;
                        }
                        if ((l & 0xF000000000000000L) == 0L) {
                            l = l << 4 | (long)n4;
                            ++n2;
                            ++n;
                            continue;
                        }
                        object = buffer;
                        ((Buffer)object)();
                        object = buffer.writeHexadecimalUnsignedLong(l).writeByte(by);
                        throw new NumberFormatException("Number too large: ".concat(((Buffer)object).readUtf8()));
                    }
                    if (n != 0) {
                        bl = true;
                        break;
                    }
                    char[] cArray = new char[2];
                    object = cArray;
                    Object object2 = _ByteStringKt.HEX_DIGIT_CHARS;
                    object[0] = object2[by >> 4 & 0xF];
                    cArray[1] = _ByteStringKt.HEX_DIGIT_CHARS[by & 0xF];
                    object2 = string;
                    string = new String((char[])object);
                    throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x".concat((String)object2));
                }
                if (n2 == n3) {
                    ((Buffer)object).head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.pos = n2;
            } while (!bl && ((Buffer)object).head != null);
            ((Buffer)object).size -= (long)n;
            return l;
        }
        throw new EOFException();
    }

    public final ByteString readByteString() {
        Buffer buffer = this;
        return buffer.readByteString(buffer.size);
    }

    @Override
    public final ByteString readByteString(long l) {
        StringBuilder stringBuilder;
        Object object;
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            if (((Buffer)object).size >= l) {
                if (l >= 4096L) {
                    Object object2 = object;
                    object = ((Buffer)object).snapshot((int)l);
                    ((Buffer)object2).skip(l);
                } else {
                    ByteString byteString;
                    ByteString byteString2 = byteString;
                    byteString = new ByteString(((Buffer)object).readByteArray(l));
                    object = byteString2;
                }
                return object;
            }
            throw new EOFException();
        }
        object = stringBuilder;
        ((StringBuilder)object)("byteCount: ");
        object = stringBuilder.append(l).toString();
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public final int select(Options options) {
        Intrinsics.checkNotNullParameter(options, "options");
        int n = _BufferKt.selectPrefix(this, options, false);
        if (n == -1) {
            n = -1;
        } else {
            this.skip(options.byteStrings[n].getSize$okio());
        }
        return n;
    }

    @Override
    public final void readFully(Buffer buffer, long l) {
        Intrinsics.checkNotNullParameter(buffer, "sink");
        long l2 = this.size;
        if (l2 >= l) {
            buffer.write(this, l);
            return;
        }
        buffer.write(this, l2);
        throw new EOFException();
    }

    @Override
    public final String readUtf8() {
        Buffer buffer = this;
        return buffer.readString(buffer.size, Charsets.UTF_8);
    }

    public final String readString(long l, Charset charset) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(charset, "charset");
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            if (((Buffer)object).size >= l) {
                int n;
                String string;
                if (l == 0L) {
                    return "";
                }
                Segment segment = ((Buffer)object).head;
                Intrinsics.checkNotNull(segment);
                int n2 = segment.pos;
                if ((long)n2 + l > (long)segment.limit) {
                    return new String(((Buffer)object).readByteArray(l), charset);
                }
                String string2 = string;
                byte[] byArray = segment.data;
                int n3 = (int)l;
                string = new String(byArray, n2, n3, charset);
                segment.pos = n = segment.pos + n3;
                ((Buffer)object).size -= l;
                if (n == segment.limit) {
                    ((Buffer)object).head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                return string2;
            }
            throw new EOFException();
        }
        Object object = stringBuilder;
        ((StringBuilder)object)("byteCount: ");
        object = stringBuilder.append(l).toString();
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public final String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public final String readUtf8LineStrict(long l) {
        StringBuilder stringBuilder;
        block2: {
            Buffer buffer;
            block5: {
                String string;
                block4: {
                    long l2;
                    byte by;
                    block3: {
                        if (!(l >= 0L)) break block2;
                        by = (byte)10;
                        l2 = l == Long.MAX_VALUE ? Long.MAX_VALUE : l + 1L;
                        long l3 = ((Buffer)object).indexOf(by, 0L, l2);
                        if (l3 == -1L) break block3;
                        string = _BufferKt.readUtf8Line((Buffer)object, l3);
                        break block4;
                    }
                    if (l2 >= ((Buffer)object).size || ((Buffer)object).getByte(l2 - 1L) != (byte)13 || ((Buffer)object).getByte(l2) != by) break block5;
                    string = _BufferKt.readUtf8Line((Buffer)object, l2);
                }
                return string;
            }
            Object object = object;
            Buffer buffer2 = buffer;
            buffer = new Buffer();
            long l4 = ((Buffer)object).size;
            l4 = Math.min((long)32, l4);
            ((Buffer)object).copyTo(0L, l4, buffer2);
            Buffer buffer3 = buffer2;
            throw new EOFException("\\n not found: limit=" + Math.min(((Buffer)object).size, l) + " content=" + buffer3.readByteString(buffer3.size).hex() + '\u2026');
        }
        Object object = stringBuilder;
        ((StringBuilder)object)("limit < 0: ");
        object = stringBuilder.append(l).toString();
        throw new IllegalArgumentException(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final int readUtf8CodePoint() {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            block8: {
                block10: {
                    block9: {
                        block7: {
                            if (((Buffer)object).size == 0L) throw new EOFException();
                            n4 = ((Buffer)object).getByte(0L);
                            if ((n4 & 0x80) != 0) break block7;
                            n3 = n4 & 0x7F;
                            n2 = 1;
                            n = 0;
                            break block8;
                        }
                        if ((n4 & 0xE0) != 192) break block9;
                        n3 = n4 & 0x1F;
                        n2 = 2;
                        n = 128;
                        break block8;
                    }
                    if ((n4 & 0xF0) != 224) break block10;
                    n3 = n4 & 0xF;
                    n2 = 3;
                    n = 2048;
                    break block8;
                }
                if ((n4 & 0xF8) != 240) break block11;
                n3 = n4 & 7;
                n2 = 4;
                n = 65536;
            }
            long l = n2;
            if (((Buffer)object).size >= l) {
                for (n4 = 1; n4 < n2; ++n4) {
                    long l2 = n4;
                    byte by = ((Buffer)object).getByte(l2);
                    if ((by & 0xC0) == 128) {
                        n3 = n3 << 6 | by & 0x3F;
                        continue;
                    }
                    ((Buffer)object).skip(l2);
                    return 65533;
                }
                ((Buffer)object).skip(l);
                if (n3 > 0x10FFFF) return 65533;
                if (55296 <= n3 && n3 < 57344) {
                    return 65533;
                }
                boolean bl = false;
                if (bl) return 65533;
                if (n3 >= n) return n3;
                return 65533;
            }
            char[] cArray = new char[2];
            Object object = cArray;
            char[] cArray2 = _ByteStringKt.HEX_DIGIT_CHARS;
            object[0] = cArray2[n4 >> 4 & 0xF];
            cArray[1] = _ByteStringKt.HEX_DIGIT_CHARS[n4 & 0xF];
            throw new EOFException("size < " + n2 + ": " + ((Buffer)object).size + " (to read code point prefixed 0x" + new String((char[])object) + ')');
        }
        ((Buffer)object).skip(1L);
        return 65533;
    }

    public final byte[] readByteArray(long l) {
        StringBuilder stringBuilder;
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            if (((Buffer)object).size >= l) {
                byte[] byArray = new byte[(int)l];
                ((Buffer)object).readFully(byArray);
                return byArray;
            }
            throw new EOFException();
        }
        Object object = stringBuilder;
        ((StringBuilder)object)("byteCount: ");
        object = stringBuilder.append(l).toString();
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public final void readFully(byte[] byArray) {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = this.read(byArray, i, byArray.length - i);
            if (n != -1) {
                continue;
            }
            throw new EOFException();
        }
    }

    public final int read(byte[] byArray, int n, int n2) {
        int n3;
        Intrinsics.checkNotNullParameter(byArray, "sink");
        long l = n;
        long l2 = n2;
        _UtilKt.checkOffsetAndCount(byArray.length, l, l2);
        Segment segment = this.head;
        if (segment == null) {
            n3 = -1;
        } else {
            int n4;
            Segment segment2 = segment;
            n2 = Math.min(n2, segment.limit - segment.pos);
            byte[] byArray2 = segment2.data;
            int n5 = segment.pos;
            Intrinsics.checkNotNullParameter(byArray2, "<this>");
            int n6 = n5 + n2 - n5;
            System.arraycopy(segment2.data, n5, byArray, n, n6);
            segment.pos = n4 = segment2.pos + n2;
            this.size -= (long)n2;
            if (n4 == segment.limit) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            n3 = n2;
        }
        return n3;
    }

    @Override
    public final int read(ByteBuffer byteBuffer) {
        int n;
        Intrinsics.checkNotNullParameter(byteBuffer, "sink");
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        int n2 = Math.min(byteBuffer.remaining(), segment.limit - segment.pos);
        byte[] byArray = segment2.data;
        byteBuffer.put(byArray, segment2.pos, n2);
        segment.pos = n = segment.pos + n2;
        this.size -= (long)n2;
        if (n == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n2;
    }

    public final void clear() {
        Buffer buffer = this;
        buffer.skip(buffer.size);
    }

    @Override
    public final void skip(long l) {
        while (l > 0L) {
            Segment segment = this.head;
            if (segment != null) {
                int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
                long l2 = n;
                this.size -= l2;
                l2 = l - l2;
                segment.pos = n = segment.pos + n;
                if (n == segment.limit) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                l = l2;
                continue;
            }
            throw new EOFException();
        }
    }

    @Override
    public final Buffer writeUtf8(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "string");
        return this.writeUtf8(0, string2.length(), string);
    }

    @Override
    public final Buffer writeUtf8CodePoint(int n) {
        String string;
        StringBuilder stringBuilder;
        block11: {
            block7: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                if (n >= 128) break block6;
                                ((Buffer)this).writeByte(n);
                                break block7;
                            }
                            if (n >= 2048) break block8;
                            Buffer buffer = this;
                            Segment segment = buffer.writableSegment$okio(2);
                            byte[] byArray = segment.data;
                            int n2 = segment.limit;
                            byArray[n2] = (byte)(n >> 6 | 0xC0);
                            byArray[n2 + 1] = (byte)(n & 0x3F | 0x80);
                            segment.limit = n2 + 2;
                            buffer.size += 2L;
                            break block7;
                        }
                        if (!(55296 <= n && n < 57344)) break block9;
                        ((Buffer)this).writeByte(63);
                        break block7;
                    }
                    if (n >= 65536) break block10;
                    Buffer buffer = this;
                    Segment segment = buffer.writableSegment$okio(3);
                    byte[] byArray = segment.data;
                    int n3 = segment.limit;
                    byArray[n3] = (byte)(n >> 12 | 0xE0);
                    byArray[n3 + 1] = (byte)(n >> 6 & 0x3F | 0x80);
                    byArray[n3 + 2] = (byte)(n & 0x3F | 0x80);
                    segment.limit = n3 + 3;
                    buffer.size += 3L;
                    break block7;
                }
                if (n > 0x10FFFF) break block11;
                Buffer buffer = this;
                Segment segment = buffer.writableSegment$okio(4);
                byte[] byArray = segment.data;
                int n4 = segment.limit;
                byArray[n4] = (byte)(n >> 18 | 0xF0);
                byArray[n4 + 1] = (byte)(n >> 12 & 0x3F | 0x80);
                byArray[n4 + 2] = (byte)(n >> 6 & 0x3F | 0x80);
                byArray[n4 + 3] = (byte)(n & 0x3F | 0x80);
                segment.limit = n4 + 4;
                buffer.size += 4L;
            }
            return this;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("Unexpected code point: 0x");
        if (n != 0) {
            int n5 = 8;
            char[] cArray = new char[8];
            char[] cArray2 = cArray;
            char[] cArray3 = _ByteStringKt.HEX_DIGIT_CHARS;
            cArray2[0] = cArray3[n >> 28 & 0xF];
            cArray2[1] = cArray3[n >> 24 & 0xF];
            cArray2[2] = cArray3[n >> 20 & 0xF];
            cArray2[3] = cArray3[n >> 16 & 0xF];
            cArray2[4] = cArray3[n >> 12 & 0xF];
            cArray2[5] = cArray3[n >> 8 & 0xF];
            cArray2[6] = cArray3[n >> 4 & 0xF];
            cArray[7] = _ByteStringKt.HEX_DIGIT_CHARS[n & 0xF];
            for (n = 0; n < n5 && cArray2[n] == '0'; ++n) {
            }
            string = StringsKt__StringsJVMKt.concatToString(cArray2, n, n5);
        } else {
            string = "0";
        }
        Object object = this;
        ((IllegalArgumentException)object)(stringBuilder2.append(string).toString());
        throw object;
    }

    public final Buffer write(byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter(byArray, "source");
        long l = n;
        long l2 = n2;
        _UtilKt.checkOffsetAndCount(byArray.length, l, l2);
        n2 = n + n2;
        while (n < n2) {
            Segment segment = this.writableSegment$okio(1);
            int n3 = n;
            Segment segment2 = segment;
            int n4 = Math.min(n2 - n, 8192 - segment.limit);
            byte[] byArray2 = segment2.data;
            int n5 = segment2.limit;
            int n6 = n3 + n4;
            Intrinsics.checkNotNullParameter(byArray2, "destination");
            n = n6 - n;
            System.arraycopy(byArray, n3, byArray2, n5, n);
            segment.limit += n4;
            n = n6;
        }
        Buffer buffer = this;
        buffer.size += l2;
        return buffer;
    }

    @Override
    public final int write(ByteBuffer byteBuffer) {
        int n;
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkNotNullParameter(byteBuffer2, "source");
        int n2 = n = byteBuffer2.remaining();
        while (n2 > 0) {
            Segment segment = this.writableSegment$okio(1);
            Object object = segment;
            int n3 = n2;
            Segment segment2 = object;
            n2 = Math.min(n2, 8192 - ((Segment)object).limit);
            object = segment2.data;
            byteBuffer.get((byte[])object, segment2.limit, n2);
            int n4 = n3 - n2;
            segment.limit += n2;
            n2 = n4;
        }
        this.size += (long)n;
        return n;
    }

    @Override
    public final long writeAll(Source source2) {
        long l;
        Intrinsics.checkNotNullParameter(source2, "source");
        long l2 = 0L;
        while ((l = source2.read(this, 8192L)) != -1L) {
            l2 += l;
        }
        return l2;
    }

    @Override
    public final Buffer writeByte(int n) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment$okio(1);
        int n2 = segment.limit;
        segment.limit = n2 + 1;
        segment.data[n2] = (byte)n;
        ++buffer.size;
        return buffer;
    }

    @Override
    public final Buffer writeShort(int n) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment$okio(2);
        int n2 = n;
        int n3 = segment.limit;
        n = n3 + 1;
        segment.data[n3] = (byte)(n2 >>> 8 & 0xFF);
        n3 = n + 1;
        segment.data[n] = (byte)(n & 0xFF);
        segment.limit = n3;
        buffer.size += 2L;
        return buffer;
    }

    @Override
    public final Buffer writeInt(int n) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment$okio(4);
        byte[] byArray = segment.data;
        int n2 = n;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = segment.limit;
        n = n6 + 1;
        byArray[n6] = (byte)(n5 >>> 24 & 0xFF);
        n6 = n + 1;
        byArray[n] = (byte)(n4 >>> 16 & 0xFF);
        n = n6 + 1;
        byArray[n6] = (byte)(n3 >>> 8 & 0xFF);
        n6 = n + 1;
        segment.data[n] = (byte)(n2 & 0xFF);
        segment.limit = n6;
        buffer.size += 4L;
        return buffer;
    }

    @Override
    public final Buffer writeHexadecimalUnsignedLong(long l) {
        if (l == 0L) {
            Buffer buffer = buffer.writeByte(48);
        } else {
            long l2 = l;
            long l3 = l2 | l2 >>> 1;
            long l4 = l3 | l3 >>> 2;
            long l5 = l4 | l4 >>> 4;
            long l6 = l5 | l5 >>> 8;
            long l7 = l6 | l6 >>> 16;
            long l8 = l7 | l7 >>> 32;
            long l9 = l8 - (l8 >>> 1 & 0x5555555555555555L);
            l9 = (l9 >>> 2 & 0x3333333333333333L) + (l9 & 0x3333333333333333L);
            long l10 = (l9 >>> 4) + l9 & 0xF0F0F0F0F0F0F0FL;
            long l11 = l10 + (l10 >>> 8);
            l9 = l11 + (l11 >>> 16);
            int n = (int)(((l9 & 0x3FL) + (l9 >>> 32 & 0x3FL) + (long)3) / (long)4);
            Segment segment = buffer.writableSegment$okio(n);
            byte[] byArray = segment.data;
            int n2 = segment.limit;
            for (int i = n2 + n - 1; i >= n2; --i) {
                byArray[i] = _BufferKt.HEX_DIGIT_BYTES[(int)(l & 0xFL)];
                l >>>= 4;
            }
            segment.limit += n;
            buffer.size += (long)n;
        }
        return buffer;
    }

    public final Segment writableSegment$okio(int n) {
        if (n >= 1 && n <= 8192) {
            Object object;
            Segment segment = ((Buffer)object2).head;
            if (segment == null) {
                object = SegmentPool.take();
                ((Buffer)object2).head = object;
                SegmentPool.take().prev = object;
                SegmentPool.take().next = object;
            } else {
                Segment segment2 = segment;
                Intrinsics.checkNotNull(segment2);
                Object object2 = segment2.prev;
                Intrinsics.checkNotNull(object2);
                object = ((Segment)object2).limit + n <= 8192 && ((Segment)object2).owner ? object2 : (object2 = ((Segment)object2).push(SegmentPool.take()));
            }
            return object;
        }
        throw new IllegalArgumentException("unexpected capacity".toString());
    }

    @Override
    public final void write(Buffer buffer, long l) {
        block14: {
            Buffer buffer2 = buffer;
            Intrinsics.checkNotNullParameter(buffer2, "source");
            if (!(buffer2 != segment5)) break block14;
            _UtilKt.checkOffsetAndCount(buffer.size, 0L, l);
            while (l > 0L) {
                block17: {
                    long l2;
                    block16: {
                        Segment segment;
                        int n;
                        int n2;
                        Segment segment2;
                        block15: {
                            Segment segment3 = buffer.head;
                            Intrinsics.checkNotNull(segment3);
                            int n3 = segment3.limit;
                            Segment segment4 = buffer.head;
                            Intrinsics.checkNotNull(segment4);
                            if (l < (long)(n3 - segment4.pos)) {
                                long l3;
                                segment2 = ((Buffer)((Object)segment5)).head;
                                segment2 = segment2 != null ? segment2.prev : null;
                                if (segment2 != null && segment2.owner && (l2 = l + (long)segment2.limit) - (l3 = (long)(segment2.shared ? 0 : segment2.pos)) <= 8192L) {
                                    Buffer buffer3 = segment5;
                                    Buffer buffer4 = buffer;
                                    Segment segment5 = buffer4.head;
                                    Intrinsics.checkNotNull(segment5);
                                    segment5.writeTo(segment2, (int)l);
                                    buffer4.size -= l;
                                    buffer3.size += l;
                                    break;
                                }
                                segment2 = buffer.head;
                                Intrinsics.checkNotNull(segment2);
                                int n4 = (int)l;
                                if (n4 > 0 && n4 <= segment2.limit - segment2.pos) {
                                    Segment segment6;
                                    if (n4 >= 1024) {
                                        Segment segment7;
                                        segment2.shared = true;
                                        segment6 = segment7;
                                        Segment segment8 = segment2;
                                        byte[] byArray = segment8.data;
                                        n2 = segment8.pos;
                                        n = segment8.limit;
                                        segment7 = new Segment(byArray, n2, n, true, false);
                                    } else {
                                        segment6 = SegmentPool.take();
                                        byte[] byArray = segment2.data;
                                        byte[] byArray2 = segment6.data;
                                        n = segment2.pos;
                                        Intrinsics.checkNotNullParameter(byArray, "<this>");
                                        Intrinsics.checkNotNullParameter(byArray2, "destination");
                                        int n5 = n + n4 - n;
                                        System.arraycopy(segment2.data, n, byArray2, 0, n5);
                                    }
                                    Segment segment9 = segment2;
                                    segment6.limit = segment6.pos + n4;
                                    segment9.pos += n4;
                                    Segment segment10 = segment9.prev;
                                    Intrinsics.checkNotNull(segment10);
                                    segment10.push(segment6);
                                    buffer.head = segment6;
                                } else {
                                    throw new IllegalArgumentException("byteCount out of range".toString());
                                }
                            }
                            segment2 = buffer.head;
                            Intrinsics.checkNotNull(segment2);
                            l2 = segment2.limit - segment2.pos;
                            buffer.head = segment2.pop();
                            segment = ((Buffer)((Object)segment5)).head;
                            if (segment != null) break block15;
                            Segment segment11 = ((Buffer)((Object)segment5)).head = segment2;
                            segment11.prev = segment2;
                            segment11.next = segment2;
                            break block16;
                        }
                        Segment segment12 = segment.prev;
                        Intrinsics.checkNotNull(segment12);
                        segment2 = segment12.push(segment2);
                        segment = segment2.prev;
                        if (!(segment != segment2)) break block17;
                        Segment segment13 = segment;
                        Intrinsics.checkNotNull(segment13);
                        if (segment13.owner) {
                            Segment segment14 = segment2;
                            int n6 = segment14.limit - segment2.pos;
                            Segment segment15 = segment14.prev;
                            Intrinsics.checkNotNull(segment15);
                            n2 = 8192 - segment15.limit;
                            Segment segment16 = segment14.prev;
                            Intrinsics.checkNotNull(segment16);
                            if (segment16.shared) {
                                n = 0;
                            } else {
                                Segment segment17 = segment2.prev;
                                Intrinsics.checkNotNull(segment17);
                                n = segment17.pos;
                            }
                            if (n6 <= n2 + n) {
                                Segment segment18 = segment2;
                                segment2 = segment18.prev;
                                Intrinsics.checkNotNull(segment2);
                                segment18.writeTo(segment2, n6);
                                segment18.pop();
                                SegmentPool.recycle(segment18);
                            }
                        }
                    }
                    buffer.size -= l2;
                    ((Buffer)((Object)segment5)).size += l2;
                    l -= l2;
                    continue;
                }
                throw new IllegalStateException("cannot compact".toString());
            }
            return;
        }
        throw new IllegalArgumentException("source == this".toString());
    }

    @Override
    public final long read(Buffer buffer, long l) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        if (l >= 0L) {
            long l2;
            long l3 = ((Buffer)object).size;
            if (l3 == 0L) {
                l2 = -1L;
            } else {
                if (l > l3) {
                    l = l3;
                }
                buffer.write((Buffer)object, l);
                l2 = l;
            }
            return l2;
        }
        Object object = stringBuilder;
        ((StringBuilder)object)("byteCount < 0: ");
        object = stringBuilder.append(l).toString();
        throw new IllegalArgumentException(object.toString());
    }

    /*
     * Unable to fully structure code
     */
    public final long indexOf(byte var1_1, long var2_2, long var4_4) {
        block11: {
            block10: {
                block12: {
                    if (!(0L <= var2_2 && var2_2 <= var4_4)) break block11;
                    var6_5 = this.size;
                    if (var4_4 > var6_5) {
                        var4_4 = var6_5;
                    }
                    if (var2_2 == var4_4) lbl-1000:
                    // 4 sources

                    {
                        while (true) {
                            v0 = -1L;
                            break block10;
                            break;
                        }
                    }
                    this = this.head;
                    if (this == null) ** GOTO lbl-1000
                    if (var6_5 - var2_2 >= var2_2) break block12;
                    while (var6_5 > var2_2) {
                        this = this.prev;
                        Intrinsics.checkNotNull(this);
                        var6_5 -= (long)(this.limit - this.pos);
                    }
                    while (true) {
                        if (var6_5 >= var4_4) ** GOTO lbl-1000
                        v1 = this;
                        var8_6 = v1.data;
                        var9_9 = (int)Math.min((long)v1.limit, (long)this.pos + var4_4 - var6_5);
                        for (var2_3 = (int)((long)(v627822).pos + var2_2 - var6_5); var2_3 < var9_9; ++var2_3) {
                            if (var8_6[var2_3] != var1_1) {
                                continue;
                            }
                            ** GOTO lbl45
                        }
                        this = this.next;
                        Intrinsics.checkNotNull(this);
                        var2_2 = var6_5 += (long)(this.limit - this.pos);
                    }
                }
                var6_5 = 0L;
                while ((var8_7 = var6_5 + (long)(this.limit - this.pos)) <= var2_2) {
                    this = this.next;
                    Intrinsics.checkNotNull(this);
                    var6_5 = var8_7;
                }
                block5: while (true) {
                    if (var6_5 < var4_4) ** break;
                    ** continue;
                    v2 = this;
                    var8_8 = v2.data;
                    var9_10 = (int)Math.min((long)v2.limit, (long)this.pos + var4_4 - var6_5);
                    for (var2_3 = (int)((long)(v627897).pos + var2_2 - var6_5); var2_3 < var9_10; ++var2_3) {
                        if (var8_8[var2_3] != var1_1) continue;
lbl45:
                        // 2 sources

                        v0 = (long)(var2_3 - this.pos) + var6_5;
                        break block5;
                    }
                    this = this.next;
                    Intrinsics.checkNotNull(this);
                    var2_2 = var6_5 += (long)(this.limit - this.pos);
                }
            }
            return v0;
        }
        this = "size=" + this.size + " fromIndex=" + var2_2 + " toIndex=" + var4_4;
        throw new IllegalArgumentException(this.toString());
    }

    @Override
    public final long indexOfElement(ByteString byteString) {
        Intrinsics.checkNotNullParameter(byteString, "targetBytes");
        return this.indexOfElement(0L, byteString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean rangeEquals(long l, ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "bytes");
        int n = 0;
        int n2 = byteString2.getSize$okio();
        if (l < 0L) return false;
        if (n2 < 0) return false;
        if (this.size - l < (long)n2) return false;
        if (byteString.getSize$okio() - n < n2) return false;
        int n3 = 0;
        while (n3 < n2) {
            if (this.getByte(l + (long)n3) != byteString.internalGet$okio(n + n3)) return false;
            ++n3;
        }
        return true;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final void close() {
    }

    @Override
    public final Timeout timeout() {
        return Timeout.NONE;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean equals(Object var1_1) {
        block8: {
            if (this == var1_1) lbl-1000:
            // 3 sources

            {
                while (true) {
                    v0 = true;
                    break block8;
                    break;
                }
            }
            if (!(var1_1 instanceof Buffer)) lbl-1000:
            // 3 sources

            {
                while (true) {
                    v0 = false;
                    break block8;
                    break;
                }
            }
            var2_2 = this.size;
            var1_1 = (Buffer)var1_1;
            if (var2_2 != var1_1.size) ** GOTO lbl-1000
            if (var2_2 == 0L) ** GOTO lbl-1000
            v1 = var1_1;
            var1_1 = this.head;
            Intrinsics.checkNotNull(var1_1);
            var2_3 = v1.head;
            Intrinsics.checkNotNull(var2_3);
            var3_4 = var1_1.pos;
            var4_5 = var2_3.pos;
            var5_6 = 0L;
            while (true) {
                if (var5_6 < this.size) ** break;
                ** continue;
                var7_7 = Math.min(var1_1.limit - var3_4, var2_3.limit - var4_5);
                for (var9_8 = 0L; var9_8 < var7_7; ++var9_8) {
                    if (var1_1.data[var3_4++] == var2_3.data[var4_5++]) continue;
                    ** continue;
                }
                if (var3_4 == var1_1.limit) {
                    var1_1 = var1_1.next;
                    Intrinsics.checkNotNull(var1_1);
                    var3_4 = var1_1.pos;
                }
                if (var4_5 == var2_3.limit) {
                    var2_3 = var2_3.next;
                    Intrinsics.checkNotNull(var2_3);
                    var4_5 = var2_3.pos;
                }
                var5_6 += var7_7;
            }
        }
        return v0;
    }

    public final int hashCode() {
        int n;
        Segment segment = this.head;
        if (segment == null) {
            n = 0;
        } else {
            int n2 = 1;
            do {
                int n3 = segment.limit;
                for (int i = (v630894).pos; i < n3; ++i) {
                    n2 = n2 * 31 + segment.data[i];
                }
                segment = segment.next;
                Intrinsics.checkNotNull(segment);
            } while (segment != this.head);
            n = n2;
        }
        return n;
    }

    public final String toString() {
        long l = ((Buffer)((Object)string)).size;
        if (l <= Integer.MAX_VALUE) {
            return ((Buffer)((Object)string)).snapshot((int)l).toString();
        }
        String string = "size > Int.MAX_VALUE: " + ((Buffer)((Object)string)).size;
        throw new IllegalStateException(string.toString());
    }

    public final ByteString snapshot(int n) {
        Object object;
        if (n == 0) {
            object = ByteString.EMPTY;
        } else {
            SegmentedByteString segmentedByteString;
            int n2;
            Buffer buffer = object;
            long l = n;
            _UtilKt.checkOffsetAndCount(buffer.size, 0L, l);
            int n3 = 0;
            int n4 = 0;
            Segment segment = buffer.head;
            while (n3 < n) {
                Segment segment2 = segment;
                Intrinsics.checkNotNull(segment2);
                n2 = segment2.limit;
                int n5 = segment.pos;
                if (n2 != n5) {
                    n3 = n2 - n5 + n3;
                    ++n4;
                    segment = segment.next;
                    continue;
                }
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            Object object2 = object;
            int n6 = n4;
            object = new byte[n6][];
            int[] nArray = new int[n6 * 2];
            int n7 = 0;
            n2 = 0;
            Segment segment3 = ((Buffer)object2).head;
            while (n7 < n) {
                Segment segment4 = segment3;
                Intrinsics.checkNotNull(segment4);
                object[n2] = segment4.data;
                n7 = segment3.limit - segment3.pos + n7;
                nArray[n2] = Math.min(n7, n);
                int n8 = n2 + n4;
                nArray[n8] = segment3.pos;
                segment3.shared = true;
                ++n2;
                segment3 = segment3.next;
            }
            SegmentedByteString segmentedByteString2 = segmentedByteString;
            segmentedByteString = new SegmentedByteString((byte[][])object, nArray);
            object = segmentedByteString2;
        }
        return object;
    }

    public final Buffer$UnsafeCursor readAndWriteUnsafe(Buffer$UnsafeCursor buffer$UnsafeCursor) {
        Buffer$UnsafeCursor buffer$UnsafeCursor2 = buffer$UnsafeCursor;
        Intrinsics.checkNotNullParameter(buffer$UnsafeCursor2, "unsafeCursor");
        if (buffer$UnsafeCursor2 == _UtilKt.DEFAULT__new_UnsafeCursor) {
            Buffer$UnsafeCursor buffer$UnsafeCursor3;
            buffer$UnsafeCursor = buffer$UnsafeCursor3;
            buffer$UnsafeCursor3 = new Buffer$UnsafeCursor();
        }
        if (buffer$UnsafeCursor.buffer == null) {
            buffer$UnsafeCursor.buffer = this;
            buffer$UnsafeCursor.readWrite = true;
            return buffer$UnsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer".toString());
    }

    @Override
    public final BufferedSink emitCompleteSegments() {
        return this;
    }

    @Override
    public final BufferedSink emit() {
        return this;
    }

    @Override
    public final BufferedSink write(ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "byteString");
        byteString2.write$okio(this, byteString2.getSize$okio());
        return this;
    }

    @Override
    public final BufferedSink writeUtf8(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "string");
        return this.writeUtf8(0, string2.length(), string);
    }

    @Override
    public final BufferedSink write(byte[] byArray) {
        byte[] byArray2 = byArray;
        Intrinsics.checkNotNullParameter(byArray2, "source");
        return this.write(byArray, 0, byArray2.length);
    }

    public final Object clone() {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        if (this.size != 0L) {
            Segment segment;
            Segment segment2 = this.head;
            Intrinsics.checkNotNull(segment2);
            segment2.shared = true;
            Segment segment3 = segment;
            Segment segment4 = segment2;
            Object object = segment4.data;
            int n = segment4.pos;
            int n2 = segment4.limit;
            segment3((byte[])object, n, n2, true, false);
            buffer2.head = segment3;
            segment.prev = segment3;
            segment.next = segment3;
            object = segment2.next;
            while (object != segment2) {
                Segment segment5;
                Object object2 = object;
                Segment segment6 = segment3.prev;
                Segment segment7 = segment6;
                Intrinsics.checkNotNull(segment7);
                Intrinsics.checkNotNull(object);
                object.shared = true;
                segment7 = segment5;
                object = object.data;
                n2 = object.pos;
                int n3 = object.limit;
                segment5 = new Segment((byte[])object, n2, n3, true, false);
                segment6.push(segment7);
                object = object2.next;
            }
            buffer2.size = this.size;
        }
        return buffer2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Buffer writeUtf8(int n, int n2, String string) {
        Object object;
        Intrinsics.checkNotNullParameter(string, "string");
        if (!(n >= 0)) {
            object = "beginIndex < 0: " + n;
            throw new IllegalArgumentException(object.toString());
        }
        if (!(n2 >= n)) {
            object = "endIndex < beginIndex: " + n2 + " < " + n;
            throw new IllegalArgumentException(object.toString());
        }
        if (!(n2 <= string.length())) {
            object = "endIndex > string.length: " + n2 + " > " + string.length();
            throw new IllegalArgumentException(object.toString());
        }
        while (n < n2) {
            int n3;
            byte[] byArray;
            int n4 = string.charAt(n);
            if (n4 < 128) {
                Segment segment = ((Buffer)object).writableSegment$okio(1);
                byte[] byArray2 = segment.data;
                int n5 = n4;
                n4 = segment.limit - n;
                int n6 = Math.min(n2, 8192 - n4);
                int n7 = n4 + n++;
                segment.data[n7] = (byte)n5;
                while (n < n6) {
                    char c = string.charAt(n);
                    n7 = c;
                    if (c >= '\u0080') break;
                    int n8 = n7;
                    n7 = n + 1;
                    n = n4 + n;
                    byArray2[n] = (byte)n8;
                    n = n7;
                }
                n4 = n + n4;
                int n9 = segment.limit;
                segment.limit = n9 + (n4 -= n9);
                ((Buffer)object).size += (long)n4;
                continue;
            }
            if (n4 < 2048) {
                Object object2 = object;
                Segment segment = ((Buffer)object2).writableSegment$okio(2);
                byArray = segment.data;
                n3 = segment.limit;
                int n10 = n4;
                byArray[n3] = (byte)(n4 >> 6 | 0xC0);
                n4 = n3 + 1;
                byArray[n4] = (byte)(n10 & 0x3F | 0x80);
                segment.limit = n3 + 2;
                ((Buffer)object2).size += 2L;
            } else {
                if (n4 >= 55296 && n4 <= 57343) {
                    int n11 = n + 1;
                    int n12 = n11 < n2 ? string.charAt(n11) : 0;
                    if (n4 <= 56319 && 56320 <= n12 && n12 < 57344) {
                        Object object3 = object;
                        n4 = ((n4 & 0x3FF) << 10 | n12 & 0x3FF) + 65536;
                        Segment segment = ((Buffer)object3).writableSegment$okio(4);
                        byte[] byArray3 = segment.data;
                        n12 = segment.limit;
                        int n13 = n4;
                        int n14 = n4;
                        int n15 = n4;
                        byArray3[n12] = (byte)(n4 >> 18 | 0xF0);
                        n4 = n12 + 1;
                        byArray3[n4] = (byte)(n15 >> 12 & 0x3F | 0x80);
                        n4 = n12 + 2;
                        byArray3[n4] = (byte)(n14 >> 6 & 0x3F | 0x80);
                        n4 = n12 + 3;
                        byArray3[n4] = (byte)(n13 & 0x3F | 0x80);
                        segment.limit = n12 + 4;
                        ((Buffer)object3).size += 4L;
                        n += 2;
                        continue;
                    }
                    ((Buffer)object).writeByte(63);
                    n = n11;
                    continue;
                }
                Object object4 = object;
                Segment segment = ((Buffer)object4).writableSegment$okio(3);
                byArray = segment.data;
                n3 = segment.limit;
                int n16 = n4;
                int n17 = n4;
                byArray[n3] = (byte)(n4 >> 12 | 0xE0);
                n4 = n3 + 1;
                byArray[n4] = (byte)(n17 >> 6 & 0x3F | 0x80);
                n4 = n3 + 2;
                byArray[n4] = (byte)(n16 & 0x3F | 0x80);
                segment.limit = n3 + 3;
                ((Buffer)object4).size += 3L;
            }
            ++n;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long indexOfElement(long l, ByteString object) {
        long l2;
        int n;
        long l3;
        Segment segment;
        block21: {
            block26: {
                int n2;
                block20: {
                    block25: {
                        block24: {
                            block23: {
                                long l4;
                                block22: {
                                    Intrinsics.checkNotNullParameter(object, "targetBytes");
                                    if (!(l >= 0L)) {
                                        StringBuilder stringBuilder;
                                        Object object2 = stringBuilder;
                                        ((StringBuilder)object2)("fromIndex < 0: ");
                                        object2 = stringBuilder.append(l).toString();
                                        throw new IllegalArgumentException(object2.toString());
                                    }
                                    segment = ((Buffer)object2).head;
                                    if (segment == null) return -1L;
                                    l3 = ((Buffer)object2).size;
                                    if (l3 - l >= l) break block22;
                                    while (l3 > l) {
                                        segment = segment.prev;
                                        Intrinsics.checkNotNull(segment);
                                        l3 -= (long)(segment.limit - segment.pos);
                                    }
                                    if (((ByteString)object).getSize$okio() == 2) break block23;
                                    break block24;
                                }
                                l3 = 0L;
                                while ((l4 = l3 + (long)(segment.limit - segment.pos)) <= l) {
                                    segment = segment.next;
                                    Intrinsics.checkNotNull(segment);
                                    l3 = l4;
                                }
                                if (((ByteString)object).getSize$okio() == 2) break block25;
                                break block26;
                            }
                            Object object3 = object;
                            byte by = ((ByteString)object3).internalGet$okio(0);
                            byte by2 = ((ByteString)object3).internalGet$okio(1);
                            while (l3 < ((Buffer)object2).size) {
                                Segment segment2 = segment;
                                byte[] byArray = segment2.data;
                                int n3 = segment2.limit;
                                for (n2 = (int)((long)(v634178).pos + l - l3); n2 < n3; ++n2) {
                                    byte by3 = byArray[n2];
                                    if (by3 != by && by3 != by2) {
                                        continue;
                                    }
                                    break block20;
                                }
                                segment = segment.next;
                                Intrinsics.checkNotNull(segment);
                                l = l3 += (long)(segment.limit - segment.pos);
                            }
                            return -1L;
                        }
                        object = ((ByteString)object).internalArray$okio();
                        block4: while (true) {
                            if (l3 >= ((Buffer)object2).size) return -1L;
                            Segment segment3 = segment;
                            byte[] byArray = segment3.data;
                            n = (int)((long)segment3.pos + l - l3);
                            int n4 = segment3.limit;
                            while (true) {
                                int n5;
                                byte by;
                                if (n < n4) {
                                    by = byArray[n];
                                    n5 = ((Object)object).length;
                                } else {
                                    segment = segment.next;
                                    Intrinsics.checkNotNull(segment);
                                    l = l3 += (long)(segment.limit - segment.pos);
                                    continue block4;
                                }
                                for (int i = 0; i < n5; ++i) {
                                    if (by != object[i]) {
                                        continue;
                                    }
                                    break block21;
                                }
                                ++n;
                            }
                            break;
                        }
                    }
                    Object object4 = object;
                    byte by = ((ByteString)object4).internalGet$okio(0);
                    byte by4 = ((ByteString)object4).internalGet$okio(1);
                    while (l3 < ((Buffer)object2).size) {
                        Segment segment4 = segment;
                        byte[] byArray = segment4.data;
                        int n6 = segment4.limit;
                        for (n2 = (int)((long)(v634317).pos + l - l3); n2 < n6; ++n2) {
                            byte by5 = byArray[n2];
                            if (by5 != by && by5 != by4) {
                                continue;
                            }
                            break block20;
                        }
                        segment = segment.next;
                        Intrinsics.checkNotNull(segment);
                        l = l3 += (long)(segment.limit - segment.pos);
                    }
                    return -1L;
                }
                l2 = (long)(n2 - segment.pos) + l3;
                return l2;
            }
            object = ((ByteString)object).internalArray$okio();
            block9: while (true) {
                if (l3 >= ((Buffer)object2).size) return -1L;
                Segment segment5 = segment;
                byte[] byArray = segment5.data;
                n = (int)((long)segment5.pos + l - l3);
                int n7 = segment5.limit;
                while (true) {
                    int n8;
                    byte by;
                    if (n < n7) {
                        by = byArray[n];
                        n8 = ((Object)object).length;
                    } else {
                        segment = segment.next;
                        Intrinsics.checkNotNull(segment);
                        l = l3 += (long)(segment.limit - segment.pos);
                        continue block9;
                    }
                    for (int i = 0; i < n8; ++i) {
                        if (by == object[i]) break block9;
                    }
                    ++n;
                }
                break;
            }
        }
        l2 = (long)(n - segment.pos) + l3;
        return l2;
    }

    @Override
    public final RealBufferedSource peek() {
        PeekSource peekSource;
        PeekSource peekSource2 = peekSource;
        peekSource = new PeekSource(this);
        return new RealBufferedSource(peekSource2);
    }

    public final void write(ByteString byteString) {
        ByteString byteString2 = byteString;
        Intrinsics.checkNotNullParameter(byteString2, "byteString");
        byteString2.write$okio(this, byteString2.getSize$okio());
    }

    public final void copyTo(long l, long l2, Buffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "out");
        _UtilKt.checkOffsetAndCount(((Buffer)object).size, l, l2);
        if (l2 != 0L) {
            buffer.size += l2;
            Object object = ((Buffer)object).head;
            while (true) {
                Object object2 = object;
                Intrinsics.checkNotNull(object2);
                long l3 = ((Segment)object2).limit - ((Segment)object).pos;
                if (l < l3) break;
                l -= l3;
                object = ((Segment)object).next;
            }
            while (l2 > 0L) {
                int n;
                Segment segment;
                Intrinsics.checkNotNull(object);
                ((Segment)object).shared = true;
                Segment segment2 = segment;
                Object object3 = object;
                byte[] byArray = ((Segment)object3).data;
                int n2 = ((Segment)object3).pos;
                int n3 = ((Segment)object3).limit;
                segment2.pos = n = new Segment((byte[])byArray, (int)n2, (int)n3, (boolean)true, (boolean)false).pos + (int)l;
                segment2.limit = Math.min(n + (int)l2, segment2.limit);
                Segment segment3 = buffer.head;
                if (segment3 == null) {
                    segment2.prev = segment2;
                    segment2.next = segment2;
                    buffer.head = segment2;
                } else {
                    Segment segment4 = segment3.prev;
                    Intrinsics.checkNotNull(segment4);
                    segment4.push(segment2);
                }
                l2 -= (long)(segment2.limit - segment2.pos);
                l = 0L;
                object = ((Segment)object).next;
            }
        }
    }
}

