/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.ws;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.ws.MessageInflater;
import com.apollographql.apollo3.relocated.okhttp3.internal.ws.RealWebSocket;
import com.apollographql.apollo3.relocated.okhttp3.internal.ws.WebSocketReader$FrameCallback;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.Buffer$UnsafeCursor;
import com.apollographql.apollo3.relocated.okio.BufferedSource;
import com.apollographql.apollo3.relocated.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

public final class WebSocketReader
implements Closeable {
    public final boolean isClient;
    public final BufferedSource source;
    public final WebSocketReader$FrameCallback frameCallback;
    public final boolean perMessageDeflate;
    public final boolean noContextTakeover;
    public boolean closed;
    public int opcode;
    public long frameLength;
    public boolean isFinalFrame;
    public boolean isControlFrame;
    public boolean readingCompressedMessage;
    public final Buffer controlFrameBuffer;
    public final Buffer messageFrameBuffer;
    public MessageInflater messageInflater;
    public final byte[] maskKey;
    public final Buffer$UnsafeCursor maskCursor;

    public WebSocketReader(boolean bl, BufferedSource object, RealWebSocket realWebSocket, boolean bl2, boolean bl3) {
        Buffer$UnsafeCursor buffer$UnsafeCursor;
        Buffer buffer;
        Buffer buffer2;
        Intrinsics.checkNotNullParameter(object, "source");
        Intrinsics.checkNotNullParameter(realWebSocket, "frameCallback");
        this.isClient = bl;
        this.source = object;
        this.frameCallback = realWebSocket;
        this.perMessageDeflate = bl2;
        this.noContextTakeover = bl3;
        object = buffer2;
        buffer2 = new Buffer();
        this.controlFrameBuffer = object;
        object = buffer;
        buffer = new Buffer();
        this.messageFrameBuffer = object;
        object = bl ? null : (Object)new byte[4];
        this.maskKey = (byte[])object;
        if (bl) {
            buffer$UnsafeCursor = null;
        } else {
            Buffer$UnsafeCursor buffer$UnsafeCursor2;
            buffer$UnsafeCursor = buffer$UnsafeCursor2;
            buffer$UnsafeCursor2 = new Buffer$UnsafeCursor();
        }
        this.maskCursor = buffer$UnsafeCursor;
    }

    @Override
    public final void close() {
        Closeable closeable = closeable.messageInflater;
        if (closeable != null) {
            ((MessageInflater)closeable).inflaterSource.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void readHeader() {
        long l;
        int n;
        int n2;
        byte by;
        if (((WebSocketReader)((Object)string)).closed) {
            throw new IOException("closed");
        }
        long l2 = ((WebSocketReader)((Object)string)).source.timeout().timeoutNanos();
        ((WebSocketReader)((Object)string)).source.timeout().clearTimeout();
        try {
            by = ((WebSocketReader)((Object)string)).source.readByte();
            n2 = 255;
        }
        catch (Throwable throwable) {
            ((WebSocketReader)((Object)string)).source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
            throw throwable;
        }
        int n3 = by & n2;
        ((WebSocketReader)((Object)string)).source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
        ((WebSocketReader)((Object)string)).opcode = n = n3 & 0xF;
        boolean bl = (n3 & 0x80) != 0;
        ((WebSocketReader)((Object)string)).isFinalFrame = bl;
        boolean bl2 = (n3 & 8) != 0;
        ((WebSocketReader)((Object)string)).isControlFrame = bl2;
        if (bl2 && !bl) {
            throw new ProtocolException("Control frames must be final.");
        }
        bl = (n3 & 0x40) != 0;
        if (n != 1 && n != 2) {
            if (bl) {
                throw new ProtocolException("Unexpected rsv1 flag");
            }
        } else {
            if (bl) {
                if (!((WebSocketReader)((Object)string)).perMessageDeflate) {
                    throw new ProtocolException("Unexpected rsv1 flag");
                }
                n = 1;
            } else {
                n = 0;
            }
            ((WebSocketReader)((Object)string)).readingCompressedMessage = n;
        }
        if ((n3 & 0x20) != 0) {
            throw new ProtocolException("Unexpected rsv2 flag");
        }
        if ((n3 & 0x10) != 0) {
            throw new ProtocolException("Unexpected rsv3 flag");
        }
        n = ((WebSocketReader)((Object)string)).source.readByte() & 0xFF;
        bl = (n & 0x80) != 0;
        if (bl == ((WebSocketReader)((Object)string)).isClient) {
            ProtocolException protocolException;
            String string = ((WebSocketReader)((Object)string)).isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.";
            ProtocolException protocolException2 = protocolException;
            protocolException2(string);
            throw protocolException2;
        }
        ((WebSocketReader)((Object)string)).frameLength = l = (long)(n & 0x7F);
        if (l == 126L) {
            ((WebSocketReader)((Object)string)).frameLength = l = (long)(((WebSocketReader)((Object)string)).source.readShort() & 0xFFFF);
        } else if (l == 127L) {
            ((WebSocketReader)((Object)string)).frameLength = l = ((WebSocketReader)((Object)string)).source.readLong();
            if (l < 0L) {
                StringBuilder stringBuilder = new StringBuilder("Frame length 0x");
                String string = Long.toHexString(((WebSocketReader)((Object)string)).frameLength);
                Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
                throw new ProtocolException(stringBuilder.append(string).append(" > 0x7FFFFFFFFFFFFFFF").toString());
            }
        }
        if (((WebSocketReader)((Object)string)).isControlFrame && ((WebSocketReader)((Object)string)).frameLength > 125L) {
            throw new ProtocolException("Control frame must be less than 125B.");
        }
        if (bl) {
            Intrinsics.checkNotNull(((WebSocketReader)((Object)string)).maskKey);
            ((WebSocketReader)((Object)string)).source.readFully(((WebSocketReader)((Object)string)).maskKey);
        }
    }

    public final void readControlFrame() {
        block17: {
            block18: {
                Object object;
                block16: {
                    long l = ((WebSocketReader)object3).frameLength;
                    if (l > 0L) {
                        WebSocketReader webSocketReader = object3;
                        webSocketReader.source.readFully(((WebSocketReader)object3).controlFrameBuffer, l);
                        if (!webSocketReader.isClient) {
                            block15: {
                                long l2;
                                Object object2 = object3;
                                Buffer buffer = ((WebSocketReader)object2).controlFrameBuffer;
                                Buffer$UnsafeCursor buffer$UnsafeCursor = ((WebSocketReader)object3).maskCursor;
                                Intrinsics.checkNotNull(buffer$UnsafeCursor);
                                buffer.readAndWriteUnsafe(buffer$UnsafeCursor);
                                ((WebSocketReader)object2).maskCursor.seek(0L);
                                Buffer$UnsafeCursor buffer$UnsafeCursor2 = ((WebSocketReader)object2).maskCursor;
                                object = ((WebSocketReader)object2).maskKey;
                                Intrinsics.checkNotNull(object);
                                Intrinsics.checkNotNullParameter(buffer$UnsafeCursor2, "cursor");
                                int n = 0;
                                int n2 = ((WebSocketReader)object2).maskKey.length;
                                do {
                                    byte[] byArray = buffer$UnsafeCursor2.data;
                                    Buffer$UnsafeCursor buffer$UnsafeCursor3 = buffer$UnsafeCursor2;
                                    int n3 = buffer$UnsafeCursor3.start;
                                    int n4 = buffer$UnsafeCursor3.end;
                                    if (buffer$UnsafeCursor2.data != null) {
                                        while (n3 < n4) {
                                            byArray[n3] = (byte)(byArray[n3] ^ object[n %= n2]);
                                            ++n3;
                                            ++n;
                                        }
                                    }
                                    long l3 = buffer$UnsafeCursor2.offset;
                                    Buffer buffer2 = buffer$UnsafeCursor2.buffer;
                                    Intrinsics.checkNotNull(buffer2);
                                    if (!(l3 != buffer2.size)) break block15;
                                } while (((l2 = buffer$UnsafeCursor2.offset) == -1L ? buffer$UnsafeCursor2.seek(0L) : buffer$UnsafeCursor2.seek(l2 + (long)(buffer$UnsafeCursor2.end - buffer$UnsafeCursor2.start))) != -1);
                                ((WebSocketReader)object3).maskCursor.close();
                                break block16;
                            }
                            throw new IllegalStateException("no more bytes".toString());
                        }
                    }
                }
                switch (((WebSocketReader)object3).opcode) {
                    default: {
                        break block17;
                    }
                    case 10: {
                        Buffer buffer = ((WebSocketReader)object3).controlFrameBuffer;
                        Object object3 = buffer.readByteString(buffer.size);
                        RealWebSocket realWebSocket = (RealWebSocket)((WebSocketReader)object3).frameCallback;
                        synchronized (realWebSocket) {
                            Intrinsics.checkNotNullParameter(object3, "payload");
                            realWebSocket.awaitingPong = false;
                            break;
                        }
                    }
                    case 9: {
                        WebSocketReader webSocketReader = object3;
                        Object object3 = webSocketReader.frameCallback;
                        Buffer buffer = webSocketReader.controlFrameBuffer;
                        object3 = buffer.readByteString(buffer.size);
                        ((RealWebSocket)object3).onReadPing((ByteString)object3);
                        break;
                    }
                    case 8: {
                        int n = 1005;
                        object = "";
                        Object object4 = ((WebSocketReader)object3).controlFrameBuffer;
                        long l = ((Buffer)object4).size;
                        if (l == 1L) break block18;
                        if (l != 0L) {
                            short s = ((Buffer)object4).readShort();
                            n = s;
                            object = ((WebSocketReader)object3).controlFrameBuffer.readUtf8();
                            object4 = s >= 1000 && n < 5000 ? (!(1004 <= n && n < 1007) && !(1015 <= n && n < 3000) ? null : "Code " + n + " is reserved and may not be used.") : Intrinsics.stringPlus(n, "Code must be in range [1000,5000): ");
                            if (object4 != null) {
                                throw new ProtocolException((String)object4);
                            }
                        }
                        ((RealWebSocket)((WebSocketReader)object3).frameCallback).onReadClose(n, (String)object);
                        ((WebSocketReader)object3).closed = true;
                    }
                }
                return;
            }
            throw new ProtocolException("Malformed close payload length of 1.");
        }
        String string = Integer.toHexString(((WebSocketReader)object3).opcode);
        Intrinsics.checkNotNullExpressionValue(string, "toHexString(this)");
        throw new ProtocolException(Intrinsics.stringPlus(string, "Unknown control opcode: "));
    }
}

