/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt___ArraysJvmKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Hpack;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Huffman;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.ByteString;
import java.util.ArrayList;
import java.util.Arrays;

public final class Hpack$Writer {
    public final boolean useCompression;
    public final Buffer out;
    public int smallestHeaderTableSizeSetting;
    public boolean emitDynamicTableSizeUpdate;
    public int maxDynamicTableByteCount;
    public Header[] dynamicTable;
    public int nextHeaderIndex;
    public int headerCount;
    public int dynamicTableByteCount;

    public Hpack$Writer(int n, boolean bl, Buffer buffer) {
        Hpack$Writer hpack$Writer = this;
        Hpack$Writer hpack$Writer2 = this;
        this.useCompression = bl;
        hpack$Writer2.out = buffer;
        hpack$Writer2.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        hpack$Writer.maxDynamicTableByteCount = n;
        hpack$Writer.dynamicTable = new Header[8];
        hpack$Writer.nextHeaderIndex = 7;
    }

    public /* synthetic */ Hpack$Writer(Buffer buffer) {
        this(4096, true, buffer);
    }

    public final void writeHeaders(ArrayList arrayList) {
        int n;
        if (this.emitDynamicTableSizeUpdate) {
            n = this.smallestHeaderTableSizeSetting;
            if (n < this.maxDynamicTableByteCount) {
                this.writeInt(n, 31, 32);
            }
            this.emitDynamicTableSizeUpdate = false;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.writeInt(this.maxDynamicTableByteCount, 31, 32);
        }
        n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            Header header = (Header)arrayList.get(n++);
            ByteString byteString = header.name.toAsciiLowercase();
            ByteString byteString2 = header.value;
            int n3 = -1;
            int n4 = -1;
            Header[] headerArray = (Header[])Hpack.NAME_TO_FIRST_INDEX.get(byteString);
            if (headerArray != null && 2 <= (n4 = headerArray.intValue() + 1) && n4 < 8) {
                headerArray = Hpack.STATIC_HEADER_TABLE;
                if (Intrinsics.areEqual(Hpack.STATIC_HEADER_TABLE[n4 - 1].value, byteString2)) {
                    n3 = n4;
                } else if (Intrinsics.areEqual(headerArray[n4].value, byteString2)) {
                    n3 = n4 + 1;
                }
            }
            if (n3 == -1) {
                int n5 = this.nextHeaderIndex + 1;
                int n6 = this.dynamicTable.length;
                while (n5 < n6) {
                    int n7 = n5 + 1;
                    Header header2 = this.dynamicTable[n5];
                    Intrinsics.checkNotNull(header2);
                    if (Intrinsics.areEqual(header2.name, byteString)) {
                        Header header3 = this.dynamicTable[n5];
                        Intrinsics.checkNotNull(header3);
                        if (Intrinsics.areEqual(header3.value, byteString2)) {
                            n3 = n5 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                            break;
                        }
                        if (n4 == -1) {
                            n4 = n5 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                            n5 = n7;
                            continue;
                        }
                    }
                    n5 = n7;
                }
            }
            if (n3 != -1) {
                this.writeInt(n3, 127, 128);
                continue;
            }
            if (n4 == -1) {
                this.out.writeByte(64);
                this.writeByteString(byteString);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
                continue;
            }
            ByteString byteString3 = Header.PSEUDO_PREFIX;
            byteString.getClass();
            Intrinsics.checkNotNullParameter(byteString3, "prefix");
            int n8 = byteString3.getSize$okio();
            if (byteString.rangeEquals(0, byteString3, n8) && !Intrinsics.areEqual(Header.TARGET_AUTHORITY, byteString)) {
                this.writeInt(n4, 15, 0);
                this.writeByteString(byteString2);
                continue;
            }
            this.writeInt(n4, 63, 64);
            this.writeByteString(byteString2);
            this.insertIntoDynamicTable(header);
        }
    }

    public final void writeInt(int n, int n2, int n3) {
        if (n < n2) {
            this.out.writeByte(n3 | n);
            return;
        }
        this.out.writeByte(n3 | n2);
        n -= n2;
        while (n >= 128) {
            int n4 = n;
            this.out.writeByte((n &= 0x7F) | 0x80);
            n = n4 >>> 7;
        }
        this.out.writeByte(n);
    }

    /*
     * Unable to fully structure code
     */
    public final void writeByteString(ByteString var1_1) {
        Intrinsics.checkNotNullParameter(var1_1, "data");
        if (!this.useCompression) ** GOTO lbl-1000
        var2_2 = 0L;
        var4_4 = 0;
        var5_6 = var1_1.getSize$okio();
        while (var4_4 < var5_6) {
            v0 = var4_4++;
            var2_2 += (long)Huffman.CODE_BIT_COUNTS[var1_1.internalGet$okio(v0) & 255];
        }
        if ((int)(var2_2 + (long)7 >> 3) < var1_1.getSize$okio()) {
            var2_3 = v1;
            v1 = new Buffer();
            var3_7 = 0L;
            var5_6 = 0;
            var6_9 = 0;
            var7_10 = var1_1.getSize$okio();
            while (var6_9 < var7_10) {
                v2 = var6_9++;
                var3_8 = var1_1.internalGet$okio(v2) & 255;
                var4_4 = Huffman.CODES[var3_8];
                var3_8 = Huffman.CODE_BIT_COUNTS[var3_8];
                var4_5 = var3_7 << var3_8 | (long)var4_4;
                var3_8 = var5_6 + var3_8;
                while (var3_8 >= 8) {
                    var2_3.writeByte((int)(var4_5 >> (var3_8 += -8)));
                }
                var3_7 = var4_5;
                var5_6 = var3_8;
            }
            if (var5_6 > 0) {
                var2_3.writeByte((int)(var3_7 << 8 - var5_6 | 255L >>> var5_6));
            }
            v3 = var2_3;
            var1_1 = v3.readByteString(v3.size);
            v4 = this;
            v4.writeInt(var1_1.getSize$okio(), 127, 128);
            this = v4.out;
            this.getClass();
            var1_1.write$okio((Buffer)this, var1_1.getSize$okio());
        } else lbl-1000:
        // 2 sources

        {
            v5 = var1_1;
            v6 = this;
            v6.writeInt(var1_1.getSize$okio(), 127, 0);
            this = v6.out;
            this.getClass();
            v5.write$okio((Buffer)this, v5.getSize$okio());
        }
    }

    public final void evictToRecoverBytes(int n) {
        int n2 = 0;
        if (n > 0) {
            int n3;
            int n4;
            for (n4 = this.dynamicTable.length - 1; n4 >= (n3 = this.nextHeaderIndex) && n > 0; --n4) {
                Hpack$Writer hpack$Writer = this;
                Header header = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header);
                n -= header.hpackSize;
                int n5 = hpack$Writer.dynamicTableByteCount;
                Header header2 = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header2);
                hpack$Writer.dynamicTableByteCount = n5 - header2.hpackSize;
                hpack$Writer.headerCount += -1;
                ++n2;
            }
            Hpack$Writer hpack$Writer = this;
            n = n3 + 1;
            n4 = n + n2;
            n3 = this.headerCount;
            System.arraycopy(hpack$Writer.dynamicTable, n, hpack$Writer.dynamicTable, n4, n3);
            int n6 = this.nextHeaderIndex + 1;
            Arrays.fill(hpack$Writer.dynamicTable, n6, n6 + n2, null);
            hpack$Writer.nextHeaderIndex += n2;
        }
    }

    public final void insertIntoDynamicTable(Header header) {
        int n = header.hpackSize;
        int n2 = this.maxDynamicTableByteCount;
        if (n > n2) {
            Hpack$Writer hpack$Writer = this;
            ArraysKt___ArraysJvmKt.fill$default(hpack$Writer.dynamicTable, null);
            hpack$Writer.nextHeaderIndex = hpack$Writer.dynamicTable.length - 1;
            hpack$Writer.headerCount = 0;
            hpack$Writer.dynamicTableByteCount = 0;
            return;
        }
        Hpack$Writer hpack$Writer = this;
        hpack$Writer.evictToRecoverBytes(hpack$Writer.dynamicTableByteCount + n - n2);
        Header[] headerArray = this.dynamicTable;
        if (hpack$Writer.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray2 = headerArray;
            headerArray = new Header[headerArray.length * 2];
            int n3 = headerArray2.length;
            int n4 = headerArray.length;
            System.arraycopy(headerArray2, 0, headerArray, n3, n4);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        Hpack$Writer hpack$Writer2 = this;
        int n5 = hpack$Writer2.nextHeaderIndex;
        hpack$Writer2.nextHeaderIndex = n5 + -1;
        hpack$Writer2.dynamicTable[n5] = header;
        ++hpack$Writer2.headerCount;
        hpack$Writer2.dynamicTableByteCount += n;
    }
}

