/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.connection;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.EventListener;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.ExchangeFinder;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall$timeout$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection$newWebSocketStreams$1;
import com.apollographql.apollo3.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ConnectionShutdownException;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.StreamResetException;
import com.apollographql.apollo3.relocated.okio.AsyncTimeout$Companion;
import com.apollographql.apollo3.relocated.okio.BufferedSource;
import com.apollographql.apollo3.relocated.okio.RealBufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;

public final class Exchange {
    public final RealCall call;
    public final EventListener eventListener;
    public final ExchangeFinder finder;
    public final ExchangeCodec codec;
    public boolean isDuplex;
    public final RealConnection connection;

    public Exchange(RealCall realCall, EventListener eventListener, ExchangeFinder exchangeFinder, ExchangeCodec exchangeCodec) {
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.call = realCall;
        this.eventListener = eventListener;
        this.finder = exchangeFinder;
        this.codec = exchangeCodec;
        this.connection = exchangeCodec.getConnection();
    }

    public final RealConnection$newWebSocketStreams$1 newWebSocketStreams() {
        Object object = this.call;
        if (((RealCall)object).timeoutEarlyExit ^ true) {
            ((RealCall)object).timeoutEarlyExit = true;
            RealCall$timeout$1 realCall$timeout$1 = ((RealCall)object).timeout;
            realCall$timeout$1.getClass();
            AsyncTimeout$Companion.access$cancelScheduledTimeout(realCall$timeout$1);
            object = this.codec.getConnection();
            object.getClass();
            Socket socket = ((RealConnection)object).socket;
            Closeable closeable = socket;
            Object object2 = object;
            Intrinsics.checkNotNull(closeable);
            closeable = ((RealConnection)object2).source;
            Intrinsics.checkNotNull(closeable);
            RealBufferedSink realBufferedSink = ((RealConnection)object2).sink;
            Intrinsics.checkNotNull(realBufferedSink);
            socket.setSoTimeout(0);
            synchronized (object) {
                ((RealConnection)object).noNewExchanges = true;
                return new RealConnection$newWebSocketStreams$1((BufferedSource)closeable, realBufferedSink, this);
            }
        }
        throw new IllegalStateException("Check failed.".toString());
    }

    public final void noNewExchangesOnConnection() {
        RealConnection realConnection = ((Exchange)((Object)realConnection)).codec.getConnection();
        synchronized (realConnection) {
            realConnection.noNewExchanges = true;
            return;
        }
    }

    public final void detachWithViolence() {
        Exchange exchange = this;
        exchange.codec.cancel();
        exchange.call.messageDone$okhttp(this, true, true, null);
    }

    public final IOException bodyComplete(boolean bl, boolean bl2, IOException iOException) {
        EventListener eventListener;
        if (iOException != null) {
            this.trackFailure(iOException);
        }
        if (bl2) {
            if (iOException != null) {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            } else {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            }
        }
        if (bl) {
            if (iOException != null) {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            } else {
                Exchange exchange = this;
                eventListener = exchange.eventListener;
                RealCall realCall = exchange.call;
                eventListener.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
            }
        }
        return this.call.messageDone$okhttp(this, bl2, bl, iOException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void trackFailure(IOException object) {
        Exchange exchange = realConnection;
        exchange.finder.trackFailure((IOException)object);
        RealConnection realConnection = exchange.codec.getConnection();
        RealCall realCall = exchange.call;
        synchronized (realConnection) {
            Intrinsics.checkNotNullParameter(realCall, "call");
            if (object instanceof StreamResetException) {
                ErrorCode errorCode = ((StreamResetException)object).errorCode;
                if (errorCode == ErrorCode.REFUSED_STREAM) {
                    realConnection.refusedStreamCount = realConnection.refusedStreamCount + 1;
                    if (realConnection.refusedStreamCount <= 1) return;
                    realConnection.noNewExchanges = true;
                    ++realConnection.routeFailureCount;
                    return;
                }
                if (errorCode == ErrorCode.CANCEL && realCall.canceled) {
                    return;
                }
                realConnection.noNewExchanges = true;
                ++realConnection.routeFailureCount;
                return;
            }
            if (realConnection.isMultiplexed$okhttp()) {
                if (!(object instanceof ConnectionShutdownException)) return;
            }
            realConnection.noNewExchanges = true;
            if (realConnection.successCount != 0) return;
            RealConnection.connectFailed$okhttp(realCall.client, realConnection.route, object);
            ++realConnection.routeFailureCount;
            return;
        }
    }
}

