/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.com.squareup.javapoet;

import com.apollographql.apollo3.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo3.relocated.com.squareup.javapoet.CodeWriter;
import com.apollographql.apollo3.relocated.com.squareup.javapoet.FieldSpec$Builder;
import com.apollographql.apollo3.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo3.relocated.com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class FieldSpec {
    public final TypeName type;
    public final String name;
    public final CodeBlock javadoc;
    public final List annotations;
    public final Set modifiers;
    public final CodeBlock initializer;

    public FieldSpec(FieldSpec$Builder object) {
        this.type = (TypeName)Util.checkNotNull(FieldSpec$Builder.access$000((FieldSpec$Builder)object), "type == null", new Object[0]);
        this.name = (String)Util.checkNotNull(FieldSpec$Builder.access$100((FieldSpec$Builder)object), "name == null", new Object[0]);
        this.javadoc = FieldSpec$Builder.access$200((FieldSpec$Builder)object).build();
        this.annotations = Util.immutableList(((FieldSpec$Builder)object).annotations);
        this.modifiers = Util.immutableSet(((FieldSpec$Builder)object).modifiers);
        object = FieldSpec$Builder.access$300((FieldSpec$Builder)object) == null ? CodeBlock.builder().build() : FieldSpec$Builder.access$300((FieldSpec$Builder)object);
        this.initializer = object;
    }

    public static FieldSpec$Builder builder(TypeName typeName, String string, Modifier ... modifierArray) {
        Util.checkNotNull(typeName, "type == null", new Object[0]);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Util.checkArgument(SourceVersion.isName(string), "not a valid name: %s", objectArray2);
        return new FieldSpec$Builder(typeName, string, 0).addModifiers(modifierArray);
    }

    public final boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public final void emit(CodeWriter codeWriter, Set objectArray) {
        CodeWriter codeWriter2 = codeWriter;
        codeWriter.emitJavadoc(this.javadoc);
        codeWriter.emitAnnotations(this.annotations, false);
        codeWriter2.emitModifiers(this.modifiers, (Set)objectArray);
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = this.type;
        objectArray2[1] = this.name;
        codeWriter2.emit("$T $L", objectArray);
        if (!this.initializer.formatParts.isEmpty()) {
            codeWriter.emitAndIndent(" = ");
            codeWriter.emit(this.initializer, false);
        }
        codeWriter.emitAndIndent(";\n");
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (FieldSpec.class != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder;
        FieldSpec fieldSpec = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        try {
            fieldSpec.emit(new CodeWriter(stringBuilder2), Collections.emptySet());
            return stringBuilder2.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }
}

