/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.http2;

import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Hpack;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.Huffman;
import com.apollographql.apollo3.relocated.okio.Buffer;
import com.apollographql.apollo3.relocated.okio.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Hpack$Writer {
    public int smallestHeaderTableSizeSetting;
    public boolean emitDynamicTableSizeUpdate;
    public int maxDynamicTableByteCount;
    public Header[] dynamicTable;
    public int nextHeaderIndex;
    public int headerCount;
    public int dynamicTableByteCount;
    public final boolean useCompression;
    public final Buffer out;

    public Hpack$Writer(int n, boolean bl, Buffer buffer) {
        Hpack$Writer hpack$Writer = this;
        Hpack$Writer hpack$Writer2 = this;
        this.useCompression = bl;
        hpack$Writer2.out = buffer;
        hpack$Writer2.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        hpack$Writer.maxDynamicTableByteCount = n;
        hpack$Writer.dynamicTable = new Header[8];
        hpack$Writer.nextHeaderIndex = 7;
    }

    public /* synthetic */ Hpack$Writer(Buffer buffer) {
        this(4096, true, buffer);
    }

    public final void writeHeaders(List list) {
        if (this.emitDynamicTableSizeUpdate) {
            int n = this.smallestHeaderTableSizeSetting;
            if (n < this.maxDynamicTableByteCount) {
                this.writeInt(n, 31, 32);
            }
            Hpack$Writer hpack$Writer = this;
            hpack$Writer.emitDynamicTableSizeUpdate = false;
            hpack$Writer.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            hpack$Writer.writeInt(hpack$Writer.maxDynamicTableByteCount, 31, 32);
        }
        ArrayList arrayList = (ArrayList)list;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Header header = (Header)arrayList.get(i);
            ByteString byteString = header.name.toAsciiLowercase();
            ByteString byteString2 = header.value;
            int n2 = -1;
            int n3 = -1;
            Integer n4 = (Integer)Hpack.NAME_TO_FIRST_INDEX.get(byteString);
            if (n4 != null) {
                n3 = n4 + 1;
                int n5 = 7;
                if (2 <= n3 && n5 >= n3) {
                    Header[] headerArray = Hpack.STATIC_HEADER_TABLE;
                    if (Intrinsics.areEqual(Hpack.STATIC_HEADER_TABLE[n3 - 1].value, byteString2)) {
                        n2 = n3;
                    } else if (Intrinsics.areEqual(headerArray[n3].value, byteString2)) {
                        n2 = n3 + 1;
                    }
                }
            }
            if (n2 == -1) {
                int n6 = this.dynamicTable.length;
                for (int j = (v524403).nextHeaderIndex + 1; j < n6; ++j) {
                    Header header2 = this.dynamicTable[j];
                    Intrinsics.checkNotNull(header2);
                    if (!Intrinsics.areEqual(header2.name, byteString)) continue;
                    Header header3 = this.dynamicTable[j];
                    Intrinsics.checkNotNull(header3);
                    if (Intrinsics.areEqual(header3.value, byteString2)) {
                        n2 = j - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                        break;
                    }
                    if (n3 != -1) continue;
                    n3 = j - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                }
            }
            if (n2 != -1) {
                this.writeInt(n2, 127, 128);
                continue;
            }
            if (n3 == -1) {
                this.out.writeByte(64);
                this.writeByteString(byteString);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
                continue;
            }
            ByteString byteString3 = Header.PSEUDO_PREFIX;
            byteString.getClass();
            Intrinsics.checkNotNullParameter(byteString3, "prefix");
            int n7 = byteString3.getSize$okio();
            if (byteString.rangeEquals(0, byteString3, n7) && Intrinsics.areEqual(Header.TARGET_AUTHORITY, byteString) ^ true) {
                Hpack$Writer hpack$Writer = this;
                hpack$Writer.writeInt(n3, 15, 0);
                hpack$Writer.writeByteString(byteString2);
                continue;
            }
            Hpack$Writer hpack$Writer = this;
            hpack$Writer.writeInt(n3, 63, 64);
            hpack$Writer.writeByteString(byteString2);
            hpack$Writer.insertIntoDynamicTable(header);
        }
    }

    public final void writeInt(int n, int n2, int n3) {
        if (n < n2) {
            this.out.writeByte(n3 | n);
            return;
        }
        this.out.writeByte(n3 | n2);
        n -= n2;
        while (n >= 128) {
            int n4 = n;
            this.out.writeByte((n &= 0x7F) | 0x80);
            n = n4 >>> 7;
        }
        this.out.writeByte(n);
    }

    /*
     * Unable to fully structure code
     */
    public final void writeByteString(ByteString var1_1) {
        Intrinsics.checkNotNullParameter(var1_1, "data");
        if (!this.useCompression) ** GOTO lbl-1000
        var2_2 = 0L;
        var5_6 = var1_1.getSize$okio();
        for (var4_4 = 0; var4_4 < var5_6; ++var4_4) {
            var2_2 += (long)Huffman.CODE_BIT_COUNTS[var1_1.internalGet$okio(var4_4) & 255];
        }
        if ((int)(var2_2 + (long)7 >> 3) < var1_1.getSize$okio()) {
            var2_3 = v0;
            v0 = new Buffer();
            var3_7 = 0L;
            var5_6 = 0;
            var7_10 = var1_1.getSize$okio();
            for (var6_9 = 0; var6_9 < var7_10; ++var6_9) {
                var3_8 = var1_1.internalGet$okio(var6_9) & 255;
                var4_4 = Huffman.CODES[var3_8];
                var3_8 = Huffman.CODE_BIT_COUNTS[var3_8];
                var4_5 = var3_7 << var3_8 | (long)var4_4;
                var3_8 = var5_6 + var3_8;
                while (var3_8 >= 8) {
                    var2_3.writeByte((int)(var4_5 >> (var3_8 -= 8)));
                }
                var3_7 = var4_5;
                var5_6 = var3_8;
            }
            if (var5_6 > 0) {
                var2_3.writeByte((int)(var3_7 << 8 - var5_6 | 255L >>> var5_6));
            }
            v1 = var2_3;
            var1_1 = v1.readByteString(v1.size);
            v2 = this;
            v2.writeInt(var1_1.getSize$okio(), 127, 128);
            this = v2.out;
            this.getClass();
            var1_1.write$okio((Buffer)this, var1_1.getSize$okio());
        } else lbl-1000:
        // 2 sources

        {
            v3 = var1_1;
            v4 = this;
            v4.writeInt(var1_1.getSize$okio(), 127, 0);
            this = v4.out;
            this.getClass();
            v3.write$okio((Buffer)this, v3.getSize$okio());
        }
    }

    public final void evictToRecoverBytes(int n) {
        int n2 = 0;
        if (n > 0) {
            int n3;
            int n4;
            for (n4 = this.dynamicTable.length - 1; n4 >= (n3 = this.nextHeaderIndex) && n > 0; --n4) {
                Hpack$Writer hpack$Writer = this;
                Header header = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header);
                n -= header.hpackSize;
                int n5 = hpack$Writer.dynamicTableByteCount;
                Header header2 = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header2);
                hpack$Writer.dynamicTableByteCount = n5 - header2.hpackSize;
                hpack$Writer.headerCount += -1;
                ++n2;
            }
            Hpack$Writer hpack$Writer = this;
            n = n3 + 1;
            n4 = n + n2;
            n3 = this.headerCount;
            System.arraycopy(hpack$Writer.dynamicTable, n, hpack$Writer.dynamicTable, n4, n3);
            int n6 = this.nextHeaderIndex + 1;
            Arrays.fill(hpack$Writer.dynamicTable, n6, n6 + n2, null);
            hpack$Writer.nextHeaderIndex += n2;
        }
    }

    public final void insertIntoDynamicTable(Header header) {
        int n = header.hpackSize;
        int n2 = this.maxDynamicTableByteCount;
        if (n > n2) {
            Hpack$Writer hpack$Writer = this;
            Arrays.fill(hpack$Writer.dynamicTable, 0, hpack$Writer.dynamicTable.length, null);
            hpack$Writer.nextHeaderIndex = hpack$Writer.dynamicTable.length - 1;
            hpack$Writer.headerCount = 0;
            hpack$Writer.dynamicTableByteCount = 0;
            return;
        }
        Hpack$Writer hpack$Writer = this;
        hpack$Writer.evictToRecoverBytes(hpack$Writer.dynamicTableByteCount + n - n2);
        Header[] headerArray = this.dynamicTable;
        if (hpack$Writer.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray2 = headerArray;
            headerArray = new Header[headerArray.length * 2];
            int n3 = headerArray2.length;
            int n4 = headerArray.length;
            System.arraycopy(headerArray2, 0, headerArray, n3, n4);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        Hpack$Writer hpack$Writer2 = this;
        int n5 = hpack$Writer2.nextHeaderIndex;
        hpack$Writer2.nextHeaderIndex = n5 + -1;
        hpack$Writer2.dynamicTable[n5] = header;
        ++hpack$Writer2.headerCount;
        hpack$Writer2.dynamicTableByteCount += n;
    }
}

