/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.okhttp3.internal.connection;

import com.apollographql.apollo3.relocated.kotlin.collections.ArraysKt___ArraysKt;
import com.apollographql.apollo3.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo3.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo3.relocated.okhttp3.Address;
import com.apollographql.apollo3.relocated.okhttp3.Call;
import com.apollographql.apollo3.relocated.okhttp3.Dns$Companion$DnsSystem;
import com.apollographql.apollo3.relocated.okhttp3.EventListener;
import com.apollographql.apollo3.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo3.relocated.okhttp3.Route;
import com.apollographql.apollo3.relocated.okhttp3.internal.Util;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealCall;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RealConnectionPool;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteDatabase;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteSelector;
import com.apollographql.apollo3.relocated.okhttp3.internal.connection.RouteSelector$Selection;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.ConnectionShutdownException;
import com.apollographql.apollo3.relocated.okhttp3.internal.http2.StreamResetException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class ExchangeFinder {
    public RouteSelector$Selection routeSelection;
    public RouteSelector routeSelector;
    public int refusedStreamCount;
    public int connectionShutdownCount;
    public int otherFailureCount;
    public Route nextRouteToTry;
    public final RealConnectionPool connectionPool;
    public final Address address;
    public final RealCall call;
    public final EventListener eventListener;

    public ExchangeFinder(RealConnectionPool realConnectionPool, Address address, RealCall realCall, EventListener eventListener) {
        Intrinsics.checkNotNullParameter(realConnectionPool, "connectionPool");
        Intrinsics.checkNotNullParameter(realCall, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        this.connectionPool = realConnectionPool;
        this.address = address;
        this.call = realCall;
        this.eventListener = eventListener;
    }

    public final void trackFailure(IOException iOException) {
        Intrinsics.checkNotNullParameter(iOException, "e");
        this.nextRouteToTry = null;
        if (iOException instanceof StreamResetException && ((StreamResetException)iOException).errorCode == 8) {
            ++this.refusedStreamCount;
        } else if (iOException instanceof ConnectionShutdownException) {
            ++this.connectionShutdownCount;
        } else {
            ++this.otherFailureCount;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RealConnection findHealthyConnection(int n, int n2, int n3, boolean bl, boolean bl2) {
        while (true) {
            Object object;
            if (((RealConnection)(object = this.findConnection(n, n2, n3, bl))).isHealthy(bl2)) {
                return object;
            }
            RealConnection realConnection = object;
            synchronized (realConnection) {
                realConnection.noNewExchanges = true;
                if (this.nextRouteToTry != null) continue;
            }
            object = this.routeSelection;
            boolean bl3 = object == null || ((RouteSelector$Selection)object).nextRouteIndex < ((RouteSelector$Selection)object).routes.size();
            if (bl3) continue;
            RouteSelector routeSelector = this.routeSelector;
            boolean bl4 = routeSelector == null || routeSelector.nextProxyIndex < routeSelector.proxies.size() || ((ArrayList)routeSelector.postponedRoutes).isEmpty() ^ true;
            if (!bl4) break;
        }
        throw new IOException("exhausted all routes");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final RealConnection findConnection(int n, int n2, int n3, boolean bl) {
        Object object;
        Object object2;
        RealConnection realConnection;
        Object object3;
        Object object4;
        Object object5;
        block42: {
            RouteSelector$Selection routeSelector$Selection;
            int n4;
            ArrayList arrayList;
            Object object6;
            Iterator<InetSocketAddress> iterator2;
            block43: {
                boolean bl2;
                block41: {
                    block38: {
                        block40: {
                            block39: {
                                if (((ExchangeFinder)object3).call.canceled) throw new IOException("Canceled");
                                object5 = ((ExchangeFinder)object3).call.connection;
                                if (object5 == null) break block38;
                                RealConnection realConnection2 = object5;
                                object4 = null;
                                // MONITORENTER : realConnection2
                                if (realConnection2.noNewExchanges) break block39;
                                HttpUrl httpUrl = ((RealConnection)object5).route.address.url;
                                Intrinsics.checkNotNullParameter(httpUrl, "url");
                                iterator2 = ((ExchangeFinder)object3).address.url;
                                boolean bl3 = httpUrl.port == ((HttpUrl)((Object)iterator2)).port && Intrinsics.areEqual(httpUrl.host, ((HttpUrl)((Object)iterator2)).host);
                                if (bl3) break block40;
                            }
                            object4 = ((ExchangeFinder)object3).call.releaseConnectionNoEvents$okhttp();
                        }
                        ExchangeFinder exchangeFinder = object3;
                        RealConnection realConnection3 = object5;
                        if (exchangeFinder.call.connection != null) {
                            if (!(object4 == null)) throw new IllegalStateException("Check failed.".toString());
                            return object5;
                        }
                        if (object4 != null) {
                            Util.closeQuietly((Socket)object4);
                        }
                        ExchangeFinder exchangeFinder2 = object3;
                        object5 = exchangeFinder2.eventListener;
                        RealCall realCall = exchangeFinder2.call;
                        object5.getClass();
                        Intrinsics.checkNotNullParameter(realCall, "call");
                    }
                    ((ExchangeFinder)object3).refusedStreamCount = 0;
                    ((ExchangeFinder)object3).connectionShutdownCount = 0;
                    ((ExchangeFinder)object3).otherFailureCount = 0;
                    ExchangeFinder exchangeFinder = object3;
                    object5 = exchangeFinder.address;
                    if (((ExchangeFinder)object3).connectionPool.callAcquirePooledConnection((Address)object5, exchangeFinder.call, null, false)) {
                        RealConnection realConnection4 = ((ExchangeFinder)object3).call.connection;
                        ExchangeFinder exchangeFinder3 = object3;
                        Intrinsics.checkNotNull(realConnection4);
                        object3 = exchangeFinder3.eventListener;
                        RealCall realCall = exchangeFinder3.call;
                        object3.getClass();
                        Intrinsics.checkNotNullParameter(realCall, "call");
                        return realConnection4;
                    }
                    object5 = ((ExchangeFinder)object3).nextRouteToTry;
                    if (object5 == null) break block41;
                    object4 = null;
                    ((ExchangeFinder)object3).nextRouteToTry = null;
                    break block42;
                }
                object5 = ((ExchangeFinder)object3).routeSelection;
                if (object5 == null || !(bl2 = ((RouteSelector$Selection)object5).nextRouteIndex < ((RouteSelector$Selection)object5).routes.size())) break block43;
                object4 = null;
                RouteSelector$Selection routeSelector$Selection2 = ((ExchangeFinder)object3).routeSelection;
                Intrinsics.checkNotNull(routeSelector$Selection2);
                if (!(routeSelector$Selection2.nextRouteIndex < routeSelector$Selection2.routes.size())) throw new NoSuchElementException();
                int n5 = routeSelector$Selection2.nextRouteIndex;
                routeSelector$Selection2.nextRouteIndex = n5 + 1;
                object5 = (Route)routeSelector$Selection2.routes.get(n5);
                break block42;
            }
            Object object7 = ((ExchangeFinder)object3).routeSelector;
            if (object7 == null) {
                RouteSelector routeSelector;
                object7 = routeSelector;
                Object object8 = object3;
                object4 = ((ExchangeFinder)object8).address;
                RealCall realCall = ((ExchangeFinder)object8).call;
                iterator2 = realCall.client.routeDatabase;
                object6 = ((ExchangeFinder)object8).eventListener;
                ((ExchangeFinder)object3).routeSelector = new RouteSelector((Address)object4, (RouteDatabase)((Object)iterator2), realCall, (EventListener)object6);
            }
            boolean bl4 = ((RouteSelector)object7).nextProxyIndex < ((RouteSelector)object7).proxies.size() || ((ArrayList)((RouteSelector)object7).postponedRoutes).isEmpty() ^ true;
            if (!bl4) throw new NoSuchElementException();
            object4 = arrayList;
            arrayList = new ArrayList();
            while ((n4 = ((RouteSelector)object7).nextProxyIndex < ((RouteSelector)object7).proxies.size() ? 1 : 0) != 0) {
                Iterator iterator3;
                Proxy proxy;
                block44: {
                    int n6;
                    ArrayList arrayList2;
                    n4 = ((RouteSelector)object7).nextProxyIndex < ((RouteSelector)object7).proxies.size() ? 1 : 0;
                    if (n4 == 0) throw new SocketException("No route to " + ((RouteSelector)object7).address.url.host + "; exhausted proxy configurations: " + ((RouteSelector)object7).proxies);
                    n4 = ((RouteSelector)object7).nextProxyIndex;
                    ((RouteSelector)object7).nextProxyIndex = n4 + 1;
                    proxy = (Proxy)((RouteSelector)object7).proxies.get(n4);
                    iterator2 = arrayList2;
                    ((RouteSelector)object7).inetSocketAddresses = new ArrayList();
                    if (proxy.type() != Proxy.Type.DIRECT && proxy.type() != Proxy.Type.SOCKS) {
                        object6 = proxy.address();
                        if (!(object6 instanceof InetSocketAddress)) {
                            object3 = "Proxy.address() is not an InetSocketAddress: " + object6.getClass();
                            throw new IllegalArgumentException(object3.toString());
                        }
                        object6 = (InetSocketAddress)object6;
                        Intrinsics.checkNotNullParameter(object6, "$this$socketHost");
                        iterator3 = ((InetSocketAddress)object6).getAddress();
                        if (iterator3 != null) {
                            iterator3 = ((InetAddress)((Object)iterator3)).getHostAddress();
                            Intrinsics.checkNotNullExpressionValue(iterator3, "address.hostAddress");
                        } else {
                            iterator3 = ((InetSocketAddress)object6).getHostName();
                            Intrinsics.checkNotNullExpressionValue(iterator3, "hostName");
                        }
                        n6 = ((InetSocketAddress)object6).getPort();
                    } else {
                        HttpUrl httpUrl = ((RouteSelector)object7).address.url;
                        iterator3 = httpUrl.host;
                        n6 = httpUrl.port;
                    }
                    int n7 = 65535;
                    if (1 > n6) throw new SocketException("No route to " + (String)((Object)iterator3) + ':' + n6 + "; port is out of range");
                    if (n7 < n6) throw new SocketException("No route to " + (String)((Object)iterator3) + ':' + n6 + "; port is out of range");
                    if (proxy.type() == Proxy.Type.SOCKS) {
                        ((ArrayList)((Object)iterator2)).add(InetSocketAddress.createUnresolved((String)((Object)iterator3), n6));
                    } else {
                        Object object9 = object7;
                        Object object10 = ((RouteSelector)object9).eventListener;
                        Call call = ((RouteSelector)object9).call;
                        object10.getClass();
                        Intrinsics.checkNotNullParameter(call, "call");
                        Intrinsics.checkNotNullParameter(iterator3, "domainName");
                        ((Dns$Companion$DnsSystem)((RouteSelector)object7).address.dns).getClass();
                        Object[] objectArray = InetAddress.getAllByName((String)((Object)iterator3));
                        Intrinsics.checkNotNullExpressionValue(objectArray, "InetAddress.getAllByName(hostname)");
                        object10 = ArraysKt___ArraysKt.toList(objectArray);
                        if (object10.isEmpty()) throw new UnknownHostException(((RouteSelector)object7).address.dns + " returned no addresses for " + iterator3);
                        Object object11 = object7;
                        iterator3 = ((RouteSelector)object11).eventListener;
                        Call call2 = ((RouteSelector)object11).call;
                        iterator3.getClass();
                        Intrinsics.checkNotNullParameter(call2, "call");
                        iterator3 = object10.iterator();
                        while (iterator3.hasNext()) {
                            object10 = (InetAddress)iterator3.next();
                            ((ArrayList)((Object)iterator2)).add(new InetSocketAddress((InetAddress)object10, n6));
                        }
                    }
                    iterator2 = ((RouteSelector)object7).inetSocketAddresses.iterator();
                    break block44;
                    catch (NullPointerException nullPointerException) {
                        UnknownHostException unknownHostException = new UnknownHostException("Broken system behaviour for dns lookup of ".concat((String)((Object)iterator3)));
                        unknownHostException.initCause(nullPointerException);
                        throw unknownHostException;
                    }
                }
                while (iterator2.hasNext()) {
                    block37: {
                        Route route;
                        Object object12 = (InetSocketAddress)iterator2.next();
                        iterator3 = route;
                        route = new Route(((RouteSelector)object7).address, proxy, (InetSocketAddress)object12);
                        object12 = ((RouteSelector)object7).routeDatabase;
                        // MONITORENTER : object12
                        // MONITOREXIT : object12
                        if (!((RouteDatabase)object12).failedRoutes.contains(iterator3)) break block37;
                        ((ArrayList)((RouteSelector)object7).postponedRoutes).add(iterator3);
                        continue;
                    }
                    ((ArrayList)object4).add(iterator3);
                }
                if (!(((ArrayList)object4).isEmpty() ^ true)) continue;
            }
            if (((ArrayList)object4).isEmpty()) {
                RouteSelector routeSelector = object7;
                CollectionsKt__MutableCollectionsKt.addAll((Iterable)routeSelector.postponedRoutes, (Collection)object4);
                ((ArrayList)routeSelector.postponedRoutes).clear();
            }
            object7 = routeSelector$Selection;
            ((ExchangeFinder)object3).routeSelection = new RouteSelector$Selection((List)object4);
            if (((ExchangeFinder)object3).call.canceled) throw new IOException("Canceled");
            Object object13 = object3;
            Address address = ((ExchangeFinder)object13).address;
            if (((ExchangeFinder)object3).connectionPool.callAcquirePooledConnection(address, ((ExchangeFinder)object13).call, (List)object4, false)) {
                RealConnection realConnection5 = ((ExchangeFinder)object3).call.connection;
                Object object14 = object3;
                Intrinsics.checkNotNull(realConnection5);
                object3 = ((ExchangeFinder)object14).eventListener;
                RealCall realCall = ((ExchangeFinder)object14).call;
                object3.getClass();
                Intrinsics.checkNotNullParameter(realCall, "call");
                return realConnection5;
            }
            if (!(((RouteSelector$Selection)object7).nextRouteIndex < object4.size())) throw new NoSuchElementException();
            int n8 = ((RouteSelector$Selection)object7).nextRouteIndex;
            ((RouteSelector$Selection)object7).nextRouteIndex = n8 + 1;
            object5 = (Route)object4.get(n8);
        }
        Object object15 = object3;
        RealConnection realConnection6 = realConnection;
        Object object16 = object3;
        realConnection6(((ExchangeFinder)object3).connectionPool, (Route)object5);
        ((ExchangeFinder)object16).call.connectionToCancel = realConnection6;
        try {
            object2 = ((ExchangeFinder)object16).call;
            object = ((ExchangeFinder)object16).eventListener;
            realConnection.connect(n, n2, n3, bl, (RealCall)object2, (EventListener)object);
            ((ExchangeFinder)object15).call.connectionToCancel = null;
            object2 = ((ExchangeFinder)object15).call.client.routeDatabase;
            object = realConnection6.route;
        }
        catch (Throwable throwable) {
            ((ExchangeFinder)object3).call.connectionToCancel = null;
            throw throwable;
        }
        Intrinsics.checkNotNullParameter(object, "route");
        ((RouteDatabase)object2).failedRoutes.remove(object);
        Object object17 = object3;
        object2 = ((ExchangeFinder)object17).address;
        if (((ExchangeFinder)object15).connectionPool.callAcquirePooledConnection((Address)object2, ((ExchangeFinder)object17).call, (List)object4, true)) {
            object2 = ((ExchangeFinder)object3).call.connection;
            Object object18 = object3;
            Intrinsics.checkNotNull(object2);
            ((ExchangeFinder)object3).nextRouteToTry = object5;
            Socket socket = realConnection6.socket;
            Intrinsics.checkNotNull(socket);
            Util.closeQuietly(socket);
            object3 = ((ExchangeFinder)object18).eventListener;
            RealCall realCall = ((ExchangeFinder)object18).call;
            object3.getClass();
            Intrinsics.checkNotNullParameter(realCall, "call");
            return object2;
        }
        Object object19 = object3;
        Object object20 = object3;
        // MONITORENTER : realConnection6
        ((ExchangeFinder)object20).connectionPool.put(realConnection6);
        ((ExchangeFinder)object20).call.acquireConnectionNoEvents(realConnection6);
        object3 = ((ExchangeFinder)object19).eventListener;
        RealCall realCall = ((ExchangeFinder)object19).call;
        object3.getClass();
        Intrinsics.checkNotNullParameter(realCall, "call");
        return realConnection6;
    }
}

