/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.relocated.com.squareup.moshi;

import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonDataException;
import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonEncodingException;
import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonReader;
import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonReader$Options;
import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonReader$Token;
import com.apollographql.apollo3.relocated.com.squareup.moshi.JsonValueReader$JsonIterator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonValueReader
extends JsonReader {
    public static final Object JSON_READER_CLOSED = new Object();
    public Object[] stack;

    public JsonValueReader(Object object) {
        JsonValueReader jsonValueReader = this;
        int n = this.stackSize;
        jsonValueReader.scopes[n] = 7;
        Object[] objectArray = new Object[32];
        Object[] objectArray2 = objectArray;
        this.stack = objectArray2;
        this.stackSize = n + 1;
        objectArray[n] = object;
    }

    public JsonValueReader(JsonValueReader jsonValueReader) {
        super(jsonValueReader);
        this.stack = (Object[])jsonValueReader.stack.clone();
        for (int i = 0; i < this.stackSize; ++i) {
            Object[] objectArray = this.stack;
            Object object = this.stack[i];
            if (!(object instanceof JsonValueReader$JsonIterator)) continue;
            objectArray[i] = ((JsonValueReader$JsonIterator)object).clone();
        }
    }

    @Override
    public final void beginArray() {
        JsonValueReader$JsonIterator jsonValueReader$JsonIterator;
        Object object = (List)this.require(List.class, JsonReader$Token.BEGIN_ARRAY);
        JsonValueReader$JsonIterator jsonValueReader$JsonIterator2 = jsonValueReader$JsonIterator;
        JsonValueReader jsonValueReader = this;
        List list = object;
        object = JsonReader$Token.END_ARRAY;
        jsonValueReader$JsonIterator2((JsonReader$Token)((Object)object), list.toArray(new Object[list.size()]), 0);
        int n = this.stackSize - 1;
        jsonValueReader.stack[n] = jsonValueReader$JsonIterator2;
        jsonValueReader.scopes[n] = 1;
        jsonValueReader.pathIndices[n] = 0;
        if (jsonValueReader$JsonIterator.hasNext()) {
            this.push(jsonValueReader$JsonIterator2.next());
        }
    }

    @Override
    public final void endArray() {
        JsonReader$Token jsonReader$Token = JsonReader$Token.END_ARRAY;
        JsonValueReader$JsonIterator jsonValueReader$JsonIterator = (JsonValueReader$JsonIterator)this.require(JsonValueReader$JsonIterator.class, jsonReader$Token);
        if (jsonValueReader$JsonIterator.endToken == jsonReader$Token && !jsonValueReader$JsonIterator.hasNext()) {
            this.remove();
            return;
        }
        throw this.typeMismatch(jsonValueReader$JsonIterator, (Object)jsonReader$Token);
    }

    @Override
    public final void beginObject() {
        JsonValueReader$JsonIterator jsonValueReader$JsonIterator;
        Map map = (Map)this.require(Map.class, JsonReader$Token.BEGIN_OBJECT);
        JsonValueReader$JsonIterator jsonValueReader$JsonIterator2 = jsonValueReader$JsonIterator;
        JsonValueReader jsonValueReader = this;
        jsonValueReader$JsonIterator2(JsonReader$Token.END_OBJECT, map.entrySet().toArray(new Object[map.size()]), 0);
        int n = this.stackSize;
        jsonValueReader.stack[n - 1] = jsonValueReader$JsonIterator2;
        jsonValueReader.scopes[n - 1] = 3;
        if (jsonValueReader$JsonIterator.hasNext()) {
            this.push(jsonValueReader$JsonIterator2.next());
        }
    }

    @Override
    public final void endObject() {
        JsonReader$Token jsonReader$Token = JsonReader$Token.END_OBJECT;
        JsonValueReader$JsonIterator jsonValueReader$JsonIterator = (JsonValueReader$JsonIterator)this.require(JsonValueReader$JsonIterator.class, jsonReader$Token);
        if (jsonValueReader$JsonIterator.endToken == jsonReader$Token && !jsonValueReader$JsonIterator.hasNext()) {
            JsonValueReader jsonValueReader = this;
            jsonValueReader.pathNames[this.stackSize - 1] = null;
            jsonValueReader.remove();
            return;
        }
        throw this.typeMismatch(jsonValueReader$JsonIterator, (Object)jsonReader$Token);
    }

    @Override
    public final boolean hasNext() {
        int n = ((JsonReader)object).stackSize;
        if (n == 0) {
            return false;
        }
        Object object = ((JsonValueReader)object).stack[n - 1];
        return !(object instanceof Iterator) || ((Iterator)object).hasNext();
    }

    @Override
    public final JsonReader$Token peek() {
        int n = this.stackSize;
        if (n == 0) {
            return JsonReader$Token.END_DOCUMENT;
        }
        Object object = this.stack[n - 1];
        if (object instanceof JsonValueReader$JsonIterator) {
            return ((JsonValueReader$JsonIterator)object).endToken;
        }
        if (object instanceof List) {
            return JsonReader$Token.BEGIN_ARRAY;
        }
        if (object instanceof Map) {
            return JsonReader$Token.BEGIN_OBJECT;
        }
        if (object instanceof Map.Entry) {
            return JsonReader$Token.NAME;
        }
        if (object instanceof String) {
            return JsonReader$Token.STRING;
        }
        if (object instanceof Boolean) {
            return JsonReader$Token.BOOLEAN;
        }
        if (object instanceof Number) {
            return JsonReader$Token.NUMBER;
        }
        if (object == null) {
            return JsonReader$Token.NULL;
        }
        if (object == JSON_READER_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw this.typeMismatch(object, "a JSON value");
    }

    @Override
    public final String nextName() {
        Object object = JsonReader$Token.NAME;
        Map.Entry entry = (Map.Entry)this.require(Map.Entry.class, (JsonReader$Token)((Object)object));
        Object k = entry.getKey();
        if (k instanceof String) {
            object = (String)k;
            JsonValueReader jsonValueReader = this;
            int n = this.stackSize - 1;
            jsonValueReader.stack[n] = entry.getValue();
            jsonValueReader.pathNames[this.stackSize - 2] = object;
            return object;
        }
        throw this.typeMismatch(k, object);
    }

    @Override
    public final int selectName(JsonReader$Options jsonReader$Options) {
        Object object = JsonReader$Token.NAME;
        Map.Entry entry = (Map.Entry)this.require(Map.Entry.class, (JsonReader$Token)((Object)object));
        Object k = entry.getKey();
        if (k instanceof String) {
            object = (String)k;
            int n = jsonReader$Options.strings.length;
            for (int i = 0; i < n; ++i) {
                if (!jsonReader$Options.strings[i].equals(object)) continue;
                JsonValueReader jsonValueReader = this;
                int n2 = this.stackSize - 1;
                jsonValueReader.stack[n2] = entry.getValue();
                jsonValueReader.pathNames[this.stackSize - 2] = object;
                return i;
            }
            return -1;
        }
        throw this.typeMismatch(k, object);
    }

    @Override
    public final void skipName() {
        if (!this.failOnUnknown) {
            JsonValueReader jsonValueReader = this;
            Map.Entry entry = (Map.Entry)jsonValueReader.require(Map.Entry.class, JsonReader$Token.NAME);
            int n = this.stackSize - 1;
            jsonValueReader.stack[n] = entry.getValue();
            jsonValueReader.pathNames[this.stackSize - 2] = "null";
            return;
        }
        JsonValueReader jsonValueReader = this;
        JsonReader$Token jsonReader$Token = jsonValueReader.peek();
        jsonValueReader.nextName();
        throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)jsonReader$Token) + " at " + this.getPath());
    }

    @Override
    public final String nextString() {
        int n = this.stackSize;
        Object object = n != 0 ? this.stack[n - 1] : null;
        if (object instanceof String) {
            this.remove();
            return (String)object;
        }
        if (object instanceof Number) {
            this.remove();
            return object.toString();
        }
        if (object == JSON_READER_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw this.typeMismatch(object, (Object)JsonReader$Token.STRING);
    }

    @Override
    public final int selectString(JsonReader$Options jsonReader$Options) {
        int n = this.stackSize;
        Object object = n != 0 ? this.stack[n - 1] : null;
        if (!(object instanceof String)) {
            if (object != JSON_READER_CLOSED) {
                return -1;
            }
            throw new IllegalStateException("JsonReader is closed");
        }
        object = (String)object;
        int n2 = jsonReader$Options.strings.length;
        for (int i = 0; i < n2; ++i) {
            if (!jsonReader$Options.strings[i].equals(object)) continue;
            this.remove();
            return i;
        }
        return -1;
    }

    @Override
    public final boolean nextBoolean() {
        JsonValueReader jsonValueReader = bl;
        Boolean bl = (Boolean)jsonValueReader.require(Boolean.class, JsonReader$Token.BOOLEAN);
        jsonValueReader.remove();
        return bl;
    }

    @Override
    public final void nextNull() {
        JsonValueReader jsonValueReader = this;
        jsonValueReader.require(Void.class, JsonReader$Token.NULL);
        jsonValueReader.remove();
    }

    @Override
    public final double nextDouble() {
        Object object;
        JsonReader$Token jsonReader$Token;
        block8: {
            double d;
            block7: {
                block6: {
                    jsonReader$Token = JsonReader$Token.NUMBER;
                    object = this.require(Object.class, jsonReader$Token);
                    if (!(object instanceof Number)) break block6;
                    d = ((Number)object).doubleValue();
                    break block7;
                }
                if (!(object instanceof String)) break block8;
                try {
                    d = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.typeMismatch(object, (Object)JsonReader$Token.NUMBER);
                }
            }
            if (!this.lenient && (Double.isNaN(d) || Double.isInfinite(d))) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2("JSON forbids NaN and infinities: ");
                throw new JsonEncodingException(stringBuilder.append(d).append(" at path ").append(this.getPath()).toString());
            }
            this.remove();
            return d;
        }
        throw this.typeMismatch(object, (Object)jsonReader$Token);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final long nextLong() {
        long l;
        JsonReader$Token jsonReader$Token = JsonReader$Token.NUMBER;
        Object object = this.require(Object.class, jsonReader$Token);
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        } else {
            long l2;
            if (!(object instanceof String)) {
                throw this.typeMismatch(object, (Object)jsonReader$Token);
            }
            try {
                l2 = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    l2 = new BigDecimal((String)object).longValueExact();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw this.typeMismatch(object, (Object)JsonReader$Token.NUMBER);
                }
            }
            l = l2;
        }
        this.remove();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int nextInt() {
        int n;
        JsonReader$Token jsonReader$Token = JsonReader$Token.NUMBER;
        Object object = this.require(Object.class, jsonReader$Token);
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else {
            int n2;
            if (!(object instanceof String)) {
                throw this.typeMismatch(object, (Object)jsonReader$Token);
            }
            try {
                n2 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n2 = new BigDecimal((String)object).intValueExact();
                }
                catch (NumberFormatException numberFormatException2) {
                    throw this.typeMismatch(object, (Object)JsonReader$Token.NUMBER);
                }
            }
            n = n2;
        }
        this.remove();
        return n;
    }

    @Override
    public final void skipValue() {
        block4: {
            block5: {
                block8: {
                    block7: {
                        int n;
                        block6: {
                            Object object;
                            if (this.failOnUnknown) break block4;
                            n = this.stackSize;
                            if (n > 1) {
                                this.pathNames[n - 2] = "null";
                            }
                            if ((object = n != 0 ? this.stack[n - 1] : null) instanceof JsonValueReader$JsonIterator) break block5;
                            if (!(object instanceof Map.Entry)) break block6;
                            int n2 = n - 1;
                            this.stack[n2] = ((Map.Entry)this.stack[n - 1]).getValue();
                            break block7;
                        }
                        if (n <= 0) break block8;
                        this.remove();
                    }
                    return;
                }
                throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
            }
            throw new JsonDataException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
        }
        throw new JsonDataException("Cannot skip unexpected " + (Object)((Object)this.peek()) + " at " + this.getPath());
    }

    @Override
    public final JsonReader peekJson() {
        return new JsonValueReader(this);
    }

    @Override
    public final void promoteNameToValue() {
        if (this.hasNext()) {
            JsonValueReader jsonValueReader = this;
            jsonValueReader.push(jsonValueReader.nextName());
        }
    }

    @Override
    public final void close() {
        JsonValueReader jsonValueReader = this;
        Arrays.fill(jsonValueReader.stack, 0, this.stackSize, null);
        jsonValueReader.stack[0] = JSON_READER_CLOSED;
        jsonValueReader.scopes[0] = 8;
        jsonValueReader.stackSize = 1;
    }

    public final void push(Object object) {
        int n = this.stackSize;
        if (n == this.stack.length) {
            if (n != 256) {
                JsonValueReader jsonValueReader = this;
                jsonValueReader.scopes = Arrays.copyOf(jsonValueReader.scopes, jsonValueReader.scopes.length * 2);
                jsonValueReader.pathNames = Arrays.copyOf(jsonValueReader.pathNames, jsonValueReader.pathNames.length * 2);
                jsonValueReader.pathIndices = Arrays.copyOf(jsonValueReader.pathIndices, jsonValueReader.pathIndices.length * 2);
                jsonValueReader.stack = Arrays.copyOf(jsonValueReader.stack, jsonValueReader.stack.length * 2);
            } else {
                throw new JsonDataException("Nesting too deep at " + this.getPath());
            }
        }
        int n2 = this.stackSize;
        this.stackSize = n2 + 1;
        this.stack[n2] = object;
    }

    public final Object require(Class clazz, JsonReader$Token jsonReader$Token) {
        int n = this.stackSize;
        Object object = n != 0 ? this.stack[n - 1] : null;
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        if (object == null && jsonReader$Token == JsonReader$Token.NULL) {
            return null;
        }
        if (object == JSON_READER_CLOSED) {
            throw new IllegalStateException("JsonReader is closed");
        }
        throw this.typeMismatch(object, (Object)jsonReader$Token);
    }

    public final void remove() {
        int n = this.stackSize - 1;
        JsonValueReader jsonValueReader = this;
        jsonValueReader.stackSize = n;
        Object[] objectArray = jsonValueReader.stack;
        jsonValueReader.stack[n] = null;
        jsonValueReader.scopes[n] = 0;
        if (n > 0) {
            int n2 = n--;
            this.pathIndices[n] = this.pathIndices[n] + 1;
            Object object = objectArray[n2 - 1];
            if (object instanceof Iterator && (object = (Iterator)object).hasNext()) {
                this.push(object.next());
            }
        }
    }
}

