/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.tls;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import com.apollographql.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    public final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        Intrinsics.checkNotNullParameter(trustRootIndex, "trustRootIndex");
        this.trustRootIndex = trustRootIndex;
    }

    @Override
    public final List clean(String object, List arrayList) {
        ArrayList arrayList2;
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter(arrayList, "chain");
        Intrinsics.checkNotNullParameter(object, "hostname");
        object = arrayDeque;
        arrayDeque = new ArrayDeque(arrayList);
        arrayList = arrayList2;
        arrayList();
        Object e = ((ArrayDeque)object).removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, "queue.removeFirst()");
        arrayList2.add(e);
        boolean bl = false;
        int n = 9;
        block4: for (int i = 0; i < n; ++i) {
            ArrayList<Object> arrayList3 = arrayList;
            Object object2 = arrayList3.get(arrayList3.size() - 1);
            if (object2 != null) {
                Object object3 = this.trustRootIndex.findByIssuerAndSignature((X509Certificate)(object2 = (X509Certificate)object2));
                if (object3 != null) {
                    if (arrayList.size() > 1 || Intrinsics.areEqual(object2, object3) ^ true) {
                        arrayList.add(object3);
                    }
                    if (!(Intrinsics.areEqual(((X509Certificate)object3).getIssuerDN(), ((X509Certificate)object3).getSubjectDN()) ^ true)) {
                        try {
                            Object object4 = object3;
                            ((Certificate)object4).verify(((Certificate)object4).getPublicKey());
                            bl = true;
                        }
                        catch (GeneralSecurityException generalSecurityException) {}
                    }
                    bl = false;
                    if (bl) {
                        return arrayList;
                    }
                    bl = true;
                    continue;
                }
                object3 = ((ArrayDeque)object).iterator();
                Intrinsics.checkNotNullExpressionValue(object3, "queue.iterator()");
                while (object3.hasNext()) {
                    Object object5 = object3.next();
                    if (object5 != null) {
                        boolean bl2;
                        object5 = (X509Certificate)object5;
                        if (!(Intrinsics.areEqual(((X509Certificate)object2).getIssuerDN(), ((X509Certificate)object5).getSubjectDN()) ^ true)) {
                            try {
                                ((Certificate)object2).verify(((Certificate)object5).getPublicKey());
                                bl2 = true;
                            }
                            catch (GeneralSecurityException generalSecurityException) {}
                        }
                        bl2 = false;
                        if (!bl2) continue;
                        object3.remove();
                        arrayList.add(object5);
                        continue block4;
                    }
                    throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                }
                if (bl) {
                    return arrayList;
                }
                throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + object2);
            }
            throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
        }
        throw new SSLPeerUnverifiedException("Certificate chain too long: " + arrayList);
    }

    public final int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicCertificateChainCleaner)) return false;
        if (!Intrinsics.areEqual(((BasicCertificateChainCleaner)object).trustRootIndex, this.trustRootIndex)) return false;
        return true;
    }
}

