/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.platform;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.Protocol;
import com.apollographql.relocated.okhttp3.internal.platform.OpenJSSEPlatform$Companion;
import com.apollographql.relocated.okhttp3.internal.platform.Platform;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.net.ssl.OpenJSSE;

public final class OpenJSSEPlatform
extends Platform {
    public static final boolean isSupported;
    public final Provider provider = (Provider)new OpenJSSE();

    static {
        boolean bl;
        String string = "org.openjsse.net.ssl.OpenJSSE";
        try {
            Class.forName(string, false, OpenJSSEPlatform$Companion.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public final SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "SSLContext.getInstance(\"TLSv1.3\", provider)");
        return sSLContext;
    }

    @Override
    public final X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), ((OpenJSSEPlatform)object).provider);
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        object = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(object, "java.util.Arrays.toString(this)");
        object = "Unexpected default trust managers: ".concat((String)object);
        throw new IllegalStateException(object.toString());
    }

    @Override
    public final void configureTlsExtensions(javax.net.ssl.SSLSocket object, String sSLParameters, List stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "protocols");
        if (object instanceof SSLSocket && (object = (this = (SSLSocket)object).getSSLParameters()) instanceof org.openjsse.javax.net.ssl.SSLParameters) {
            ArrayList arrayList;
            ArrayList arrayList2;
            sSLParameters = arrayList2;
            arrayList2 = new ArrayList();
            stringArray = stringArray.iterator();
            while (stringArray.hasNext()) {
                Object e = stringArray.next();
                if (!((Protocol)((Object)e) != Protocol.HTTP_1_0)) continue;
                ((ArrayList)sSLParameters).add(e);
            }
            stringArray = arrayList;
            arrayList = new ArrayList(((ArrayList)sSLParameters).size());
            sSLParameters = ((ArrayList)sSLParameters).iterator();
            while (sSLParameters.hasNext()) {
                ((ArrayList)stringArray).add(((Protocol)((Object)sSLParameters.next())).protocol);
            }
            sSLParameters = (org.openjsse.javax.net.ssl.SSLParameters)object;
            if ((stringArray = ((ArrayList)stringArray).toArray(new String[0])) != null) {
                sSLParameters.setApplicationProtocols((String[])stringArray);
                this.setSSLParameters((SSLParameters)object);
            } else {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
        }
    }

    @Override
    public final String getSelectedProtocol(javax.net.ssl.SSLSocket sSLSocket) {
        if (!(sSLSocket instanceof SSLSocket) || (object = ((SSLSocket)sSLSocket).getApplicationProtocol()) == null || ((String)object).hashCode() == 0 && ((String)object).equals("")) {
            Object object = null;
        }
        return object;
    }
}

