/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.platform;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.Protocol;
import com.apollographql.relocated.okhttp3.internal.platform.ConscryptPlatform$Companion;
import com.apollographql.relocated.okhttp3.internal.platform.ConscryptPlatform$DisabledHostnameVerifier;
import com.apollographql.relocated.okhttp3.internal.platform.Platform;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.Conscrypt;
import org.conscrypt.ConscryptHostnameVerifier;

public final class ConscryptPlatform
extends Platform {
    public static final boolean isSupported;
    public final Provider provider;

    public ConscryptPlatform() {
        Provider provider = Conscrypt.newProvider();
        Intrinsics.checkNotNullExpressionValue(provider, "Conscrypt.newProvider()");
        v0.provider = provider;
    }

    static {
        boolean bl;
        block17: {
            block11: {
                boolean bl2;
                block16: {
                    block13: {
                        block14: {
                            Conscrypt.Version version2;
                            block15: {
                                int n;
                                block12: {
                                    String string = "org.conscrypt.Conscrypt$Version";
                                    Class.forName(string, false, ConscryptPlatform$Companion.class.getClassLoader());
                                    if (!Conscrypt.isAvailable()) break block11;
                                    int n2 = 2;
                                    n = 1;
                                    version2 = Conscrypt.version();
                                    if (version2.major() == n2) break block12;
                                    if (version2.major() <= n2) break block13;
                                    break block14;
                                }
                                if (version2.minor() == n) break block15;
                                if (version2.minor() <= n) break block13;
                                break block14;
                            }
                            try {
                                if (version2.patch() < 0) break block13;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                break block11;
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {}
                        }
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
                if (!bl2) break block11;
                bl = true;
                break block17;
            }
            bl = false;
        }
        isSupported = bl;
    }

    @Override
    public final SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "SSLContext.getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    public final X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                X509TrustManager x509TrustManager = (X509TrustManager)object;
                Conscrypt.setHostnameVerifier((TrustManager)x509TrustManager, (ConscryptHostnameVerifier)ConscryptPlatform$DisabledHostnameVerifier.INSTANCE);
                return x509TrustManager;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        object = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(object, "java.util.Arrays.toString(this)");
        object = "Unexpected default trust managers: ".concat((String)object);
        throw new IllegalStateException(object.toString());
    }

    @Override
    public final void configureTlsExtensions(SSLSocket sSLSocket, String object, List list2) {
        Intrinsics.checkNotNullParameter(list2, "protocols");
        if (Conscrypt.isConscrypt((SSLSocket)sSLSocket)) {
            ArrayList arrayList;
            ArrayList arrayList2;
            Conscrypt.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
            String[] stringArray = arrayList2;
            arrayList2 = new ArrayList();
            for (List list2 : list2) {
                if (!((Protocol)((Object)list2) != Protocol.HTTP_1_0)) continue;
                stringArray.add((List)list2);
            }
            object = arrayList;
            arrayList = new ArrayList(stringArray.size());
            stringArray = stringArray.iterator();
            while (stringArray.hasNext()) {
                ((ArrayList)object).add(((Protocol)((Object)stringArray.next())).protocol);
            }
            stringArray = ((ArrayList)object).toArray(new String[0]);
            if (stringArray != null) {
                Conscrypt.setApplicationProtocols((SSLSocket)sSLSocket, (String[])stringArray);
            } else {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
        }
    }

    @Override
    public final String getSelectedProtocol(SSLSocket sSLSocket) {
        return Conscrypt.isConscrypt((SSLSocket)sSLSocket) ? Conscrypt.getApplicationProtocol((SSLSocket)sSLSocket) : null;
    }

    @Override
    public final SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        SSLContext sSLContext = trustManagerArray2.newSSLContext();
        TrustManager[] trustManagerArray = new TrustManager[1];
        TrustManager[] trustManagerArray2 = trustManagerArray;
        trustManagerArray[0] = x509TrustManager;
        sSLContext.init(null, trustManagerArray2, null);
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue(sSLSocketFactory, "newSSLContext().apply {\n\u2026null)\n    }.socketFactory");
        return sSLSocketFactory;
    }
}

