/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.Address;
import java.net.InetSocketAddress;
import java.net.Proxy;

public final class Route {
    public final Address address;
    public final Proxy proxy;
    public final InetSocketAddress socketAddress;

    public Route(Address address, Proxy proxy, InetSocketAddress inetSocketAddress) {
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(inetSocketAddress, "socketAddress");
        this.address = address;
        this.proxy = proxy;
        this.socketAddress = inetSocketAddress;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object object) {
        if (!(object instanceof Route)) return false;
        object = (Route)object;
        if (!Intrinsics.areEqual(((Route)object).address, this.address)) return false;
        if (!Intrinsics.areEqual(((Route)object).proxy, this.proxy)) return false;
        if (!Intrinsics.areEqual(((Route)object).socketAddress, this.socketAddress)) return false;
        return true;
    }

    public final int hashCode() {
        Route route = this;
        int n = (route.address.hashCode() + 527) * 31;
        n = (route.proxy.hashCode() + n) * 31;
        return route.socketAddress.hashCode() + n;
    }

    public final String toString() {
        return "Route{" + this.socketAddress + '}';
    }
}

