/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio;

import com.apollographql.relocated.okio.Segment;
import java.util.concurrent.atomic.AtomicReference;

public abstract class SegmentPool {
    public static final Segment LOCK;
    public static final int HASH_BUCKET_COUNT;
    public static final AtomicReference[] hashBuckets;

    public static final Segment take() {
        Segment segment;
        AtomicReference atomicReference = hashBuckets[(int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L)];
        Segment segment2 = atomicReference.getAndSet(segment = LOCK);
        if (segment2 == segment) {
            return new Segment();
        }
        if (segment2 == null) {
            atomicReference.set(null);
            return new Segment();
        }
        atomicReference.set(segment2.next);
        segment2.next = null;
        segment2.limit = 0;
        return segment2;
    }

    public static final void recycle(Segment segment) {
        if (segment.next == null && segment.prev == null) {
            if (segment.shared) {
                return;
            }
            AtomicReference atomicReference = hashBuckets[(int)(Thread.currentThread().getId() & (long)HASH_BUCKET_COUNT - 1L)];
            Segment segment2 = (Segment)atomicReference.get();
            if (segment2 == LOCK) {
                return;
            }
            int n = segment2 != null ? segment2.limit : 0;
            if (n >= 65536) {
                return;
            }
            Segment segment3 = segment;
            segment3.next = segment2;
            segment3.pos = 0;
            segment.limit = n + 8192;
            if (!atomicReference.compareAndSet(segment2, segment)) {
                segment.next = null;
            }
            return;
        }
        throw new IllegalArgumentException("Failed requirement.".toString());
    }

    static {
        int n;
        LOCK = new Segment(new byte[0], 0, 0, false);
        HASH_BUCKET_COUNT = n = Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 2 - 1);
        AtomicReference[] atomicReferenceArray = new AtomicReference[n];
        for (int i = 0; i < n; ++i) {
            AtomicReference atomicReference;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            atomicReferenceArray[i] = atomicReference2;
        }
        hashBuckets = atomicReferenceArray;
    }
}

