/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okio;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okio.FileHandle;
import com.apollographql.relocated.okio.FileMetadata;
import com.apollographql.relocated.okio.JvmSystemFileSystem;
import com.apollographql.relocated.okio.NioSystemFileSystem;
import com.apollographql.relocated.okio.Path;
import com.apollographql.relocated.okio.Path$Companion;
import com.apollographql.relocated.okio.internal.ResourceFileSystem;

public abstract class FileSystem {
    public static final JvmSystemFileSystem SYSTEM;

    static {
        NioSystemFileSystem nioSystemFileSystem;
        Class.forName("java.nio.file.Files");
        JvmSystemFileSystem jvmSystemFileSystem = nioSystemFileSystem;
        try {
            nioSystemFileSystem = new NioSystemFileSystem();
        }
        catch (ClassNotFoundException classNotFoundException) {
            JvmSystemFileSystem jvmSystemFileSystem2;
            jvmSystemFileSystem = jvmSystemFileSystem2;
            jvmSystemFileSystem2 = new JvmSystemFileSystem();
        }
        SYSTEM = jvmSystemFileSystem;
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue(string, "getProperty(\"java.io.tmpdir\")");
        Path$Companion.get(string, false);
        ClassLoader classLoader = ResourceFileSystem.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "ResourceFileSystem::class.java.classLoader");
        new ResourceFileSystem(classLoader);
    }

    public abstract FileMetadata metadataOrNull(Path var1);

    public abstract FileHandle openReadOnly(Path var1);
}

