/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.okhttp3.internal.tls;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.relocated.okhttp3.internal.tls.TrustRootIndex;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class BasicTrustRootIndex
implements TrustRootIndex {
    public final Map subjectToCaCerts;

    public BasicTrustRootIndex(X509Certificate ... x509CertificateArray) {
        LinkedHashMap linkedHashMap;
        Intrinsics.checkNotNullParameter(x509CertificateArray, "caCerts");
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (X509Certificate x509Certificate : x509CertificateArray) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            Intrinsics.checkNotNullExpressionValue(x500Principal, "caCert.subjectX500Principal");
            Object object = linkedHashMap2.get(x500Principal);
            if (object == null) {
                LinkedHashSet linkedHashSet;
                object = linkedHashSet;
                linkedHashSet = new LinkedHashSet();
                linkedHashMap2.put(x500Principal, object);
            }
            ((Set)object).add(x509Certificate);
        }
        this.subjectToCaCerts = linkedHashMap2;
    }

    @Override
    public final X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        BasicTrustRootIndex basicTrustRootIndex = iterator2;
        Iterator iterator2 = x509Certificate.getIssuerX500Principal();
        if ((iterator2 = (Set)((LinkedHashMap)basicTrustRootIndex.subjectToCaCerts).get(iterator2)) != null) {
            Object var2_2;
            block4: {
                iterator2 = iterator2.iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    Object t = iterator2.next();
                    var2_2 = t;
                    try {
                        x509Certificate.verify(((X509Certificate)t).getPublicKey());
                        bl = true;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) continue;
                    break block4;
                }
                var2_2 = null;
            }
            return var2_2;
        }
        return null;
    }

    public final boolean equals(Object object) {
        return object == this || object instanceof BasicTrustRootIndex && Intrinsics.areEqual(((BasicTrustRootIndex)object).subjectToCaCerts, this.subjectToCaCerts);
    }

    public final int hashCode() {
        return ((Object)this.subjectToCaCerts).hashCode();
    }
}

