/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.kotlin.jvm.internal;

import com.apollographql.relocated.kotlin.jvm.internal.Intrinsics;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public abstract class CollectionToArray {
    public static final Object[] EMPTY = new Object[0];

    /*
     * Enabled aggressive block sorting
     */
    public static final Object[] toArray(Collection object) {
        Object object2 = object;
        Intrinsics.checkNotNullParameter(object2, "collection");
        int n = object2.size();
        if (n == 0) return EMPTY;
        if (!(object = object.iterator()).hasNext()) {
            return EMPTY;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (true) {
            int n3 = n2 + 1;
            objectArray[n2] = object.next();
            if (n3 >= objectArray.length) {
                if (!object.hasNext()) {
                    return objectArray;
                }
                n2 = n3 * 3 + 1 >>> 1;
                if (n2 <= n3) {
                    if (n3 >= 0x7FFFFFFD) throw new OutOfMemoryError();
                    n2 = 0x7FFFFFFD;
                }
                objectArray = Arrays.copyOf(objectArray, n2);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(result, newSize)");
                n2 = n3;
                continue;
            }
            if (!object.hasNext()) {
                object = Arrays.copyOf(objectArray, n3);
                Intrinsics.checkNotNullExpressionValue(object, "copyOf(result, size)");
                return object;
            }
            n2 = n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Object[] toArray(Collection object, Object[] object2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(object, "collection");
        object2.getClass();
        int n = object.size();
        if (n == 0) {
            if (((Object)object2).length <= 0) return object2;
            object2[0] = null;
            return object2;
        }
        if (!(object = object.iterator()).hasNext()) {
            if (((Object)object2).length <= 0) return object2;
            object2[0] = null;
            return object2;
        }
        if (n <= ((Object)object2).length) {
            objectArray = object2;
        } else {
            Object object3 = Array.newInstance(object2.getClass().getComponentType(), n);
            Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = (Object[])object3;
        }
        int n2 = 0;
        while (true) {
            int n3 = n2 + 1;
            objectArray[n2] = object.next();
            if (n3 >= objectArray.length) {
                if (!object.hasNext()) {
                    return objectArray;
                }
                n2 = n3 * 3 + 1 >>> 1;
                if (n2 <= n3) {
                    if (n3 >= 0x7FFFFFFD) throw new OutOfMemoryError();
                    n2 = 0x7FFFFFFD;
                }
                objectArray = Arrays.copyOf(objectArray, n2);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(result, newSize)");
                n2 = n3;
                continue;
            }
            if (!object.hasNext()) {
                if (objectArray == object2) {
                    object2[n3] = null;
                    return object2;
                } else {
                    object = Arrays.copyOf(objectArray, n3);
                    Intrinsics.checkNotNullExpressionValue(object, "copyOf(result, size)");
                    return object;
                }
            }
            n2 = n3;
        }
    }
}

