/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.relocated.com.squareup.moshi;

import com.apollographql.relocated.com.squareup.moshi.JsonDataException;
import com.apollographql.relocated.com.squareup.moshi.JsonEncodingException;
import com.apollographql.relocated.com.squareup.moshi.JsonReader$Options;
import com.apollographql.relocated.com.squareup.moshi.JsonReader$Token;
import java.io.Closeable;
import java.util.Arrays;

public abstract class JsonReader
implements Closeable {
    public int stackSize;
    public int[] scopes;
    public String[] pathNames;
    public int[] pathIndices;
    public boolean lenient;
    public boolean failOnUnknown;

    public JsonReader() {
        this.scopes = new int[32];
        this.pathNames = new String[32];
        this.pathIndices = new int[32];
    }

    public JsonReader(JsonReader jsonReader) {
        this.stackSize = jsonReader.stackSize;
        this.scopes = (int[])jsonReader.scopes.clone();
        this.pathNames = (String[])jsonReader.pathNames.clone();
        this.pathIndices = (int[])jsonReader.pathIndices.clone();
        this.lenient = jsonReader.lenient;
        this.failOnUnknown = jsonReader.failOnUnknown;
    }

    public final void pushScope(int n) {
        int n2 = this.stackSize;
        int[] nArray = this.scopes;
        if (n2 == this.scopes.length) {
            if (n2 != 256) {
                JsonReader jsonReader = this;
                jsonReader.scopes = Arrays.copyOf(nArray, nArray.length * 2);
                jsonReader.pathNames = Arrays.copyOf(jsonReader.pathNames, jsonReader.pathNames.length * 2);
                jsonReader.pathIndices = Arrays.copyOf(jsonReader.pathIndices, jsonReader.pathIndices.length * 2);
            } else {
                throw new JsonDataException("Nesting too deep at " + this.getPath());
            }
        }
        int n3 = this.stackSize;
        this.stackSize = n3 + 1;
        this.scopes[n3] = n;
    }

    public final JsonDataException typeMismatch(Object object, Object object2) {
        if (object == null) {
            return new JsonDataException("Expected " + object2 + " but was null at path " + this.getPath());
        }
        return new JsonDataException("Expected " + object2 + " but was " + object + ", a " + object.getClass().getName() + ", at path " + this.getPath());
    }

    public abstract void beginArray();

    public abstract void endArray();

    public abstract void beginObject();

    public abstract void endObject();

    public abstract boolean hasNext();

    public abstract JsonReader$Token peek();

    public abstract String nextName();

    public abstract int selectName(JsonReader$Options var1);

    public abstract void skipName();

    public abstract String nextString();

    public abstract int selectString(JsonReader$Options var1);

    public abstract boolean nextBoolean();

    public abstract double nextDouble();

    public abstract long nextLong();

    public abstract int nextInt();

    public abstract void skipValue();

    public abstract JsonReader peekJson();

    public final String getPath() {
        StringBuilder stringBuilder;
        JsonReader jsonReader = this;
        int n = jsonReader.stackSize;
        int[] nArray = jsonReader.scopes;
        String[] stringArray = jsonReader.pathNames;
        int[] nArray2 = jsonReader.pathIndices;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("$");
        block4: for (int i = 0; i < n; ++i) {
            switch (nArray[i]) {
                default: {
                    continue block4;
                }
                case 3: 
                case 4: 
                case 5: {
                    stringBuilder2.append('.');
                    String string = stringArray[i];
                    if (string == null) continue block4;
                    stringBuilder2.append(string);
                    continue block4;
                }
                case 1: 
                case 2: {
                    stringBuilder2.append('[').append(nArray2[i]).append(']');
                }
            }
        }
        return stringBuilder2.toString();
    }

    public abstract void promoteNameToValue();

    public final void syntaxError(String string) {
        throw new JsonEncodingException(string + " at path " + this.getPath());
    }

    public abstract void nextNull();
}

